/* ********************************************************************* */
/*                                                                       */
/*   File:       APPLY.CMD                                               */
/*   Version:    1.0                                                     */
/*   Date:       1.7.1993                                                */
/*                                                                       */
/*   (c) EDV Beratung L. Braeuer, 1993                                   */
/*                                                                       */
/*   Purpose:    Apply access rights to all subdirectories               */
/*                                                                       */
/*               SYNTAX:   APPLY  \\{server}  {srvdir}:\{srvdir}\        */
/*                                                                       */
/* ********************************************************************* */

Server     = ""
Resource   = ""

PARSE UPPER ARG Server Resource

IF Server = "" | Resource = "" THEN DO
   SAY
   SAY 'Invalid syntax: APPLY  \\{server}  {srvdir}:\{srvdir}\'
   SAY
   EXIT
   END

/*                                                                       */
/*  Initialize REXXLAN                                                   */
/*                                                                       */
call rxfuncadd NetLoadFuncs, RXLAN30, NetLoadFuncs
CALL NetLoadFuncs

/*                                                                       */
/*  Initialize SYSUTIL function SysFileTree                              */
/*                                                                       */
CALL RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'


/*                                                                       */
/*  Get Access Rights of BaseDirectory                                   */
/*                                                                       */
ret = NetAccessGetInfo( Server, Resource, 1, 'ACCINFO', '', '' )

IF ret <> 0 THEN DO
   SIGNAL Error
   END

/*                                                             */
/* Translate a servers local path specification to an UNC name */
/* e.g. server = \\ADMIN    and Resource= C:\IBMLAN            */
/* UNCName = \\ADMIN\C$\IBMLAN\                                */
/*                                                             */
UNCName = Server || '\' || SUBSTR( Resource, 1, 1 ) || '$' || SUBSTR( Resource, 3 ) || '\'
BasePathLen = LENGTH( UNCName )

CALL SysFileTree UNCName,'Files','DS'     /* Scan all subdirectories for directories */

DO i = 1 TO Files.0
    LocalName = Resource || '\' || SUBSTR( WORD( Files.i, 5 ), BasePathLen+1 )
    SAY 'Applying ACL to ' || LocalName
    Accinfo.acc1_resource_name = LocalName

/* Try an NetAccessAdd to add a new ACL entry. If this fails, assume there */
/* already was an ACL entry. Try to change this through NetAccessSetInfo   */
/* if this fails, abort program.                                           */

    ret = NetAccessAdd( server, 1, 'ACCINFO', '' )
    IF ret <> 0 THEN DO
       ret = NetAccessSetInfo( server, LocalName, 1, 'ACCINFO', '', '0' )
       IF ret <> 0 THEN DO
          SIGNAL Error
          END
       END
    END

SAY 'Apply successfully completed.'

ERROR:
IF ret <> 0 THEN DO
   SAY 'Apply aborted.'
   SAY 'Reason: '
   SAY NetRexxGetMessage( ret )
   SAY
/*                                                                       */
/* free REXXLAN resources                                                */
/*                                                                       */
CALL Netdropfuncs

