{$M $4000,0,0}

uses crt,dos;

const
    amgstr : string[80] = 'AMG 2.2 Copyright (c) 1993 Milen Georgiev. All Rights Reserved. Nov 1 1993    ';
    EmptyStr = '                                              ';

var
    prg, par : string;
    myiorslt : word;
    arcfile : file;
    dirfile, rqstfile : file of pathstr;
    cmnd, ArcName, TarDir, ws, workdir, startdir, amgdir : pathstr;
    i, j, x, y, z : word;
    c : char;
    Time, ArcSize, fileinarc, flen, li, sm : longint;
    ArcCmntLen, FileCmntLen, PathLen : word;
    a, b : byte;
    match, arcexist : boolean;

    password : string[12];
    TotalCmprSize, TotalTextSize, TextFileSize : longint;
	CmprFileCnt, CmprFileSize, FileHdrPos, CmprCodSize : longint;
    FileHeader : array [0..34] of byte;
    ArcHeader : array [0..11] of byte;

    AttrMask : byte;
    stg : word;
    FPath, APath : DirStr;
    FName, AName : NameStr;
    FExt, AExt : ExtStr;
	Attr, NmbRead, NmbWrite : word;


procedure CopyRight;
begin
	writeln(''); writeln('');
    writeln(amgstr);
    writeln('AMG file compression archiver utility. English language Version. ');
end;


procedure hidecursor;
begin
	asm
    mov  ah,3
    mov	 bh,1
    int	 $10
	or	 ch,$20
	mov  ah,1
	int  $10
	end;
end;

procedure showcursor;
begin
	asm
    mov  ah,3
    mov	 bh,1
    int	 $10
	and	 ch,$df
	mov  ah,1
	int  $10
	end;
end;

procedure MessageWin(s : string);
begin
	hidecursor;
	window(10,8,70,12); textbackground(darkgray); textcolor(white);
	clrscr;

    window(1,1,80,25);
    gotoxy(10,8); write('ͻ');
    gotoxy(10,12);write('ͼ');
    for i := 9 to 11 do
    begin
    	gotoxy(10,i);write('');
    end;
    for i := 9 to 11 do
    begin
    	gotoxy(70,i);write('');
    end;

    gotoxy(40- (length(s) div 2),10);
    textcolor(red);
    write(s);
	repeat until keypressed;
    c := readkey; if ord(c) = 0 then c := readkey;
end;




procedure io_error;
var
	s, ss : string;
begin
	case myiorslt of
		2:s := ' File not found';
        3:s := ' Path not found';
        4:s := ' Too many open files';
        5:s := ' Access denied';
        6:s := ' Invalid handle';
        7:s := ' Memory ctrl block destroyed';
        8:s := ' Insufficient memory';
        9:s := ' Invalid memory block adress';
       10:s := ' Invalid environment';
       $b:s := ' Invalid format';
       $c:s := ' Invalid access code';
       $d:s := ' Invalid data';
       $f:s := ' Invalid drive specified';
      $12:s := ' No more matching files';
      $13:s := ' Attempted write on write-protected disk';
      $15:s := ' Disk drive not ready';
      $17:s := ' Disk data error (CRC error)';
      $19:s := ' Disk seek error';
      $1a:s := ' Unknown disk media type';
      $1b:s := ' Disk sector not found';
      $22:s := ' Invalid disk change';
      $50:s := ' File already exist';
      103:s := ' File not open';
      154:s := ' CRC Error in data';
    else
    	s := '';
	end;
    str(myiorslt:4,ss);
    s := 'IO Error ' + s;
	MessageWin(s);
    showcursor;
    textbackground(black); textcolor(lightgray);
    clrscr;
	halt;
end;


procedure CopyFile(fsn, fdn : pathstr);
var
    fs,fd : file;
    Buf : array [0..2047] of byte;
    blen : word;

begin
	assign(fs, fsn);
    assign(fd, fdn);
    GetFAttr(fs,Attr);
    filemode := 0;
	reset(fs,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	GetFTime(fs,Time);
    rewrite(fd,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	flen := filesize(fs);
    sm := 0;
    while (not eof(fs))  do
    begin
    	blockread(fs,Buf,2048,blen);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        blockwrite(fd,Buf,blen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        if blen <> NmbRead then
        begin
        	writeln(''); writeln('Disk Full!');
            Halt(1);
        end;
        sm := sm + blen;
    end;
    close(fs);
    if ioresult <> 0 then io_error;
    SetFTime(fd,Time);
    close(fd);
    if ioresult <> 0 then io_error;
    SetFAttr(fd,Attr);
end;



procedure Done;
begin
    erase(rqstfile);
	ChDir(startdir);
    showcursor;
    textbackground(black);
    textcolor(lightgray);
    clrscr;
    CopyRight;
    halt;
end;

procedure DetWorkDir;
begin
    a := ord(startdir[1]) - 64;
    li := diskfree(a);

    sm := diskfree(3);
   	if sm > li then
    begin
   		a := 3;
        li := sm;
   	end;
    sm := diskfree(4);
   	if sm > li then
    begin
   		a := 4;
        li := sm;
   	end;
    sm := diskfree(5);
   	if sm > li then
    begin
   		a := 5;
        li := sm;
  	end;
	workdir := chr(64+a) + ':\';
    if workdir[length(workdir)] <> '\' then
    	workdir := workdir + '\';

    if li < 20000 then
    begin
    	writeln('');
        writeln('Not enough free disk space to start the program!');
        halt(1);
    end;
end;


procedure Init;
var
    regs : registers;
	i,j: word;
	esg: word;
    s: pathstr;
    d:dirstr;
    n:namestr;
    e:extstr;

begin
	delay(500);

    s:='';
    regs.ah:=$62;
    msdos(regs);
    esg:=memw[regs.bx:44];

	i:=0;
    j:=11;
    repeat
    	j:=memw[esg:i];
        inc(i);
    until j=0;
    i:=i+3;
    while mem[esg:i]<>0 do
    begin
		s:=s+chr(mem[esg:i]);
        inc(i);
    end;

    s := FExpand(s);
    fsplit(s,d,n,e);
    AMGdir := d;
    if (length(AMGdir) = 2) and (AMGdir[length(AMGdir)] = ':') then
		AMGdir := AMGdir + '\';

    if fsearch('rAMG.ovl',AMGdir) = '' then
    begin
    	writeln('');
    	writeln('File RAMG.ovl is not found in AMG directory!');
    	halt;
    end;



	GetDir(0,startdir);

   	DetWorkDir;

    if fsearch('rqstfamg.&&&',workdir) <> '' then
    begin
	    assign(rqstfile,workdir + 'rqstfAMG.&&&');
	    erase(rqstfile);
    end;
    if fsearch('tmpaamg.&&&',workdir) <> '' then
    begin
	    assign(rqstfile,workdir + 'tmpaAMG.&&&');
	    erase(rqstfile);
    end;
    if fsearch('delfamg.&&&',workdir) <> '' then
    begin
	    assign(rqstfile,workdir + 'delfAMG.&&&');
	    erase(rqstfile);
    end;
    assign(rqstfile,workdir + 'rqstfAMG.&&&');
end;

begin
	Init;
    begin
	    if fsearch('mAMG.ovl',AMGdir) = '' then
    	begin
    		writeln('');
	    	writeln('File MAMG.ovl is not found in AMG directory!');
    		halt;
	    end;

		while true do
    	begin
	        showcursor;
    		prg := AMGdir + 'mAMG.ovl';
        	par := startdir + ' ' + workdir + ' ' + AMGdir + ' joro';
	        writeln('');
    	    SwapVectors;
        	Exec(prg,par);
			SwapVectors;
    	    if DosExitCode <> 0 then
        	begin
	        	continue;
    	    end;

        	writeln('');
	        showcursor;
		    assign(rqstfile,workdir + 'rqstfAMG.&&&');
	    	reset(rqstfile);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        	read(rqstfile,ws);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    	    close(rqstfile);
        	if copy(ws,1,5) = 'reset' then
	        begin
    	        continue;
	        end;
        	if copy(ws,1,4) = 'quit' then
	        begin
    	        Done;
	        end;

    		prg := AMGdir + 'rAMG.ovl';
        	par := startdir + ' ' + workdir + ' ' + AMGdir + ' joro';
	        writeln('');
    	    SwapVectors;
        	Exec(prg,par);
			SwapVectors;
    	    if DosExitCode <> 0 then
        	begin
	        	Done;
    	    end;
		end;
    end;
end.
