unit defAMG;
interface

uses crt,dos;
const
    ns = 32003;
    ns2 = ns * 2;
    ns05 = ns div 2;
    ns_6 = ns - 6;
    rnd = 0;
    txt = 1;

    SuperFastCompr = 0;
	FastCompr = 1;
    LessMemCompr = 2;
    NormalCompr = 3;
    MaxCompr = 4;

    cmMemOk = 10000;
    cmNoMem = cmMemOk + 1;
    cmMemErr = cmNoMem + 1;
	StructureErrorMsg = 'The structure of archive was damaged!';
    EmptyStr = '                                              ';

	rqstfn = 8;

type
	b64 = array[0..65527] of byte;
    w32 = array[0..32763] of word;
    pathfile = file of pathstr;

var
    cmnd : PathStr;
    method : byte;
    dosx, dosy : byte;
    posptr, lenptr : array[0..31] of word;
    KeyPtr : word;
	restblock : word;
    password : string[12];
    pass : longint;
    excldpth, mltplvlm : boolean;
    myiorslt : byte;
    arcfile, textfile : file;
    s : string;
    fileinarc : longint;
	ArcSize : longint;
    arcname,textname, delname : pathstr;
    selfiles, procfiles, nmbarcfiles : word;
	selbytes, procbytes : longint;
    c : char;

  	TextBuf : ^b64;
    CmprBuf : ^b64;

    NxtBuflw  : ^b64;
    NxtBufhg  : ^b64;
    FrsBuf    : ^w32;

    SafBuf  : ^b64;

    BstPos,BstLen : word;
    LstPos, LstLen, LstBeg : word;
    TextBuf_seg, CmprBuf_seg : word;
    NxtBuflw_seg, NxtBufhg_seg, FrsBuf_seg : word;
	LastWordPos : word;

    StrCnt : word;
    TextByteCnt, CmprByteCnt : word;
    CmprBitCnt : word;
    CmprBitMsk : byte;
    OrgBlock, CmprBlock, TextBlock : word;
	ps, ls : word;
    NmbWriten, NmbRead, StrPtr : word;
	BlockHeader : word;
    BlockType : byte;

    TotalCmprSize, TotalTextSize, TextFileSize, ArchiveSize : longint;
	CmprFileCnt, CmprFileSize, FileHdrPos, CmprCodSize : longint;
    TextFileCnt : longint;
    FileHdrLen : word;
    FileCmntLen, ArcCmntLen : word;
    PathLen : byte;
    LastBlockPos : longint;
    FileHeader : array [0..34] of byte;
    ArcHeader : array [0..11] of byte;

    List : array [0..1023] of word;
    FreqBigSgn : array [0..511] of word;
    FreqLtlSgn, FreqPos : array [0..31] of word;
    Node, Prnt : array [0..1023] of word;
    ChrLen, HufChr : array [0..511] of word;
    freenodes, NodePtr, PrntPtr, LastLeaf : word;
	root : word;
    PosHufVal, PosHufLen : array [0..31] of word;
    Poslson, Posrson : array [0..64] of word;
    PosTopTree : word;
    LtlSgnHufVal, LtlSgnHufLen : array [0..15] of word;
	BigSgnHufVal, BigSgnHufLen : array [0..511] of word;
{    BigSgnlson, BigSgnrson : array [0..2047] of word;}
    BigSgnTopTree : word;
    LtlSgnlson, LtlSgnrson : array [0..31] of word;
    LtlSgnTopTree : word;
    wl, wc : array [0..511] of word;
    MinBtsBigSgn, MaxBigSgn : word;
    MinBtsPos, MaxPos : word;
    MinBtsLen, MaxLen : word;
    MaxLen2, NextStrBeg : word;


	rqstpath,rqstwild,cursrcdir,ws,ms,pths : pathstr;
    startdir, tardir, AMGdir : pathstr;
    sr : searchrec;
    AttrMask : byte;
    willcards : string[12];
    stg : word;
    FPath, APath : DirStr;
    FName, AName : NameStr;
    FExt, AExt : ExtStr;
    ADrive : byte;
    ADiskFree : longint;
    rqstfile, delfile : pathfile;
    readptr : longint;
    temparc : file;
    workdir : pathstr;
    match, arcexist : boolean;
    flen : longint;
    blen : word;
    Time : longint;
    DT : DateTime;
	Attr : word;
    vlmcnt : word;
    fileisnext, filebecont : boolean;
    crc : longint;
	broken : boolean;
	CmntFileName : PathStr;
    CmntFile: file;
	trycnt : word;
    cfp : longint;
	FixedTree, criterr, TstInt : boolean;

	a, b : byte;
    i, j, k, l, m, n, p, mn, mx : word;
    sm, li : longint;
    f : file;

    BigSgnlson : word;
    PosBuf : array[0..12001] of byte;
    BigSgnrson : word;
    LenBuf : array[0..12001] of byte;
    BegBuf : array[0..12001] of byte;


function PressEsc: boolean;
procedure BreakCheck;
function WaitKey : char;
procedure BottomLine(msg : string; clr : byte);
procedure MessageWin(s : string);
procedure WorkingWin(s : string);
procedure HideCursor;
procedure ShowCurSor;
function Dec2Hex(l : longint; n : byte) : string;
procedure MemErr;
procedure NoMem;
function InitMemLzw : word;
procedure DiskFull;
procedure CopyFile(fsn, fdn : pathstr);
procedure CopyArcFile;
procedure CopyTempArc;
procedure CopyArcToEnd;
procedure CopyRqstFile;
procedure io_error;
procedure CreateTree16;
procedure GenTree16;
procedure CreateTree32;
procedure GenTree32;
procedure CreateTree256;
procedure GenTree256;
procedure Createtree290;
procedure Gentree290;
procedure RngPos;
procedure RngLen;
procedure EncodStr;
procedure EncodStrFast;
procedure EncodStrSuperFast;
procedure EncodChrHuf;
procedure DecodStr;
procedure DecodChrHuf;
procedure InitHash;
procedure InitHashFast;
procedure InitFixedTreeEncod;
procedure InitFixedTreeDecod;

implementation


procedure BreakCheck;
begin
	if keypressed then
	begin
		c := readkey;
		if ord(c) = 27 then
			broken := true;
    end;
end;



function WaitKey : char;
var
	c, cc : char;
begin
	if keypressed then
    begin
	    c := readkey; if ord(c) = 0 then cc := readkey;
    end;
	repeat until keypressed;
    c := readkey; if ord(c) = 0 then cc := readkey;
	WaitKey := c;
end;

function PressEsc : boolean;
var
	c, cc : char;
begin
	if keypressed then
    begin
	    c := readkey; if ord(c) = 0 then cc := readkey;
    end;
	if ord(c) = 27 then
		PressEsc := true
	else
		PressEsc := false;
end;


procedure BottomLine(msg : string; clr : byte);
begin
	window(1,1,80,25);
	textbackground(black); textcolor(clr);
    hidecursor; gotoxy(1,25);
    write(msg);
end;

procedure MessageWin(s : string);
begin
	hidecursor;
	window(10,8,70,12); textbackground(lightgray); textcolor(white);
	clrscr;

    window(1,1,80,25);
    gotoxy(10,8); write('ͻ');
    gotoxy(10,12);write('ͼ');
    for i := 9 to 11 do
    begin
    	gotoxy(10,i);write('');
    end;
    for i := 9 to 11 do
    begin
    	gotoxy(70,i);write('');
    end;

    gotoxy(40- (length(s) div 2),10);
    textcolor(red);
    write(s);
	WaitKey;
end;


procedure WorkingWin(s : string);
begin
	window(10,8,70,12); textbackground(lightgray); textcolor(white);
	clrscr;

    window(1,1,80,25);
    gotoxy(10,8); write('ͻ');
    gotoxy(10,12);write('ͼ');
    for i := 9 to 11 do
    begin
    	gotoxy(10,i);write('');
    end;
    for i := 9 to 11 do
    begin
    	gotoxy(70,i);write('');
    end;

    gotoxy(40- (length(s) div 2),10);
    textcolor(black);
    write(s);
	hidecursor;
end;


procedure hidecursor;
begin
	asm
    mov  ah,3
    mov	 bh,1
    int	 $10
	or	 ch,$20
	mov  ah,1
	int  $10
	end;
end;

procedure showcursor;
begin
	asm
    mov  ah,3
    mov	 bh,1
    int	 $10
	and	 ch,$df
	mov  ah,1
	int  $10
	end;
end;

procedure MemErr;
begin
    Writeln('Memory management error! Program aborted.');
    showcursor;
    textbackground(black); textcolor(lightgray);
    clrscr;
    halt(1);
end;

procedure NoMem;
begin
	writeln('Not enough free memory! Program aborted.');
    halt(1);
end;

function Dec2Hex(l : longint; n : byte) : string;
var
	s : string;
begin
    s := '';
	for i := 1 to n do
    begin
    	a := l and $0f;
        if a < 10 then
        	Insert(chr(a + $30),s,1)
        else
        	Insert(chr(55 + a),s,1);
        l := l shr 4;
    end;
    Dec2Hex := s;
end;

procedure DiskFull;
begin
	MessageWin('Disk Full');
    close(temparc);
    erase(temparc);
    showcursor;
    textbackground(black); textcolor(lightgray);
    clrscr;
    halt(1);
end;

procedure CopyFile(fsn, fdn : pathstr);
var
    fs,fd : file;
begin
	assign(fs, fsn);
    assign(fd, fdn);
    GetFAttr(fs,Attr);
    filemode := 0;
	reset(fs,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	GetFTime(fs,Time);
    rewrite(fd,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	flen := filesize(fs);
    sm := 0;
    while (not eof(fs))  do
    begin
    	blockread(fs,PosBuf,$8000,blen);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        blockwrite(fd,PosBuf,blen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        if blen <> NmbRead then DiskFull;
        sm := sm + blen;
    end;
    close(fs);
    if ioresult <> 0 then io_error;
    SetFTime(fd,Time);
    close(fd);
    if ioresult <> 0 then io_error;
    SetFAttr(fd,Attr);
end;



procedure CopyArcFile;
var
	bsize : longint;

begin
    seek(temparc,filesize(temparc));
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    seek(arcfile,fileinarc);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    sm := 0;
    while sm < flen do
    begin
        bsize := flen - sm;
        if bsize > $8000 then bsize := $8000;
    	blockread(arcfile,PosBuf,bsize,blen);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        blockwrite(temparc,PosBuf,blen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        if blen <> NmbRead then DiskFull;
        sm := sm + blen;
    end;
end;


procedure CopyTempArc;
begin
    filemode := 2;
    reset(temparc,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    WorkingWin('Coping temporary archive');
    ADiskFree := diskfree(ADrive);
    if ADiskFree <= filesize(temparc) then
    begin
    	close(temparc);
        close(arcfile);
        MessageWin('Not enough space to copy temp archive ' + workdir + 'TMPAAMG.&&& to ' + chr(ADrive + 64) + ':');
		exit;
	end;
	rewrite(arcfile,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while (not eof(temparc))  do
    begin
    	blockread(temparc,PosBuf,$8000,blen);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        blockwrite(arcfile,PosBuf,blen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        if blen <> NmbRead then DiskFull;
    end;
    close(arcfile);
	close(temparc);
	erase(temparc);
end;

procedure CopyArcToEnd;
begin
    seek(temparc,filesize(temparc));
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    seek(arcfile,fileinarc);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while not eof(arcfile) do
    begin
    	blockread(arcfile,PosBuf,$8000,blen);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        blockwrite(temparc,PosBuf,blen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        if blen <> NmbRead then DiskFull;
    end;
end;



procedure CopyRqstFile;
begin
    seek(rqstfile,0);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    while (not eof(rqstfile)) do
    begin
    	read(rqstfile,ws);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        write(delfile,ws);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    end;
end;



procedure io_error;
var
	s, ss : string;
begin
    if criterr then
    begin
        window(1,1,80,25);
	    showcursor;
    	textbackground(black); textcolor(lightgray);
	    clrscr;
		halt(1);
    end;
	case myiorslt of
		2:s := ' File not found';
        3:s := ' Path not found';
        4:s := ' Too many open files';
        5:s := ' Access denied';
        6:s := ' Invalid handle';
        7:s := ' Memory ctrl block destroyed';
        8:s := ' Insufficient memory';
        9:s := ' Invalid memory block adress';
       10:s := ' Invalid environment';
       $b:s := ' Invalid format';
       $c:s := ' Invalid access code';
       $d:s := ' Invalid data';
       $f:s := ' Invalid drive specified';
      $12:s := ' No more matching files';
      $13:s := ' Attempted write on write-protected disk';
      $15:s := ' Disk drive not ready';
      $17:s := ' Disk data error (CRC error)';
      $19:s := ' Disk seek error';
      $1a:s := ' Unknown disk media type';
      $1b:s := ' Disk sector not found';
      $22:s := ' Invalid disk change';
      $50:s := ' File already exist';
      103:s := ' File not open';
      154:s := ' CRC Error in data';
    else
    	s := '';
	end;
    s := 'IO Error' + s;
	MessageWin(s);
    showcursor;
    textbackground(black); textcolor(lightgray);
    clrscr;
	halt(1);
end;


procedure CreateTree16;
var
	a, b : byte;
	i, j, k, l, m, n : word;

begin
    NodePtr := 32; freenodes := 0;

    FillChar(ChrLen,32,0);
    FillChar(Prnt,64,0);
    List[1023] := 2046;

    asm
        mov		bx,30

@sl1:	cmp		word ptr [Node + bx],0
		je		@nl1
        mov		si,word ptr [List + 2046]
        mov		di,2046
        mov		ax,word ptr [Node + bx]

@ll1:   cmp		si,2046
        je		@ol1
        cmp     ax,word ptr [Node + si]
        jbe		@ol1
        mov		di,si
        mov		si,word ptr [List + si]
		jmp		@ll1

@ol1:   mov		word ptr [List + bx],si
        mov		word ptr [List + di],bx
        inc		freenodes

@nl1:	sub		bx,2
		jns		@sl1

	end;

    if freenodes = 0 then
    begin
    	ChrLen[0] := 0;
    	exit;
    end;
    If freenodes = 1 then
    begin
		ChrLen[List[1023] div 2] := 1;
        exit;
    end;

	asm

@sl2:   cmp		freenodes,1
        jna		@ou2
        mov     si,word ptr [List + 2046]
        mov		di,word ptr [List + si]
		mov		ax,word ptr [Node + si]
		add		ax,word ptr [Node + di]
		mov		bx,NodePtr
        mov		word ptr [Prnt + si],bx
        mov		word ptr [Prnt + di],bx
        mov		word ptr [Node + bx],ax
        mov     si,word ptr [List + di]
        mov		word ptr [List + 2046],si
        mov		di,2046
        mov		ax,word ptr [Node + bx]

@ll2:   cmp		si,2046
        je		@ol2
        cmp     ax,word ptr [Node + si]
        jbe		@ol2
        mov		di,si
        mov		si,word ptr [List + si]
        jmp		@ll2

@ol2:   mov		word ptr [List + bx],si
        mov		word ptr [List + di],bx
        dec		freenodes
        add		NodePtr,2
        jmp		@sl2

@ou2:   mov		ax,NodePtr
		sub		ax,2
        mov		root,ax


    	mov		bx,30

@sl3:   cmp		word ptr [Node + bx],0
        je		@nl3

        mov		si,bx

@ll3:   cmp		si,root
		je		@nl3
        inc		word ptr [ChrLen + bx]
        mov		si,word ptr [Prnt + si]
        jmp		@ll3

@nl3:   sub		bx,2
    	jns     @sl3
	end;
end;



procedure GenTree16;

begin

    asm
    	xor		cx,cx
        xor		bx,bx
        mov		ax,20
        xor		dx,dx

@sl1:   cmp		word ptr [ChrLen + bx],0
        je		@nl1
        inc		cx
        cmp		word ptr [ChrLen + bx],ax
        jnb		@nn1
        mov		ax,word ptr [ChrLen + bx]

@nn1:	cmp		word ptr [ChrLen + bx],dx
		jna		@nl1
        mov		dx,word ptr [ChrLen + bx]

@nl1:	add		bx,2
		cmp		bx,32
        jb		@sl1
        dec		cx
        mov		n,cx
        mov		k,ax
        mov		m,dx
    end;

    if n = $ffff then
    	exit;

    if	n = 0 then
    begin
    	for i := 0 to 15 do
        	if ChrLen[i] <> 0 then
            begin
            	HufChr[i] := 0;
		        exit;
            end;
    end;


	asm
        mov		ax,n
        shl		ax,1
        mov		i,ax
    	xor		bx,bx
        mov		ax,k

@bl2:	xor		si,si

@sl2:	cmp		ax,word ptr [ChrLen + si]
		jne		@nl2
        mov		word ptr [wl + bx],ax
        mov		word ptr [Node + bx],si
        add		bx,2

@nl2:	add		si,2
		cmp		si,32
        jb		@sl2

        cmp		ax,m
        je		@ou2
        inc		ax
        jmp		@bl2

@ou2:	xor		bx,bx
		xor		dx,dx

@sl3:	mov		si,word ptr [Node + bx]
		mov		word ptr [HufChr + si],dx
        inc		dx
        mov     cx,word ptr [wl + bx + 2]
        sub		cx,word ptr [wl + bx]
        jcxz	@nl3
        shl		dx,cl

@nl3:   add		bx,2
		cmp		bx,i
        jna		@sl3


        xor		bx,bx
@sc:    mov		cx,word ptr [ChrLen + bx]
        jcxz	@nc
    	mov		ax,word ptr [HufChr + bx]
        dec		cx
        mov		di,1
        shl		di,cl
        mov		dx,1
		inc		cx
        xor		si,si

@sr:    test	ax,di
		je		@n1
        or		si,dx
@n1:    dec		cx
		jcxz    @er
		shl		dx,1
		shr		di,1
        jmp 	@sr

@er:	mov		word ptr [HufChr + bx],si

@nc:	add		bx,2
		cmp		bx,32
        jb		@sc

	end;
end;


procedure CreateTree32;
var
	a, b : byte;
	i, j, k, l, m, n : word;

begin
    NodePtr := 64; freenodes := 0;

    FillChar(ChrLen,64,0);
    FillChar(Prnt,128,0);
    List[1023] := 2046;

    asm
        mov		bx,62

@sl1:	cmp		word ptr [Node + bx],0
		je		@nl1
        mov		si,word ptr [List + 2046]
        mov		di,2046
        mov		ax,word ptr [Node + bx]

@ll1:   cmp		si,2046
        je		@ol1
        cmp     ax,word ptr [Node + si]
        jbe		@ol1
        mov		di,si
        mov		si,word ptr [List + si]
		jmp		@ll1

@ol1:   mov		word ptr [List + bx],si
        mov		word ptr [List + di],bx
        inc		freenodes

@nl1:	sub		bx,2
		jns		@sl1

	end;

    if freenodes = 0 then
    begin
    	ChrLen[0] := 0;
    	exit;
    end;
    If freenodes = 1 then
    begin
		ChrLen[List[1023] div 2] := 1;
        exit;
    end;

	asm

@sl2:   cmp		freenodes,1
        jna		@ou2
        mov     si,word ptr [List + 2046]
        mov		di,word ptr [List + si]
		mov		ax,word ptr [Node + si]
		add		ax,word ptr [Node + di]
		mov		bx,NodePtr
        mov		word ptr [Prnt + si],bx
        mov		word ptr [Prnt + di],bx
        mov		word ptr [Node + bx],ax
        mov     si,word ptr [List + di]
        mov		word ptr [List + 2046],si
        mov		di,2046
        mov		ax,word ptr [Node + bx]

@ll2:   cmp		si,2046
        je		@ol2
        cmp     ax,word ptr [Node + si]
        jbe		@ol2
        mov		di,si
        mov		si,word ptr [List + si]
        jmp		@ll2

@ol2:   mov		word ptr [List + bx],si
        mov		word ptr [List + di],bx
        dec		freenodes
        add		NodePtr,2
        jmp		@sl2

@ou2:   mov		ax,NodePtr
		sub		ax,2
        mov		root,ax


    	mov		bx,62

@sl3:   cmp		word ptr [Node + bx],0
        je		@nl3

        mov		si,bx

@ll3:   cmp		si,root
		je		@nl3
        inc		word ptr [ChrLen + bx]
        mov		si,word ptr [Prnt + si]
        jmp		@ll3

@nl3:   sub		bx,2
    	jns     @sl3
	end;
end;


procedure GenTree32;

begin

    asm
    	xor		cx,cx
        xor		bx,bx
        mov		ax,20
        xor		dx,dx

@sl1:   cmp		word ptr [ChrLen + bx],0
        je		@nl1
        inc		cx
        cmp		word ptr [ChrLen + bx],ax
        jnb		@nn1
        mov		ax,word ptr [ChrLen + bx]

@nn1:	cmp		word ptr [ChrLen + bx],dx
		jna		@nl1
        mov		dx,word ptr [ChrLen + bx]

@nl1:	add		bx,2
		cmp		bx,64
        jb		@sl1
        dec		cx
        mov		n,cx
        mov		k,ax
        mov		m,dx
    end;

    if n = $ffff then
    	exit;

    if	n = 0 then
    begin
    	for i := 0 to 31 do
        	if ChrLen[i] <> 0 then
            begin
            	HufChr[i] := 0;
		        exit;
            end;
    end;


	asm
        mov		ax,n
        shl		ax,1
        mov		i,ax
    	xor		bx,bx
        mov		ax,k

@bl2:	xor		si,si

@sl2:	cmp		ax,word ptr [ChrLen + si]
		jne		@nl2
        mov		word ptr [wl + bx],ax
        mov		word ptr [Node + bx],si
        add		bx,2

@nl2:	add		si,2
		cmp		si,64
        jb		@sl2

        cmp		ax,m
        je		@ou2
        inc		ax
        jmp		@bl2

@ou2:	xor		bx,bx
		xor		dx,dx

@sl3:	mov		si,word ptr [Node + bx]
		mov		word ptr [HufChr + si],dx
        inc		dx
        mov     cx,word ptr [wl + bx + 2]
        sub		cx,word ptr [wl + bx]
        jcxz	@nl3
        shl		dx,cl

@nl3:   add		bx,2
		cmp		bx,i
        jna		@sl3


	(* Reverse *)

        xor		bx,bx
@sc:    mov		cx,word ptr [ChrLen + bx]
        jcxz	@nc
    	mov		ax,word ptr [HufChr + bx]
        dec		cx
        mov		di,1
        shl		di,cl
        mov		dx,1
		inc		cx
        xor		si,si

@sr:    test	ax,di
		je		@n1
        or		si,dx
@n1:    dec		cx
		jcxz    @er
		shl		dx,1
		shr		di,1
        jmp 	@sr

@er:	mov		word ptr [HufChr + bx],si

@nc:	add		bx,2
		cmp		bx,64
        jb		@sc

	end;
end;



procedure CreateTree256;
var
	a, b : byte;
	i, j, k, l, m, n : word;

begin
    NodePtr := 512; freenodes := 0;

    FillChar(ChrLen,512,0);
    FillChar(Prnt,1024,0);
    List[1023] := 2046;

    asm
        mov		bx,510

@sl1:	cmp		word ptr [Node + bx],0
		je		@nl1
        mov		si,word ptr [List + 2046]
        mov		di,2046
        mov		ax,word ptr [Node + bx]

@ll1:   cmp		si,2046
        je		@ol1
        cmp     ax,word ptr [Node + si]
        jbe		@ol1
        mov		di,si
        mov		si,word ptr [List + si]
		jmp		@ll1

@ol1:   mov		word ptr [List + bx],si
        mov		word ptr [List + di],bx
        inc		freenodes

@nl1:	sub		bx,2
		jns		@sl1

	end;

    if freenodes = 0 then
    begin
    	ChrLen[0] := 0;
    	exit;
    end;
    If freenodes = 1 then
    begin
		ChrLen[List[1023] div 2] := 1;
        exit;
    end;

	asm

@sl2:   cmp		freenodes,1
        jna		@ou2
        mov     si,word ptr [List + 2046]
        mov		di,word ptr [List + si]
		mov		ax,word ptr [Node + si]
		add		ax,word ptr [Node + di]
		mov		bx,NodePtr
        mov		word ptr [Prnt + si],bx
        mov		word ptr [Prnt + di],bx
        mov		word ptr [Node + bx],ax
        mov     si,word ptr [List + di]
        mov		word ptr [List + 2046],si
        mov		di,2046
        mov		ax,word ptr [Node + bx]

@ll2:   cmp		si,2046
        je		@ol2
        cmp     ax,word ptr [Node + si]
        jbe		@ol2
        mov		di,si
        mov		si,word ptr [List + si]
        jmp		@ll2

@ol2:   mov		word ptr [List + bx],si
        mov		word ptr [List + di],bx
        dec		freenodes
        add		NodePtr,2
        jmp		@sl2

@ou2:   mov		ax,NodePtr
		sub		ax,2
        mov		root,ax


    	mov		bx,510

@sl3:   cmp		word ptr [Node + bx],0
        je		@nl3

        mov		si,bx

@ll3:   cmp		si,root
		je		@nl3
        inc		word ptr [ChrLen + bx]
        mov		si,word ptr [Prnt + si]
        jmp		@ll3

@nl3:   sub		bx,2
    	jns     @sl3
	end;
end;


procedure GenTree256;

begin

    asm
    	xor		cx,cx
        xor		bx,bx
        mov		ax,20
        xor		dx,dx

@sl1:   cmp		word ptr [ChrLen + bx],0
        je		@nl1
        inc		cx
        cmp		word ptr [ChrLen + bx],ax
        jnb		@nn1
        mov		ax,word ptr [ChrLen + bx]

@nn1:	cmp		word ptr [ChrLen + bx],dx
		jna		@nl1
        mov		dx,word ptr [ChrLen + bx]

@nl1:	add		bx,2
		cmp		bx,512
        jb		@sl1
        dec		cx
        mov		n,cx
        mov		k,ax
        mov		m,dx
    end;

    if n = $ffff then
    	exit;

    if	n = 0 then
    begin
    	for i := 0 to 255 do
        	if ChrLen[i] <> 0 then
            begin
            	HufChr[i] := 0;
		        exit;
            end;
    end;


	asm
        mov		ax,n
        shl		ax,1
        mov		i,ax
    	xor		bx,bx
        mov		ax,k

@bl2:	xor		si,si

@sl2:	cmp		ax,word ptr [ChrLen + si]
		jne		@nl2
        mov		word ptr [wl + bx],ax
        mov		word ptr [Node + bx],si
        add		bx,2

@nl2:	add		si,2
		cmp		si,512
        jb		@sl2

        cmp		ax,m
        je		@ou2
        inc		ax
        jmp		@bl2

@ou2:	xor		bx,bx
		xor		dx,dx

@sl3:	mov		si,word ptr [Node + bx]
		mov		word ptr [HufChr + si],dx
        inc		dx
        mov     cx,word ptr [wl + bx + 2]
        sub		cx,word ptr [wl + bx]
        jcxz	@nl3
        shl		dx,cl

@nl3:   add		bx,2
		cmp		bx,i
        jna		@sl3


	(* Reverse *)

        xor		bx,bx
@sc:    mov		cx,word ptr [ChrLen + bx]
        jcxz	@nc
    	mov		ax,word ptr [HufChr + bx]
        dec		cx
        mov		di,1
        shl		di,cl
        mov		dx,1
		inc		cx
        xor		si,si

@sr:    test	ax,di
		je		@n1
        or		si,dx
@n1:    dec		cx
		jcxz    @er
		shl		dx,1
		shr		di,1
        jmp 	@sr

@er:	mov		word ptr [HufChr + bx],si

@nc:	add		bx,2
		cmp		bx,512
        jb		@sc

	end;
end;



procedure CreateTree290;
var
	a, b : byte;
	i, j, k, l, m, n : word;

begin
    NodePtr := 580; freenodes := 0;

    FillChar(ChrLen,580,0);
    FillChar(Prnt,1160,0);
    List[1023] := 2046;

    asm
        mov		bx,0

@sl1:	cmp		word ptr [Node + bx],0
		je		@nl1
        mov		si,word ptr [List + 2046]
        mov		di,2046
        mov		ax,word ptr [Node + bx]

@ll1:   cmp		si,2046
        je		@ol1
        cmp     ax,word ptr [Node + si]
        jbe		@ol1
        mov		di,si
        mov		si,word ptr [List + si]
		jmp		@ll1

@ol1:   mov		word ptr [List + bx],si
        mov		word ptr [List + di],bx
        inc		freenodes

@nl1:	add		bx,2
        cmp		bx,580
		jb		@sl1

	end;

    if freenodes = 0 then
    begin
    	ChrLen[0] := 0;
    	exit;
    end;
    If freenodes = 1 then
    begin
		ChrLen[List[1023] div 2] := 1;
        exit;
    end;

	asm

@sl2:   cmp		freenodes,1
        jna		@ou2
        mov     si,word ptr [List + 2046]
        mov		di,word ptr [List + si]
		mov		ax,word ptr [Node + si]
		add		ax,word ptr [Node + di]
		mov		bx,NodePtr
        mov		word ptr [Prnt + si],bx
        mov		word ptr [Prnt + di],bx
        mov		word ptr [Node + bx],ax
        mov     si,word ptr [List + di]
        mov		word ptr [List + 2046],si
        mov		di,2046
        mov		ax,word ptr [Node + bx]

@ll2:   cmp		si,2046
        je		@ol2
        cmp     ax,word ptr [Node + si]
        jbe		@ol2
        mov		di,si
        mov		si,word ptr [List + si]
        jmp		@ll2

@ol2:   mov		word ptr [List + bx],si
        mov		word ptr [List + di],bx
        dec		freenodes
        add		NodePtr,2
        jmp		@sl2

@ou2:   mov		ax,NodePtr
		sub		ax,2
        mov		root,ax


    	mov		bx,0

@sl3:   cmp		word ptr [Node + bx],0
        je		@nl3

        mov		si,bx

@ll3:   cmp		si,root
		je		@nl3
        inc		word ptr [ChrLen + bx]
        mov		si,word ptr [Prnt + si]
        jmp		@ll3

@nl3:   add		bx,2
		cmp		bx,580
    	jb     @sl3
	end;
end;


procedure GenTree290;

begin

    asm
    	xor		cx,cx
        xor		bx,bx
        mov		ax,20
        xor		dx,dx

@sl1:   cmp		word ptr [ChrLen + bx],0
        je		@nl1
        inc		cx
        cmp		word ptr [ChrLen + bx],ax
        jnb		@nn1
        mov		ax,word ptr [ChrLen + bx]

@nn1:	cmp		word ptr [ChrLen + bx],dx
		jna		@nl1
        mov		dx,word ptr [ChrLen + bx]

@nl1:	add		bx,2
		cmp		bx,580
        jb		@sl1
        dec		cx
        mov		n,cx
        mov		k,ax
        mov		m,dx
    end;

    if n = $ffff then
    	exit;

    if	n = 0 then
    begin
    	for i := 0 to 279 do
        	if ChrLen[i] <> 0 then
            begin
            	HufChr[i] := 0;
		        exit;
            end;
    end;


	asm
        mov		ax,n
        shl		ax,1
        mov		i,ax
    	xor		bx,bx
        mov		ax,k

@bl2:	xor		si,si

@sl2:	cmp		ax,word ptr [ChrLen + si]
		jne		@nl2
        mov		word ptr [wl + bx],ax
        mov		word ptr [Node + bx],si
        add		bx,2

@nl2:	add		si,2
		cmp		si,580
        jb		@sl2

        cmp		ax,m
        je		@ou2
        inc		ax
        jmp		@bl2

@ou2:	xor		bx,bx
		xor		dx,dx

@sl3:	mov		si,word ptr [Node + bx]
		mov		word ptr [HufChr + si],dx
        inc		dx
        mov     cx,word ptr [wl + bx + 2]
        sub		cx,word ptr [wl + bx]
        jcxz	@nl3
        shl		dx,cl

@nl3:   add		bx,2
		cmp		bx,i
        jna		@sl3


	(* Reverse *)

        xor		bx,bx
@sc:    mov		cx,word ptr [ChrLen + bx]
        jcxz	@nc
    	mov		ax,word ptr [HufChr + bx]
        dec		cx
        mov		di,1
        shl		di,cl
        mov		dx,1
		inc		cx
        xor		si,si

@sr:    test	ax,di
		je		@n1
        or		si,dx
@n1:    dec		cx
		jcxz    @er
		shl		dx,1
		shr		di,1
        jmp 	@sr

@er:	mov		word ptr [HufChr + bx],si

@nc:	add		bx,2
		cmp		bx,580
        jb		@sc

	end;
end;


procedure InitHash; assembler;
asm

    	cld
        mov		es,FrsBuf_seg
        mov		ax,ns2
        xor		di,di
        mov		cx,$8000
        rep		stosw

end;


procedure InitHashFast; assembler;
asm
        cmp		KeyPtr,0
        je		@h2

    	cld
        mov		es,FrsBuf_seg
        mov		ax,ns2
        xor		di,di
        mov		cx,$8000
        rep		stosw
        jmp		@qt


@h2:	push	ds
		mov		ds,FrsBuf_seg
        xor		si,si
        mov		ax,ns2
        mov		dx,ns

@sl:    cmp		word ptr [si],ax
		je		@nl
        cmp		word ptr [si],ns
        jna		@cht

        sub		word ptr [si],dx
        add		si,2
        jnz		@sl
        jmp		@ee

@cht:   mov		word ptr [si],ax

@nl:    add		si,2
        jnz		@sl

@ee:	pop		ds
		mov		KeyPtr,ns

@qt:

end;


procedure RngLen; assembler;
label
    c0,c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14,c15,ec,
	c16,c17,c18,c19,c20,c21,c22,c23,c24,c25,c26,c27,c28,c29,c30,c31;

asm
        cmp		dx,0
        jbe		c0
        cmp		dx,1
        jbe		c1
		cmp		dx,2
        jbe     c2
        cmp		dx,3
        jbe 	c3
        cmp		dx,4
        jbe		c4
        cmp		dx,5
        jbe		c5
        cmp		dx,6
        jbe		c6
        cmp		dx,7
        jbe		c7

        cmp		dx,9
        jbe		c8
        cmp		dx,11
        jbe		c9
        cmp		dx,13
        jbe		c10
        cmp		dx,15
        jbe		c11

        cmp		dx,19
        jbe		c12
        cmp		dx,23
        jbe		c13
        cmp		dx,27
        jbe		c14
        cmp		dx,31
        jbe		c15

        cmp		dx,39
        jbe		c16
        cmp		dx,47
        jbe		c17
        cmp		dx,55
        jbe		c18
        cmp		dx,63
        jbe		c19

        cmp		dx,79
        jbe		c20
        cmp		dx,95
        jbe		c21
        cmp		dx,111
        jbe		c22
        cmp		dx,127
        jbe		c23

        cmp		dx,159
        jbe		c24
        cmp		dx,191
        jbe		c25
        cmp		dx,223
        jbe		c26
        cmp		dx,255
        jbe		c27

        cmp		dx,319    { 6 }
        jbe		c28

        cmp		dx,447    { 7 }
        jbe		c29

        cmp		dx,703    { 8 }
        jbe		c30

        jmp		c31

c0:     mov		di,0
        jmp		ec

c1:     mov		di,2
        jmp		ec

c2:     mov		di,4
        jmp		ec

c3:     mov		di,6
		jmp		ec

c4:     mov		di,8
		jmp		ec

c5:     mov		di,10
		jmp		ec

c6:     mov		di,12
		jmp		ec

c7:     mov		di,14
		jmp		ec

c8:     mov		di,16
		jmp		ec

c9:     mov		di,18
		jmp		ec

c10:    mov		di,20
		jmp		ec

c11:    mov		di,22
		jmp		ec

c12:    mov		di,24
		jmp		ec

c13:    mov		di,26
        jmp		ec

c14:    mov		di,28
        jmp		ec

c15:    mov		di,30
        jmp		ec

c16:    mov		di,32
        jmp		ec

c17:    mov		di,34
        jmp		ec

c18:    mov		di,36
        jmp		ec

c19:    mov		di,38
        jmp		ec

c20:    mov		di,40
        jmp		ec

c21:    mov		di,42
        jmp		ec

c22:    mov		di,44
        jmp		ec

c23:    mov		di,46
        jmp		ec

c24:    mov		di,48
        jmp		ec

c25:    mov		di,50
        jmp		ec

c26:    mov		di,52
        jmp		ec

c27:    mov		di,54
        jmp		ec

c28:    mov		di,56
        jmp		ec

c29:    mov		di,58
        jmp		ec

c30:    mov		di,60
        jmp		ec

c31:    mov		di,62
        jmp		ec



ec:
end;




procedure codlen0; assembler;
asm
    	mov		ax,word ptr [BigSgnHufVal + 512]
        mov		si,word ptr [BigSgnHufLen + 512]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7
@nc7:
end;



procedure codlen1; assembler;
asm
    	mov		ax,word ptr [BigSgnHufVal + 512 + 2]
        mov		si,word ptr [BigSgnHufLen + 512 + 2]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7


@nc7:
end;




procedure codlen2; assembler;
asm
    	mov		ax,word ptr [BigSgnHufVal + 512 + 4]
        mov		si,word ptr [BigSgnHufLen + 512 + 4]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7


@nc7:
end;

procedure codlen3; assembler;
asm
    	mov		ax,word ptr [BigSgnHufVal + 512 + 6]
        mov		si,word ptr [BigSgnHufLen + 512 + 6]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:
end;


procedure codlen4; assembler;
asm
    	mov		ax,word ptr [BigSgnHufVal + 512 + 8]
        mov		si,word ptr [BigSgnHufLen + 512 + 8]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:
end;

procedure codlen5; assembler;
asm
    	mov		ax,word ptr [BigSgnHufVal + 512 + 10]
        mov		si,word ptr [BigSgnHufLen + 512 + 10]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:
end;


procedure codlen6; assembler;
asm
    	mov		ax,word ptr [BigSgnHufVal + 512 + 12]
        mov		si,word ptr [BigSgnHufLen + 512 + 12]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:
end;


procedure codlen7; assembler;
asm
    	mov		ax,word ptr [BigSgnHufVal + 512 + 14]
        mov		si,word ptr [BigSgnHufLen + 512 + 14]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:
end;


procedure codlen8; assembler;
asm
		push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 16]
        mov		si,word ptr [BigSgnHufLen + 512 + 16]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:
        pop		ax
        sub		ax,8
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		cx
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen9; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 18]
        mov		si,word ptr [BigSgnHufLen + 512 + 18]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,10
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		cx
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen10; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 20]
        mov		si,word ptr [BigSgnHufLen + 512 + 20]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,12
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		cx
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen11; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 22]
        mov		si,word ptr [BigSgnHufLen + 512 + 22]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,14
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		cx
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen12; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 24]
        mov		si,word ptr [BigSgnHufLen + 512 + 24]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,16
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,2
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen13; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 26]
        mov		si,word ptr [BigSgnHufLen + 512 + 26]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,20
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,2
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen14; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 28]
        mov		si,word ptr [BigSgnHufLen + 512 + 28]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,24
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,2
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen15; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 30]
        mov		si,word ptr [BigSgnHufLen + 512 + 30]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,28
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,2
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen16; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 32]
        mov		si,word ptr [BigSgnHufLen + 512 + 32]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,32
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,3
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen17; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 34]
        mov		si,word ptr [BigSgnHufLen + 512 + 34]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,40
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,3
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen18; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 36]
        mov		si,word ptr [BigSgnHufLen + 512 + 36]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,48
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,3
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen19; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 38]
        mov		si,word ptr [BigSgnHufLen + 512 + 38]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,56
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,3
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen20; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 40]
        mov		si,word ptr [BigSgnHufLen + 512 + 40]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,64
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,4
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen21; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 42]
        mov		si,word ptr [BigSgnHufLen + 512 + 42]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,80
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,4
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen22; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 44]
        mov		si,word ptr [BigSgnHufLen + 512 + 44]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,96
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,4
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen23; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 46]
        mov		si,word ptr [BigSgnHufLen + 512 + 46]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,112
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,4
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codlen24; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 48]
        mov		si,word ptr [BigSgnHufLen + 512 + 48]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

         pop		ax
         sub		ax,128
         shl		ax,cl
         or			word ptr es:[bx],ax
         add		cx,5
		 cmp		cx,7
		 jna		@qt
         inc		bx
         and		cx,7

@qt:
end;


procedure codlen25; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 50]
        mov		si,word ptr [BigSgnHufLen + 512 + 50]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

         pop		ax
         sub		ax,160
         shl		ax,cl
         or			word ptr es:[bx],ax
         add		cx,5
		 cmp		cx,7
		 jna		@qt
         inc		bx
         and		cx,7

@qt:
end;


procedure codlen26; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 52]
        mov		si,word ptr [BigSgnHufLen + 512 + 52]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

         pop		ax
         sub		ax,192
         shl		ax,cl
         or			word ptr es:[bx],ax
         add		cx,5
		 cmp		cx,7
		 jna		@qt
         inc		bx
         and		cx,7

@qt:
end;


procedure codlen27; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 54]
        mov		si,word ptr [BigSgnHufLen + 512 + 54]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

         pop		ax
         sub		ax,224
         shl		ax,cl
         or			word ptr es:[bx],ax
         add		cx,5
		 cmp		cx,7
		 jna		@qt
         inc		bx
         and		cx,7

@qt:
end;


procedure codlen28; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 56]
        mov		si,word ptr [BigSgnHufLen + 512 + 56]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

         pop		ax
         sub		ax,256
         shl		ax,cl
         or			word ptr es:[bx],ax
         add		cx,6
		 cmp		cx,7
		 jna		@qt
         inc		bx
         and		cx,7

@qt:
end;


procedure codlen29; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 58]
        mov		si,word ptr [BigSgnHufLen + 512 + 58]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

         pop		ax
         sub		ax,320
         shl		ax,cl
         or			word ptr es:[bx],ax
         add		cx,7
		 cmp		cx,7
		 jna		@qt
         inc		bx
         and		cx,7

@qt:
end;


procedure codlen30; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 60]
        mov		si,word ptr [BigSgnHufLen + 512 + 60]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

         pop		ax
         sub		ax,448
         shl		ax,cl
         or			word ptr es:[bx],ax
         inc		bx

@qt:
end;



procedure codlen31; assembler;
asm
        push	dx
    	mov		ax,word ptr [BigSgnHufVal + 512 + 62]
        mov		si,word ptr [BigSgnHufLen + 512 + 62]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        push	ax
        and		ax,0ffh
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        pop		ax
        mov		al,ah
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,7
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7


@qt:
end;





procedure CodLen; assembler;
label
	ee,o1,o2,o3,o4,o5,o6,o7,o8,o9,o10,o11,o12,o13,o14,o15,
	o16,o17,o18,o19,o20,o21,o22,o23,o24,o25,o26,o27,o28,o29,o30,o31;
asm
                mov		di,StrPtr
                shl		di,1
                mov		dx,word ptr [LenBuf + di]
                mov		BstLen,dx

	            cmp		dx,0
                ja		o1
                call	codlen0
                jmp		ee

o1:	            cmp		dx,1
                ja		o2
                call	codlen1
                jmp		ee

o2:             cmp		dx,2
                ja		o3
                call	codlen2
                jmp		ee

o3:             cmp		dx,3
                ja		o4
                call	codlen3
                jmp		ee

o4:             cmp		dx,4
                ja		o5
                call	codlen4
                jmp		ee

o5:             cmp		dx,5
                ja		o6
                call	codlen5
                jmp		ee

o6:             cmp		dx,6
                ja		o7
                call	codlen6
                jmp		ee

o7:             cmp		dx,7
                ja		o8
                call	codlen7
                jmp		ee

o8:             cmp		dx,9
                ja		o9
                call	codlen8
                jmp		ee


o9:             cmp		dx,11
                ja		o10
                call	codlen9
                jmp		ee

o10:            cmp		dx,13
                ja		o11
                call	codlen10
                jmp		ee

o11:            cmp		dx,15
                ja		o12
                call	codlen11
                jmp		ee

o12:            cmp		dx,19
                ja		o13
                call	codlen12
                jmp		ee


o13:            cmp		dx,23
                ja		o14
                call	codlen13
                jmp		ee

o14:            cmp		dx,27
                ja		o15
                call	codlen14
                jmp		ee

o15:            cmp		dx,31
                ja		o16
                call	codlen15
                jmp		ee

o16:            cmp		dx,39
                ja		o17
                call	codlen16
                jmp		ee


o17:            cmp		dx,47
                ja		o18
                call	codlen17
                jmp		ee

o18:            cmp		dx,55
                ja		o19
                call	codlen18
                jmp		ee

o19:            cmp		dx,63
                ja		o20
                call	codlen19
                jmp		ee

o20:            cmp		dx,79
                ja		o21
                call	codlen20
                jmp		ee


o21:            cmp		dx,95
                ja		o22
                call	codlen21
                jmp		ee

o22:            cmp		dx,111
                ja		o23
                call	codlen22
                jmp		ee

o23:            cmp		dx,127
                ja		o24
                call	codlen23
                jmp		ee

o24:            cmp		dx,159
                ja		o25
                call	codlen24
                jmp		ee


o25:            cmp		dx,191
                ja		o26
                call	codlen25
                jmp		ee

o26:            cmp		dx,223
                ja		o27
                call	codlen26
                jmp		ee

o27:            cmp		dx,255
                ja		o28
                call	codlen27
                jmp		ee

o28:            cmp		dx,319
                ja		o29
                call	codlen28
                jmp		ee

o29:            cmp		dx,447
                ja		o30
                call	codlen29
                jmp		ee

o30:            cmp		dx,703
                ja		o31
                call	codlen30
                jmp		ee

o31:			call	codlen31

ee:
end;


procedure RngPos; assembler;
label
    c0,c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14,c15,ec,
	c16,c17,c18,c19,c20,c21,c22,c23,c24,c25,c26,c27,c28,c29,c30,c31;

asm
		cmp		dx,0
        je		c0
        cmp		dx,1
        jbe		c1
        cmp		dx,2
        jbe		c2
		cmp		dx,3
        jbe     c3
        cmp		dx,4
        jbe 	c4
        cmp		dx,6
        jbe		c5
        cmp		dx,8
        jbe		c6
        cmp		dx,12
        jbe		c7
        cmp		dx,16
        jbe		c8
        cmp		dx,24
        jbe		c9
        cmp		dx,32
        jbe		c10
        cmp		dx,48
        jbe		c11
        cmp		dx,64
        jbe		c12
        cmp		dx,96
        jbe		c13
        cmp		dx,128
        jbe		c14
        cmp		dx,192
        jbe		c15
        cmp		dx,256
        jbe		c16
        cmp		dx,384
        jbe		c17
        cmp		dx,512
        jbe		c18
        cmp		dx,768
        jbe		c19
        cmp		dx,1024
        jbe		c20
        cmp		dx,1536
        jbe		c21
        cmp		dx,2048
        jbe		c22
        cmp		dx,3072
        jbe		c23
        cmp		dx,4096
        jbe		c24
        cmp		dx,6144
        jbe		c25
        cmp		dx,8192
        jbe		c26
        cmp		dx,12288
        jbe		c27
        cmp		dx,16384
        jbe		c28
        cmp		dx,24576
        jbe		c29
        cmp		dx,32768
        jbe		c30

        jmp		c31

c0:     mov		di,0
        jmp		ec

c1:     mov		di,2
        jmp		ec

c2:     mov		di,4
        jmp		ec

c3:     mov		di,6
		jmp		ec

c4:     mov		di,8
		jmp		ec

c5:     mov		di,10
		jmp		ec

c6:     mov		di,12
		jmp		ec

c7:     mov		di,14
		jmp		ec

c8:     mov		di,16
		jmp		ec

c9:     mov		di,18
		jmp		ec

c10:    mov		di,20
		jmp		ec

c11:    mov		di,22
		jmp		ec

c12:    mov		di,24
		jmp		ec

c13:    mov		di,26
        jmp		ec

c14:    mov		di,28
        jmp		ec

c15:    mov		di,30
        jmp		ec

c16:    mov		di,32
        jmp		ec

c17:    mov		di,34
        jmp		ec

c18:    mov		di,36
        jmp		ec

c19:    mov		di,38
        jmp		ec

c20:    mov		di,40
        jmp		ec

c21:    mov		di,42
        jmp		ec

c22:    mov		di,44
        jmp		ec

c23:    mov		di,46
        jmp		ec

c24:    mov		di,48
        jmp		ec

c25:    mov		di,50
        jmp		ec

c26:    mov		di,52
        jmp		ec

c27:    mov		di,54
        jmp		ec

c28:    mov		di,56
        jmp		ec

c29:    mov		di,58
        jmp		ec

c30:	mov		di,60
		jmp		ec

c31:	mov		di,62

ec:
end;



procedure codPos0; assembler;
asm
    	mov		ax,word ptr [PosHufVal]
        mov		si,word ptr [PosHufLen]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

end;



procedure codPos1; assembler;
asm
    	mov		ax,word ptr [PosHufVal + 2]
        mov		si,word ptr [PosHufLen + 2]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

end;



procedure codPos2; assembler;
asm
    	mov		ax,word ptr [PosHufVal + 4]
        mov		si,word ptr [PosHufLen + 4]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

end;




procedure codPos3; assembler;
asm
    	mov		ax,word ptr [PosHufVal + 6]
        mov		si,word ptr [PosHufLen + 6]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

end;

procedure codPos4; assembler;
asm
    	mov		ax,word ptr [PosHufVal + 8]
        mov		si,word ptr [PosHufLen + 8]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

end;


procedure codPos5; assembler;
asm
		push	dx
    	mov		ax,word ptr [PosHufVal + 10]
        mov		si,word ptr [PosHufLen + 10]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,5
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		cx
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;

procedure codPos6; assembler;
asm
		push	dx
    	mov		ax,word ptr [PosHufVal + 12]
        mov		si,word ptr [PosHufLen + 12]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,7
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		cx
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos7; assembler;
asm
		push	dx
    	mov		ax,word ptr [PosHufVal + 14]
        mov		si,word ptr [PosHufLen + 14]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,9
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,2
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos8; assembler;
asm
		push	dx
    	mov		ax,word ptr [PosHufVal + 16]
        mov		si,word ptr [PosHufLen + 16]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,13
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,2
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos9; assembler;
asm
		push	dx
    	mov		ax,word ptr [PosHufVal + 18]
        mov		si,word ptr [PosHufLen + 18]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,17
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,3
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos10; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 20]
        mov		si,word ptr [PosHufLen + 20]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,25
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,3
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos11; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 22]
        mov		si,word ptr [PosHufLen + 22]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,33
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,4
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos12; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 24]
        mov		si,word ptr [PosHufLen + 24]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,49
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,4
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos13; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 26]
        mov		si,word ptr [PosHufLen + 26]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,65
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,5
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos14; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 28]
        mov		si,word ptr [PosHufLen + 28]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,97
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,5
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos15; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 30]
        mov		si,word ptr [PosHufLen + 30]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,129
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,6
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos16; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 32]
        mov		si,word ptr [PosHufLen + 32]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,193
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,6
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos17; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 34]
        mov		si,word ptr [PosHufLen + 34]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,257
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,7
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos18; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 36]
        mov		si,word ptr [PosHufLen + 36]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,385
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,7
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos19; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 38]
        mov		si,word ptr [PosHufLen + 38]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,513
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

@qt:
end;


procedure codPos20; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 40]
        mov		si,word ptr [PosHufLen + 40]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,769
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

@qt:
end;


procedure codPos21; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 42]
        mov		si,word ptr [PosHufLen + 42]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,1025
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,1
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos22; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 44]
        mov		si,word ptr [PosHufLen + 44]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,1537
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,1
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos23; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 46]
        mov		si,word ptr [PosHufLen + 46]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,2049
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,2
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos24; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 48]
        mov		si,word ptr [PosHufLen + 48]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,3073
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,2
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos25; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 50]
        mov		si,word ptr [PosHufLen + 50]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,4097
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,3
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos26; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 52]
        mov		si,word ptr [PosHufLen + 52]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,6145
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,3
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos27; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 54]
        mov		si,word ptr [PosHufLen + 54]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,8193
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,4
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos28; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 56]
        mov		si,word ptr [PosHufLen + 56]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,12289
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,4
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos29; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 58]
        mov		si,word ptr [PosHufLen + 58]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,16385
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,5
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;


procedure codPos30; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 60]
        mov		si,word ptr [PosHufLen + 60]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,24577
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,5
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;

procedure codPos31; assembler;
asm
        push	dx
    	mov		ax,word ptr [PosHufVal + 62]
        mov		si,word ptr [PosHufLen + 62]
        mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        inc		bx
		and		cx,7

@nc7:

        pop		ax
        sub		ax,32769
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx

        mov		al,dh
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        add		cx,7
		cmp		cx,7
		jna		@qt
        inc		bx
        and		cx,7

@qt:
end;





procedure EncodStr; assembler;
label
	ee,o1,o2,o3,o4,o5,o6,o7,o8,o9,o10,o11,o12,o13,o14,o15,
	o16,o17,o18,o19,o20,o21,o22,o23,o24,o25,o26,o27,o28,o29,o30,o31;
asm
				call	CodLen

                mov		di,StrPtr
                shl		di,1
                mov		dx,word ptr [PosBuf + di]

	            cmp		dx,0
                ja		o1
                call	codPos0
                jmp		ee

o1:	            cmp		dx,1
                ja		o2
                call	codPos1
                jmp		ee

o2:             cmp		dx,2
                ja		o3
                call	codPos2
                jmp		ee

o3:             cmp		dx,3
                ja		o4
                call	codPos3
                jmp		ee

o4:             cmp		dx,4
                ja		o5
                call	codPos4
                jmp		ee

o5:             cmp		dx,6
                ja		o6
                call	codPos5
                jmp		ee

o6:             cmp		dx,8
                ja		o7
                call	codPos6
                jmp		ee

o7:             cmp		dx,12
                ja		o8
                call	codPos7
                jmp		ee

o8:             cmp		dx,16
                ja		o9
                call	codPos8
                jmp		ee


o9:             cmp		dx,24
                ja		o10
                call	codPos9
                jmp		ee

o10:            cmp		dx,32
                ja		o11
                call	codPos10
                jmp		ee

o11:            cmp		dx,48
                ja		o12
                call	codPos11
                jmp		ee

o12:            cmp		dx,64
                ja		o13
                call	codPos12
                jmp		ee


o13:            cmp		dx,96
                ja		o14
                call	codPos13
                jmp		ee

o14:            cmp		dx,128
                ja		o15
                call	codPos14
                jmp		ee

o15:            cmp		dx,192
                ja		o16
                call	codPos15
                jmp		ee

o16:            cmp		dx,256
                ja		o17
                call	codPos16
                jmp		ee


o17:            cmp		dx,384
                ja		o18
                call	codPos17
                jmp		ee

o18:            cmp		dx,512
                ja		o19
                call	codPos18
                jmp		ee

o19:            cmp		dx,768
                ja		o20
                call	codPos19
                jmp		ee

o20:            cmp		dx,1024
                ja		o21
                call	codPos20
                jmp		ee


o21:            cmp		dx,1536
                ja		o22
                call	codPos21
                jmp		ee

o22:            cmp		dx,2048
                ja		o23
                call	codPos22
                jmp		ee

o23:            cmp		dx,3072
                ja		o24
                call	codPos23
                jmp		ee

o24:            cmp		dx,4096
                ja		o25
                call	codPos24
                jmp		ee


o25:            cmp		dx,6144
                ja		o26
                call	codPos25
                jmp		ee

o26:            cmp		dx,8192
                ja		o27
                call	codPos26
                jmp		ee

o27:            cmp		dx,12288
                ja		o28
                call	codPos27
                jmp		ee

o28:            cmp		dx,16384
                ja		o29
                call	codPos28
                jmp		ee

o29:            cmp		dx,24576
				ja		o30
				call	codPos29
                jmp		ee

o30:            cmp		dx,32768
				ja		o31
				call	codPos30
                jmp		ee

o31:			call	codPos31

ee:
end;


procedure EncodChrHuf; assembler;
asm
        mov		es,TextBuf_seg
        mov		al,es:[si]
        xor		ah,ah
        shl		ax,1
        mov		si,ax
    	mov		ax,word ptr [BigSgnHufVal + si]
        mov		si,word ptr [BigSgnHufLen + si]
		mov		es,CmprBuf_seg

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        and		cx,7
        inc		bx

@nc7:
end;



procedure DecodChrHuf; assembler;
asm
        mov		es,CmprBuf_seg
        mov		si,CmprByteCnt
        mov		al,CmprBitMsk
		xor		bx,bx

@t5:    test	es:[si],al
        jz		@rs
        mov		bx,word ptr [BigSgnlson + bx]
        jmp		@t6

@rs:	mov		bx,word ptr [BigSgnrson + bx]

@t6:    shl		al,1
		jnz		@t7
        mov		al,1
		inc		si

@t7:    cmp		bx,$8000
		jb		@t5

        mov		dx,bx
        and		dx,$7fff

		mov		CmprBitMsk,al
        mov     CmprByteCnt,si
end;

procedure decodpos0; assembler;
asm
	mov     ps,0
end;


procedure decodpos1; assembler;
asm
	mov     ps,1
end;


procedure decodpos2; assembler;
asm
		mov		ps,2
end;

procedure decodpos3; assembler;
asm
		mov		ps,3
end;

procedure decodpos4; assembler;
asm
		mov		ps,4
end;

procedure decodpos5; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,1

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,1
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,5
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos6; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,1

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,1
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,7
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos7; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,2

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,2
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,9
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos8; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,2

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,2
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,13
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos9; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,3

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,4
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,17
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos10; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,3

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,4
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,25
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos11; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,4

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,8
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,33
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos12; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,4

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,8
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,49
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos13; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,5

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,16
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,65
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos14; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,5

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,16
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,97
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos15; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,6

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,32
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,129
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos16; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,6

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,32
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,193
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos17; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,7

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,64
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,257
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos18; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,7

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,64
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,385
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos19; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,8

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,128
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,513
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos20; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,8

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,128
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,769
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos21; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,9

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,256
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,1025
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos22; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,9

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,256
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,1537
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos23; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,10

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,512
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,2049
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos24; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,10

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,512
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,3073
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos25; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,11

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,1024
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,4097
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos26; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,11

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,1024
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,6145
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos27; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,12

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,2048
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,8193
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos28; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,12

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,2048
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,12289
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos29; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,13

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,4096
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,16385
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos30; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,13

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,4096
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,24577
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodpos31; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,15

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,16384
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,32769
		mov		ps,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;




procedure decodlen0; assembler;
asm
end;

procedure decodlen1; assembler;
asm
		mov		ls,1
end;

procedure decodlen2; assembler;
asm
		mov		ls,2
end;

procedure decodlen3; assembler;
asm
		mov		ls,3
end;

procedure decodlen4; assembler;
asm
		mov		ls,4
end;

procedure decodlen5; assembler;
asm
		mov		ls,5
end;

procedure decodlen6; assembler;
asm
		mov		ls,6
end;

procedure decodlen7; assembler;
asm
		mov		ls,7
end;

procedure decodlen8; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,1

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,1
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,8
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen9; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,1

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,1
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,10
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen10; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,1

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,1
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,12
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen11; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,1

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,1
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,14
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen12; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,2

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,2
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,16
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen13; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,2

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,2
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,20
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen14; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,2

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,2
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,24
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen15; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,2

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,2
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,28
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen16; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,3

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,4
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,32
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen17; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,3

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,4
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,40
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen18; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,3

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,4
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,48
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen19; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,3

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,4
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,56
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen20; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,4

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,8
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,64
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen21; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,4

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,8
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,80
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen22; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,4

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,8
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,96
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen23; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,4

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,8
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,112
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen24; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,5

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,16
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,128
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen25; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,5

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,16
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,160
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen26; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,5

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,16
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,192
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen27; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,5

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,16
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,224
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;

procedure decodlen28; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,6

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,32
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,256
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;


procedure decodlen29; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,7

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,64
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,320
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;


procedure decodlen30; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,8

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,128
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		add     dx,448
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;



procedure decodlen31; assembler;
label
	e1,e2,e3;
asm
        mov		si,CmprByteCnt
        mov		ah,es:[si]
        mov		al,CmprBitMsk
        xor		dx,dx
		mov		cx,15

e1:     shr		dx,1
		test	ah,al
        je		e2
        or		dx,16384
e2:     shl		al,1
		cmp		al,0
        jne		e3
        inc		si
        mov		ah,es:[si]
        mov		al,1

e3:     loop	e1
		mov		ls,dx


		mov     CmprBitMsk,al
        mov		CmprByteCnt,si
end;



procedure DecodStr; assembler;
asm

        mov		ps,0
        mov		ls,0

		mov		bx,dx
        shl		bx,1
        call	word ptr [lenptr + bx]

        { decoding Pos }

    	mov		es,CmprBuf_seg
        mov		si,CmprByteCnt
        mov		al,CmprBitMsk
        xor		bx,bx

@t5:    test	es:[si],al
        jz		@rs
        mov		bx,word ptr [Poslson + bx]
        jmp		@t6

@rs:	mov		bx,word ptr [Posrson + bx]

@t6:    shl		al,1
		jnz		@t7
        mov		al,1
		inc		si

@t7:    cmp		bx,$8000
		jb		@t5

        and		bx,$7fff

		mov		CmprBitMsk,al
		mov		CmprByteCnt,si

        shl		bx,1
        call	word ptr [posptr + bx]



					add		ps,1
            		add		ls,2
                    mov		cx,ls
					mov		di,TextByteCnt
                    mov		si,di
                    sub		si,ps
                    mov		dx,ps
                    push	ds
                    mov		es,TextBuf_seg
                    mov		ds,TextBuf_seg
                    cld
                    cmp		dx,1
                    ja		@mv
                    mov		al,byte ptr [si]
                    rep		stosb
                    jmp		@ou

@mv:                rep		movsb

@ou:                pop		ds

		            mov		ax,ls
                    add		TextByteCnt,ax
end;


procedure EncodStrFast;
begin
	asm
        mov		di,StrPtr
        shl		di,1
        mov		dx,word ptr [LenBuf + di]
        mov		si,dx
        mov		BstLen,dx

        mov		es,NxtBuflw_seg
        mov		al,byte ptr es:[si]
        xor		ah,ah
        mov		si,ax
        call	word ptr [lenptr + si]

        mov		dx,word ptr [PosBuf + di]
        mov		si,dx

        mov		es,NxtBufhg_seg
        mov		al,byte ptr es:[si]
        xor		ah,ah
        mov		si,ax
        call	word ptr [posptr + si]
    end;
end;


procedure EncodStrSuperFast;
begin
	asm
    	mov		bx,CmprByteCnt
        mov		cx,CmprBitCnt
        mov		dx,di
        mov		es,NxtBuflw_seg
        mov		al,byte ptr es:[di]
        xor		ah,ah
        mov		si,ax
        call	word ptr [lenptr + si]

        mov		dx,BstPos
        mov		si,dx

        mov		es,NxtBufhg_seg
        mov		al,byte ptr es:[si]
        xor		ah,ah
        mov		si,ax
        call	word ptr [posptr + si]
        mov		CmprByteCnt,bx
        mov		CmprBitCnt,cx
    end;
end;


procedure InitFixedTreeEncod;
begin
{    MakeEncBigSgnTree;}

    for i := 0 to 143 do
    	ChrLen[i] := 8;
    for i := 144 to 255 do
    	ChrLen[i] := 9;
    for i := 256 to 279 do
    	ChrLen[i] := 7;
    for i := 280 to 287 do
    	ChrLen[i] := 8;
    Gentree290;
    move(HufChr,BigSgnHufVal,1024);
    move(ChrLen,BigSgnHufLen,1024);

{    MakeEncPosTree;}
    for i := 0 to 31 do
    	ChrLen[i] := 5;
    GenTree32;
    move(HufChr,PosHufVal,64);
    move(ChrLen,PosHufLen,64);

end;

procedure InitFixedTreeDecod;
begin

    for i := 0 to 143 do
    	ChrLen[i] := 8;
    for i := 144 to 255 do
    	ChrLen[i] := 9;
    for i := 256 to 279 do
    	ChrLen[i] := 7;
    for i := 280 to 287 do
    	ChrLen[i] := 8;
     Gentree290;
     FillChar(BigSgnlson,2048,255);
     FillChar(BigSgnrson,2048,255);

     asm
     	xor		bx,bx
        mov		BigSgnTopTree,2

@sl:	cmp     word ptr [ChrLen + bx],0
		je		@nl
        xor		si,si
        mov		ax,word ptr [HufChr + bx]
        mov		cx,word ptr [ChrLen + bx]
        mov		dx,1

@isl:   test	ax,dx
        jz		@rs
        cmp		cx,1
        ja		@lne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [BigSgnlson + si],ax
        jmp		@nl

@lne:   mov		di,word ptr [BigSgnlson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,BigSgnTopTree
        add		BigSgnTopTree,2
		mov		word ptr [BigSgnlson + si],di
        jmp		@inl

@rs:    cmp		cx,1
        ja		@rne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [BigSgnrson + si],ax
        jmp		@nl

@rne:   mov		di,word ptr [BigSgnrson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,BigSgnTopTree
        add		BigSgnTopTree,2
		mov		word ptr [BigSgnrson + si],di

@inl:   mov		si,di
   		shl		dx,1
        loop	@isl

@nl:	add		bx,2
		cmp		bx,288*2
        jb		@sl
    end;


    for i := 0 to 31 do
    	ChrLen[i] := 5;
    GenTree32;
    FillChar(Poslson,128,255);
   	FillChar(Posrson,128,255);

     asm
     	xor		bx,bx
        mov		PosTopTree,2

@sl:	cmp     word ptr [ChrLen + bx],0
		je		@nl
        xor		si,si
        mov		ax,word ptr [HufChr + bx]
        mov		cx,word ptr [ChrLen + bx]
        mov		dx,1

@isl:   test	ax,dx
        jz		@rs
        cmp		cx,1
        ja		@lne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [Poslson + si],ax
        jmp		@nl

@lne:   mov		di,word ptr [Poslson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,PosTopTree
        add		PosTopTree,2
		mov		word ptr [Poslson + si],di
        jmp		@inl

@rs:    cmp		cx,1
        ja		@rne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [Posrson + si],ax
        jmp		@nl

@rne:   mov		di,word ptr [Posrson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,PosTopTree
        add		PosTopTree,2
		mov		word ptr [Posrson + si],di

@inl:   mov		si,di
   		shl		dx,1
        loop	@isl

@nl:	add		bx,2
		cmp		bx,64
        jb		@sl
    end;
end;


function InitMemLzw : word;
var
	ss : string[20];
begin
{
	textcolor(white); textbackground(black); gotoxy(50,1);
    li := maxavail; sm := memavail; write(li,' ',sm,'        ');
	repeat until keypressed; c := readkey;
}
    if MaxAvail < ns2 then
	begin InitMemLzw := cmNoMem; exit;	end;
	getmem(TextBuf, ((ns2 div 16) + 1)*16);
    if MaxAvail < ns then
	begin InitMemLzw := cmNoMem; exit;	end;
	getmem(CmprBuf, ((ns div 16) + 1)*16 );



    ss := copy(cmnd,1,4);
    if (ss <> 'extr') and (ss <> 'test')  then
    begin
    	if method <> LessMemCompr then
        begin
		    if MaxAvail < ns2 then
			begin InitMemLzw := cmNoMem; exit;	end;
			getmem( NxtBuflw,((ns2 div 16) + 2)*16);

		    if MaxAvail < ns2 then
			begin InitMemLzw := cmNoMem; exit;	end;
			getmem( NxtBufhg,((ns2 div 16) + 2)*16);
        end;

    	if MemAvail <  $10000 then
		begin InitMemLzw := cmNoMem; exit;	end;
		getmem( FrsBuf, $FFFF);

	    if MaxAvail <  $40 then
		begin InitMemLzw := cmNoMem; exit;	end;
		getmem( SafBuf, $40);
    end;

    TextBuf_seg:=memw[seg(TextBuf):ofs(TextBuf)+2];
    CmprBuf_seg:=memw[seg(CmprBuf):ofs(CmprBuf)+2];

	if memw[seg(TextBuf):ofs(TextBuf)] <> 0 then
	begin InitMemLzw := cmMemErr; exit;	end;
    if memw[seg(CmprBuf):ofs(CmprBuf)] <> 0 then
	begin InitMemLzw := cmMemErr; exit;	end;

    if (ss <> 'extr') and (ss <> 'test')  then
    begin
        if method <> LessMemCompr then
        begin
		    NxtBuflw_seg:=memw[seg(NxtBuflw):ofs(NxtBuflw)+2];
		    NxtBufhg_seg:=memw[seg(NxtBufhg):ofs(NxtBufhg)+2];

	    	if memw[seg(NxtBuflw):ofs(NxtBuflw)] <> 0 then
			begin InitMemLzw := cmMemErr; exit;	end;
		    if memw[seg(NxtBufhg):ofs(NxtBufhg)] <> 0 then
			begin InitMemLzw := cmMemErr; exit;	end;
        end;

    	FrsBuf_seg:=memw[seg(FrsBuf):ofs(FrsBuf)+2];
	    if memw[seg(FrsBuf):ofs(FrsBuf)] <> 0 then
		begin InitMemLzw := cmMemErr; exit;	end;

        if method < LessMemCompr then
        begin
            asm
			(* RngLen *)

            	mov		es,NxtBuflw_seg
                xor		di,di
                cld

                mov		cx,1
                mov		al,0
                rep		stosb
                mov		cx,1
                mov		al,2
                rep		stosb
                mov		cx,1
                mov		al,4
                rep		stosb
                mov		cx,1
                mov		al,6
                rep		stosb
                mov		cx,1
                mov		al,8
                rep		stosb
                mov		cx,1
                mov		al,10
                rep		stosb
                mov		cx,1
                mov		al,12
                rep		stosb
                mov		cx,1
                mov		al,14
                rep		stosb

                mov		cx,2
                mov		al,16
                rep		stosb
                mov		cx,2
                mov		al,18
                rep		stosb
                mov		cx,2
                mov		al,20
                rep		stosb
                mov		cx,2
                mov		al,22
                rep		stosb

                mov		cx,4
                mov		al,24
                rep		stosb
                mov		cx,4
                mov		al,26
                rep		stosb
                mov		cx,4
                mov		al,28
                rep		stosb
                mov		cx,4
                mov		al,30
                rep		stosb

                mov		cx,8
                mov		al,32
                rep		stosb
                mov		cx,8
                mov		al,34
                rep		stosb
                mov		cx,8
                mov		al,36
                rep		stosb
                mov		cx,8
                mov		al,38
                rep		stosb

                mov		cx,16
                mov		al,40
                rep		stosb
                mov		cx,16
                mov		al,42
                rep		stosb
                mov		cx,16
                mov		al,44
                rep		stosb
                mov		cx,16
                mov		al,46
                rep		stosb

                mov		cx,32
                mov		al,48
                rep		stosb
                mov		cx,32
                mov		al,50
                rep		stosb
                mov		cx,32
                mov		al,52
                rep		stosb
                mov		cx,32
                mov		al,54
                rep		stosb

                mov		cx,64
                mov		al,56
                rep		stosb

                mov		cx,128
                mov		al,58
                rep		stosb

                mov		cx,256
                mov		al,60
                rep		stosb

                mov		cx,ns
                sub		cx,704
                mov		al,62
                rep		stosb

		(* RngPos *)


            	mov		es,NxtBufhg_seg
                xor		di,di
                cld

                mov		cx,1
                mov		al,0
                rep		stosb
                mov		cx,1
                mov		al,2
                rep		stosb
                mov		cx,1
                mov		al,4
                rep		stosb
                mov		cx,1
                mov		al,6
                rep		stosb
                mov		cx,1
                mov		al,8
                rep		stosb

                mov		cx,2
                mov		al,10
                rep		stosb
                mov		cx,2
                mov		al,12
                rep		stosb

                mov		cx,4
                mov		al,14
                rep		stosb
                mov		cx,4
                mov		al,16
                rep		stosb

                mov		cx,8
                mov		al,18
                rep		stosb
                mov		cx,8
                mov		al,20
                rep		stosb

                mov		cx,16
                mov		al,22
                rep		stosb
                mov		cx,16
                mov		al,24
                rep		stosb

                mov		cx,32
                mov		al,26
                rep		stosb
                mov		cx,32
                mov		al,28
                rep		stosb

                mov		cx,64
                mov		al,30
                rep		stosb
                mov		cx,64
                mov		al,32
                rep		stosb

                mov		cx,128
                mov		al,34
                rep		stosb
                mov		cx,128
                mov		al,36
                rep		stosb

                mov		cx,256
                mov		al,38
                rep		stosb
                mov		cx,256
                mov		al,40
                rep		stosb

                mov		cx,512
                mov		al,42
                rep		stosb
                mov		cx,512
                mov		al,44
                rep		stosb

                mov		cx,1024
                mov		al,46
                rep		stosb
                mov		cx,1024
                mov		al,48
                rep		stosb

                mov		cx,2048
                mov		al,50
                rep		stosb
                mov		cx,2048
                mov		al,52
                rep		stosb

                mov		cx,4096
                mov		al,54
                rep		stosb
                mov		cx,4096
                mov		al,56
                rep		stosb

                mov		cx,8192
                mov		al,58
                rep		stosb
                mov		cx,8192
                mov		al,60
                rep		stosb

                mov		cx,ns2
                sub		cx,di
                mov		al,62
                rep		stosb

        	end;


			lenptr[0] := ofs(codlen0);
			lenptr[1] := ofs(codlen1);
			lenptr[2] := ofs(codlen2);
			lenptr[3] := ofs(codlen3);
			lenptr[4] := ofs(codlen4);
			lenptr[5] := ofs(codlen5);
			lenptr[6] := ofs(codlen6);
			lenptr[7] := ofs(codlen7);
			lenptr[8] := ofs(codlen8);
			lenptr[9] := ofs(codlen9);
			lenptr[10] := ofs(codlen10);
			lenptr[11] := ofs(codlen11);
			lenptr[12] := ofs(codlen12);
			lenptr[13] := ofs(codlen13);
			lenptr[14] := ofs(codlen14);
			lenptr[15] := ofs(codlen15);
			lenptr[16] := ofs(codlen16);
			lenptr[17] := ofs(codlen17);
			lenptr[18] := ofs(codlen18);
			lenptr[19] := ofs(codlen19);
			lenptr[20] := ofs(codlen20);
			lenptr[21] := ofs(codlen21);
			lenptr[22] := ofs(codlen22);
			lenptr[23] := ofs(codlen23);
			lenptr[24] := ofs(codlen24);
			lenptr[25] := ofs(codlen25);
			lenptr[26] := ofs(codlen26);
			lenptr[27] := ofs(codlen27);
			lenptr[28] := ofs(codlen28);
			lenptr[29] := ofs(codlen29);
			lenptr[30] := ofs(codlen30);
			lenptr[31] := ofs(codlen31);

			posptr[0] := ofs(codpos0);
			posptr[1] := ofs(codpos1);
			posptr[2] := ofs(codpos2);
			posptr[3] := ofs(codpos3);
			posptr[4] := ofs(codpos4);
			posptr[5] := ofs(codpos5);
			posptr[6] := ofs(codpos6);
			posptr[7] := ofs(codpos7);
			posptr[8] := ofs(codpos8);
			posptr[9] := ofs(codpos9);
			posptr[10] := ofs(codpos10);
			posptr[11] := ofs(codpos11);
			posptr[12] := ofs(codpos12);
			posptr[13] := ofs(codpos13);
			posptr[14] := ofs(codpos14);
			posptr[15] := ofs(codpos15);
			posptr[16] := ofs(codpos16);
			posptr[17] := ofs(codpos17);
			posptr[18] := ofs(codpos18);
			posptr[19] := ofs(codpos19);
			posptr[20] := ofs(codpos20);
			posptr[21] := ofs(codpos21);
			posptr[22] := ofs(codpos22);
			posptr[23] := ofs(codpos23);
			posptr[24] := ofs(codpos24);
			posptr[25] := ofs(codpos25);
			posptr[26] := ofs(codpos26);
			posptr[27] := ofs(codpos27);
			posptr[28] := ofs(codpos28);
			posptr[29] := ofs(codpos29);
			posptr[30] := ofs(codpos30);
			posptr[31] := ofs(codpos31);
    	end;
    end
    else
    begin
		lenptr[0] := ofs(decodlen0);
		lenptr[1] := ofs(decodlen1);
		lenptr[2] := ofs(decodlen2);
		lenptr[3] := ofs(decodlen3);
		lenptr[4] := ofs(decodlen4);
		lenptr[5] := ofs(decodlen5);
		lenptr[6] := ofs(decodlen6);
		lenptr[7] := ofs(decodlen7);
		lenptr[8] := ofs(decodlen8);
		lenptr[9] := ofs(decodlen9);
		lenptr[10] := ofs(decodlen10);
		lenptr[11] := ofs(decodlen11);
		lenptr[12] := ofs(decodlen12);
		lenptr[13] := ofs(decodlen13);
		lenptr[14] := ofs(decodlen14);
		lenptr[15] := ofs(decodlen15);
		lenptr[16] := ofs(decodlen16);
		lenptr[17] := ofs(decodlen17);
		lenptr[18] := ofs(decodlen18);
		lenptr[19] := ofs(decodlen19);
		lenptr[20] := ofs(decodlen20);
		lenptr[21] := ofs(decodlen21);
		lenptr[22] := ofs(decodlen22);
		lenptr[23] := ofs(decodlen23);
		lenptr[24] := ofs(decodlen24);
		lenptr[25] := ofs(decodlen25);
		lenptr[26] := ofs(decodlen26);
		lenptr[27] := ofs(decodlen27);
		lenptr[28] := ofs(decodlen28);
		lenptr[29] := ofs(decodlen29);
		lenptr[30] := ofs(decodlen30);
		lenptr[31] := ofs(decodlen31);

		posptr[0] := ofs(decodpos0);
		posptr[1] := ofs(decodpos1);
		posptr[2] := ofs(decodpos2);
		posptr[3] := ofs(decodpos3);
		posptr[4] := ofs(decodpos4);
		posptr[5] := ofs(decodpos5);
		posptr[6] := ofs(decodpos6);
		posptr[7] := ofs(decodpos7);
		posptr[8] := ofs(decodpos8);
		posptr[9] := ofs(decodpos9);
		posptr[10] := ofs(decodpos10);
		posptr[11] := ofs(decodpos11);
		posptr[12] := ofs(decodpos12);
		posptr[13] := ofs(decodpos13);
		posptr[14] := ofs(decodpos14);
		posptr[15] := ofs(decodpos15);
		posptr[16] := ofs(decodpos16);
		posptr[17] := ofs(decodpos17);
		posptr[18] := ofs(decodpos18);
		posptr[19] := ofs(decodpos19);
		posptr[20] := ofs(decodpos20);
		posptr[21] := ofs(decodpos21);
		posptr[22] := ofs(decodpos22);
		posptr[23] := ofs(decodpos23);
		posptr[24] := ofs(decodpos24);
		posptr[25] := ofs(decodpos25);
		posptr[26] := ofs(decodpos26);
		posptr[27] := ofs(decodpos27);
		posptr[28] := ofs(decodpos28);
		posptr[29] := ofs(decodpos29);
		posptr[30] := ofs(decodpos30);
		posptr[31] := ofs(decodpos31);

	end;
{
	textcolor(white); textbackground(black); gotoxy(50,1);
    li := maxavail; sm := memavail; write(li,' ',sm,'        ');
	repeat until keypressed; c := readkey;
}

    if method = SuperFastCompr then
    begin
    	FixedTree := true;
        InitFixedTreeEncod;
    end
    else
    	FixedTree := false;
    InitMemLzw := cmMemOk;
end;


begin
end.