{$D-,S+,R-,B-}
UNIT PKWAREU;
{$Define ShareWare}  { To Define public version }
(*************************************************************************
                  PKWare unit for Turbo Pascal. ver 1.0

                       Compiled: Oct. 17,1993.

                    Copyright (c) Terry Sansom 1993.

  The terms PKZip and Pkunzip are known to be trademarks or service marks
   of PKWARE Inc.  As such this program/unit no way hinders their right
   to such marks.

  Author makes no express warranty for this product, and is not liable
  for any damages cause by the the use of, or inability to use, this product.

  If you would like the source code to this unit please contact me. I
  charge a small fee for my time, and do not want the code released to the
  public domain. I can be reached at.

    Terry Sansom,
    9102 83 Ave
    Edmonton, Alberta
    CANADA
    T6C 1B7

   Or on Compuserve  [70574,3205]

 *************************************************************************)

(**) INTERFACE (**)

Uses DOS;

Const
        CentralFileHeaderSignature    = $02014b50; { As defined by PKWARE }
        CentralFileHeaderEndSignature = $06054b50;

        { Change as desired, for ease of use only. See demo }
        CompMethod : Array[0..8] of string[12] =
                        ('stored',
                         'shrunk',
                         'compressed 1',
                         'compressed 2',
                         'compressed 3',
                         'compressed 4',
                         'imploded',
                         'tokenized',
                         'deflated');

{$IFDEF ShareWare}
   PKMaxLen = 255;
   CommentLen = 15;
{$ELSE}
   CommentLen = 65535;  { 64k max }
{$EndIF}

TYPE

   FString      = String;
   CharArray    = Array[1..PKMaxLen] of Char;

   CommentPtr   = ^CommentArray;
   CommentArray = Array[1..1] of CHAR;

   FileStats = Record         { just to make storage size managable }
     Name   : String[65];     { includes path                       }
     OSize,                   { original size                       }
     CSize,                   { compressed size                     }
     Date,                    { date and time as longint            }
     CRC    : Longint;        { Crc-32                              }
     Attr   : LongInt;        { actually word TYPE in DOS           }
     Method : Word;           { compression method                  }
   end;

   ExtraData = Record
     ExtraName: String[11];    { name of the data }  { proprietary }
     ExtraID : Word;          { Id number of the data }
     ExtraLen: Word;          { length of the data }
     ExtraAddress: Longint;   { Offest of the data }
    end;

   CentralFileHeaderType = Record
      CentralSig   :LongInt;          { Central dir signature }
      Madeby       : Word;            { HI = operating system, Lo Pkzip version }
      VerReq       : Word;            { min PK version to extract }
      GenPurp      : Word;            { Gen. purpose flag      }
      Compresion   : Word;            { compersion method used }
      lastFTime    : Word;            { Time of compression    }
      lastFdate    : Word;            { Date of compression    }
      crc32        : LongInt;         { magic number CRC32     }
      Compsize     : LongInt;         { Compresed file size    }
      UnCompSize   : LongInt;         { Original file size     }
      NameLen      : Word;            { length of the name     }
      Extralen     : Word;            { length of extra field  }
      ComentLen    : Word;            { length of comment      }
      DiskStart    : Word;            { # of disk which this file starts }
      IntrenalAttr : Word;            { LO set indicates ASCII text, else binary file }
      ExternalAttr : LongInt;         { HI is operating sys dependant, LO is DOS attr }
      OffsetLocal  : LongInt;         { Offset from first disk of local header }
      FileName     : FString;        { Storage of filename, nil if length zero }
      Extra        : ExtraData;       { Storage of extra field, nil if len zero }
      FileComment  : CharArray;         { Always nil, My choice. }
     End;

     ZipEndRec = Record
       EndSig      : LongInt;        { Signature of Directroy end           }
       DiskNum     : Word;           { Number of this disk                  }
       DiskwStart  : Word;           { # of disk with start of central dir  }
       NumEntries  : Word;           { # of entries in central on this disk }
       TNumEntries : Word;           { total number of entries, this central dir. }
       SizeCentral : LongInt;        { Size of central directory            }
       OffsetDirRelDiskNum: LongInt; { Offest of central dir in respect to
                                       starting disk number                  }
       CommentLen  :Word;            { zipfile comment length                }
      end;

Function GetZipStats: Word;  { Call this first!!! }
{ Returns ...
  0 : if ZipStats are usable.
  1 : signature error, signature does not match may not be a zip file
  2 : if Blockread failed.
  IO error,  As reported by IOResult.

  =>  Basiclly Non zero if error occured, do not use ZIPStats.
}

Procedure CFH_to_FileStat(VAR CFH: CentralFileHeadertype; VAR FS : FileStats);
{ Converts CentralFileHeaderType to FileStats type }

Function ReadFileHeader(VAR CFH: CentralfileHeadertype):Byte;
{
  Returns ...
         0   no error, Cfh is OK.
         1   Signiture is bad, do not use CFH.
         2   disk read error, do not use CFH.
}

Procedure ShowZipComment;

Procedure GetZipComment(VAR CPtr: CommentPtr; VAR Size:Word);

VAR
   ZipStats       : ZipEndRec;     { Global zipstats }
   ZipFile        :File;           { Zip filename.
                                     NOTE: You open and assign and close it ! }
   CentralAddress : LongInt;       { Offset of Central directory in file }
                                   { Never change this! }

(**) IMPLEMENTATION (**)
