/* F R E E C O M P  1.0
	A Freeware Compression Utility
	Written By Tim Russell
	---
	FreeComp gets info about a program and creates a batch file that you run
	instead of the normal executable. It will decompress a compressed file if 
	it exists, run the program, update the compressed file, and delete all the 
	files except the compressed file.
		Advantages to FreeComp over similar programs:
		 No annoying delays or registration messages
		 Makes its own batch files, so there is no shell program to run (and
		  consequently, no overhead memory!)
		 Totally customizable - if you don't like the batch file the way it is,
		  or you want to add something, it's up to you!
		 It's FREE!
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

int main(void)
{
		// Declare variables
	char CompFileDir[60]="\0", CompFileName[12]="\0", DecompUtilDir[60]="\0"; 
	char DecompUtilName[12]="\0", DecompUtilParms[40]="\0", ProgDrv[2]="\0";
	char ProgDir[60]="\0", ProgExe[60]="\0", ProgParms[40]="\0";
	char CompUtilDir[60]="\0", CompUtilName[12]="\0", CompUtilParms[40]="\0";
	char BatFilePath[80]="\0";
	FILE *batch;      

		// Clears screen
	clrscr();
		// Ask for compressed file directory
	printf("\nWhat is the directory that the compressed file should be stored in?\n Example:  D:\\ZIPS\\\n   ");
	gets(CompFileDir);
		// Ask what the name of the compressed file is
	printf("\nWhat is the name of the compressed file?\n Example:  MONEY.ZIP\n   ");
	gets(CompFileName);
		// Ask where the decompression utility is stored
	printf("\nWhere is the decompression utility stored?\n Example:  D:\\UTILS\\\n   ");
	gets(DecompUtilDir);
		// Ask what the name of the decompression utility is
	printf("\nWhat is the name of the decompression utility?\n Example:  PKUNZIP.EXE\n   ");
	gets(DecompUtilName);
		// Ask what parameters the decompression utility takes
	printf("\nWhat parameters does the decompression utility take?\n Example:  -d -o\n   ");
	gets(DecompUtilParms);
		// Ask where program is stored
	printf("\nWhat drive is the program on?\n Example: D:\n   ");
	gets(ProgDrv);
	printf("\nWhat directory is the program in?\n Example:  MONEY3\n   ");
	gets(ProgDir);
		// Ask for name of the program executable
	printf("\nWhat is the name of the program executable?\n Example:  MONEY3.EXE\n   ");
	gets(ProgExe);
		// Ask for program parameters
	printf("\nWhat are the program's parameters?\n Example:  /H:%1 /N:1 /F:\"%2\"\n   ");
	gets(ProgParms);
		// Ask for compression utility directory      
	printf("\nWhere is the compression utility stored?\n Example:  D:\\UTILS\\\n   ");
	gets(CompUtilDir);   
		// Ask what the name of the compression utility is
	printf("\nWhat is the name of the compression utility?\n Example:  PKZIP.EXE\n   ");
	gets(CompUtilName);
		// Ask what parameters the compression utility takes
	printf("\nWhat parameters does the compression utility take?\n Example:  -P -r -ex\n   ");
	gets(CompUtilParms);
		// Ask where batch file should be stored
	printf("\nWhere should the batch file be stored?\n Example:  D:\\BATS\\MONEY.BAT\n   ");
	gets(BatFilePath);
		
		// Open batch file for writing
	batch = fopen(BatFilePath, "w");
		// Start writing lines to batch file
	fprintf(batch, "@echo off\n");
	fprintf(batch, "c:\n");
	fprintf(batch, "md\\$$temp$$\n");
	fprintf(batch, "echo Now checking for compressed file, and decompressing if it exists.\n");
	fprintf(batch, "if exist %s%s %s%s %s %s%s %s\\%s\n", CompFileDir, CompFileName, DecompUtilDir, DecompUtilName, DecompUtilParms, CompFileDir, CompFileName, ProgDrv, ProgDir);
	fprintf(batch, "echo Changing to the program's drive.\n");
	fprintf(batch, "%s\n", ProgDrv);
	fprintf(batch, "echo Changing to the program's directory.\n");
	fprintf(batch, "cd\\%s\n", ProgDir);
	fprintf(batch, "echo Running program with input parameters.\n");
	fprintf(batch, "%s %s\n", ProgExe, ProgParms);
	fprintf(batch, "echo Recompressing files.\n");
	fprintf(batch, "%s%s %s %s%s *.*\n", CompUtilDir, CompUtilName, CompUtilParms, CompFileDir, CompFileName);
	fprintf(batch, "if exist %s\\%s\\%s move %s\\%s\\%s C:\\$$temp$$\n", ProgDrv, ProgDir, CompFileName, ProgDrv, ProgDir, CompFileName);
	fprintf(batch, "echo Deleting old files.\n");    
	fprintf(batch, "del %s\\%s\\*.*\n", ProgDrv, ProgDir);
	fprintf(batch, "if exist c:\\$$temp$$\\%s move c:\\$$temp$$\\%s %s\\%s\n", CompFileName, CompFileName, ProgDrv, ProgDir);
	fprintf(batch, "c:\n");
	fprintf(batch, "cd\\\n");
	fprintf(batch, "rmdir $$temp$$\n");
	fprintf(batch, "echo Done!!!\n");
	fclose(batch);

		// Return errorlevel 0
	return(0);  
}
