/* 0-byte.c */

/*
    DESCRIPTION:
    Accepts a DIR listing from Standard Input, and produces a 0-byte
    length file for each file listed in the DIR listing.

    Subidirectories are ignored.

    USAGE:

	DIR \target\subdirectory | 0-BYTE > capture.cap

    The 0-byte-length files will be created in the current subdirectory.
    0-byte will not overwrite existing files. Check CAPTURE.CAP for
    the names of duplicate files found.

    dap@kandy.com  11/26/93
*/

/*
    HISTORY:
    If you find a bug, report it. Otherwise it probably won't get fixed.

    11/26/93 v1.0 Initial release. First (and hopefully last) version.
*/


#include <stdio.h>
#include <string.h>

main()
{
  FILE  *zerofile;
  char  *k;
  char  buf[512];
  char  errbuf[1024];

  fprintf(stderr, "0-BYTE v1.0 <dap@kandy.com>\n");
  fprintf(stderr, "Last compiled on %s at %s\n\n", __DATE__, __TIME__);

  while((fgets(buf, 511, stdin))!=NULL)
  {
    if((strstr(buf, "<DIR>"))!=NULL)
      continue;

    *(buf+12)='\0';

    if(*buf==' ' || *buf=='\n')
      continue;

    k=strchr(buf, ' ');
    *k='.';

    k++;
    while(*k==' ')
      strcpy(k, k+1);

    if((k=strchr(buf, ' '))!=NULL)
      *k='\0';

    if(!strcmp(buf, "...") || !strcmp(buf, ".."))
      continue;

    if((zerofile=fopen(buf, "r"))!=NULL)
    {
      fputc(7, stderr);
      printf("%s EXISTS and will not be overwritten!\n", buf);
      fclose(zerofile);
      continue;
    }
    fclose(zerofile);

    if((zerofile=fopen(buf, "w"))==NULL)
    {
      sprintf(errbuf, "ERROR: %c%c%c%s", (char)7, (char)7, (char)7, buf);
      perror(errbuf);
    }
    else
    {
      printf("%s\n", buf);
      fclose(zerofile);
    }
  }
  exit(0);
}
