program wrapBBS__FILE_ID_DIZ;  { FILE_ID.DIZ }
                               { is an 8 line by 44 character wide file      }
                               { placed in ZIP's to describe their contents. }
                               { It is mainly used on BBS's, which usually   }
                               { have programs to read it and use it as the  }
                               { published file description.  Thus, the      }
                               { program is described consistently from      }
                               { board to board, no matter who uploads it.   }
                               { THE PRECEDING IS HOW ONE ACTUALLY APPEARS!  }
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release.  DDA
v1.01  : 1993/08/27.  Fixed bug: would not properly process files in
                            directories other than the current one.  DDA
v1.01a : 1993/09/24.  Added ability to set line length.  DDA
                      Improved the "showhelp" procedure.  DDA
v1.02  : 1994/01/24.  Now formats 'file_id.diz' if no parameters found on
                      the command line.  DDA

------------------------------------------------------------------------------}

uses dos;
var
   dirinfo         : searchrec ;
   spath           : pathstr ;
   sdir            : dirstr ;
   sname           : namestr ;
   sext            : extstr ;

   infile, outfile : text ;

   sfn, dfn, tfn   : string [64];
   filesdone       : array [1..512] of string [64];

   done            : boolean ;
   i, nmdone       : word ;
   llength, valerr  : integer ;

procedure showhelp ( errornum : byte );
const
   progdata = 'DIZZY- Free DOS utility: FILE_ID.DIZ off-line reformatter.';
   progdat2 = 'v1.02: January 24, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';
   usage = 'Usage:  DIZZY <file_id.diz> [line_length]';
var
    message : string [80];
begin
    writeln ( progdata );
    writeln ( progdat2 );
    writeln ;
    writeln ( usage );
    writeln ;

    case errornum of
      1 : message := 'incorrect number of command line parameters.';
      2 : message := 'if you specify a "line_length", it must be between 40 and 127.';
      3 : message := 'you must specify a filename or filespec, not just a drive or path.';
      4 : message := 'error opening a file.  It may be read-only.';
    end;
    writeln ( 'ERROR: (#',errornum,') - ', message );
    halt ( errornum );
end;


procedure openfiles(var sfile, dfile : text; name1, name2 : string);
begin
     assign (sfile,name1);
{$i-} reset (sfile); {$i+}
     if ( ioresult <> 0) then
     begin
         writeln ('Unable to open "', name1, '".');
         showhelp(4);
     end;

     assign (dfile,name2);
     rewrite (dfile);
end;

function squeezestr(longstr : string) : string;
begin
    while ((longstr <> '') and (pos('  ',longstr) <> 0)) do
          delete (longstr,pos('  ',longstr),1);

    while ((longstr <> '') and (longstr[length(longstr)] = ' ')) do
          delete (longstr,length(longstr),1);

    while ((longstr <> '') and ((longstr[1] = ' ') or (longstr[1] = '|'))) do
          delete (longstr,1,1);
    squeezestr := longstr;
end;

function wrapline ( var thefile : text ; theline : string ) : string ;
var
   parta,partb  : string ;
   breakchar    : string [1];
begin
     parta := copy (theline,1,(llength+1));
     partb := copy (theline,(llength+2),( length (theline)-(llength+1)));
     breakchar := copy (parta,length (parta),1);
     delete(parta,length (parta),1);

     if (breakchar = '-') then begin
          partb := breakchar + partb;
          breakchar := copy (parta,length (parta),1);
          delete (parta,length (parta),1);
     end;
     while ((breakchar <> ' ')
        and (breakchar <> '-')) do
     begin
          partb := breakchar + partb;
          breakchar := copy (parta,length (parta),1);
          delete (parta,length (parta),1);
     end;
     if (breakchar = '-') then
        parta := parta + breakchar;

     writeln (thefile,parta);
     partb := squeezestr(partb);
     wrapline := partb;
end;

procedure makenewfile( var source, dest : text );
var
    crnline,
    freshline : string ;

begin {p}
     crnline := '';
{r1} repeat
        readln (source,freshline);
        freshline := squeezestr(freshline);

{i1}    if freshline <> '' then
{i2a}       if ((crnline[ length (crnline)] = '-')
            and (crnline[ length (crnline) - 1] <> ' ')) then
                 crnline := crnline + freshline
{i2b}       else
                 if crnline = '' then
                    crnline := crnline + freshline
                 else
                    crnline := crnline + ' ' + freshline;

{w1}    while length (crnline) >= (llength+1) do
                 crnline := wrapline(dest,crnline);

{r1} until eof (source);
{i3} if ( length (crnline) > 3) then
        writeln (dest,crnline);
end;  {p}

begin {main}

     if ( paramcount > 2 ) then
        showhelp(1);

     if ( paramcount = 2 ) then begin
        val ( paramstr (2), llength, valerr );
        if ( valerr <> 0 ) then
           showhelp(2);
     end
     else
        llength := 44;

     if ( llength < 40 )  or
        ( llength > 127 ) then
        showhelp(2);

     nmdone := 1;
     for i := 1 to 512 do
         filesdone[i] := '';

     if ( paramcount < 1 ) then
        spath := 'file_id.diz'
     else
        spath := paramstr(1);

     fsplit ( fexpand (spath),sdir,sname,sext);
     if (sname = '') then
         showhelp(3);

     findfirst (spath, archive, dirinfo);

     while doserror = 0 do
     begin
          sfn := sdir+dirinfo.name;
          done := false;
          for i := 1 to 512 do
              if sfn = filesdone[i] then
              done := true;

          if done = false then begin
              filesdone[nmdone] := sfn;
              dfn := sdir+'d!#$_$#!.dzy';
              tfn := sdir+'t!#$_$#!.dzy';

              write ('Wrapping ',sfn);

              openfiles(infile,outfile,sfn,dfn);
              makenewfile(infile,outfile);

              writeln (', done!');

              close (infile);
              close (outfile);
              rename (infile,tfn);
              rename (outfile,sfn);
              erase (infile);
              nmdone := nmdone + 1;
          end;
          findnext (dirinfo);
     end;
end. {main}
