/*    FARCL - Fms ARChive Lister for RBBS         */
/*   Version: 2.10                                */
/*    Author: Bob Hampton                         */
/*  Compiler: Borland C++ 2.0 - Huge memory model */
/*  Copyright (c) 1990-93 by S3-Technologies      */

#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <alloc.h>
#include <dir.h>
#include <io.h>
#include <stdio.h>
#include <conio.h>

#define MAXLINE 84
#define MAXDLD 100
#ifndef OFF
  #define OFF 0
  #define ON !OFF
#endif
#define SINGLE 1
#define DOUBLE 2

typedef struct
{					/* current window:                 */
	int left,			/* - left coordinate               */
	    top,			/* - top coordinate                */
	    right,			/* - right coordinate              */
	    bottom,			/* - bottom coordinate             */
	    fore,			/* - normal foreground color       */
	    back,			/* - normal background color       */
	    hifore,			/* - hilight foreground color      */
	    hiback,			/* - hilight background color      */
	    bstyle,			/* - border style                  */
	    bcolor,			/* - border color                  */
	    shadow;			/* - flag for 3-D shadow           */
} WININFO;



typedef struct
{
	char fms_filename[MAXDIR];     /*  name of FMS directory file         */
	char ofl_char[2];              /*  character to mark offline files    */
	char new_catcode[4];           /*  new category code for archives     */
	char ofldir[MAXDIR];           /*  name of directory to create dummies */
	char chng_filename[MAXDIR];    /*  file to write changes to           */
	char dl_direc[MAXDLD][MAXDIR]; /*  array of D/L directories to search */
} CONFIG;

typedef struct
{
	char filename[13],
	     *filepath;
	int infms;
} FLIST;

void		read_cnfgfile    (char *cnfg_filename, CONFIG *cnfg_rec, WININFO *win);
int		process_fmsfile  (CONFIG *cnfg_rec, char huge *filelist[], int num_files, int num_ndx, FILE *chng_file);
int		create_filelist  (CONFIG *cnfg_rec, char huge *filelist[], int *num_ndx, WININFO *win);
int   		fcompare         (void *elem1, void *elem2);
void  		make_wallpaper   (unsigned char c, int back);
void  		make_window      (WININFO *win);
void  		cursor           (int cmnd);
void  		fail             (char *message, char *filename);

extern unsigned _stklen = 49152;

void main (int argc, char **argv)
{
	CONFIG	cnfg_rec;		/*  config file record                  */
	char	cnfg_filename[MAXDIR],	/*  name of config file for FARCL       */
		huge *filelist[10];	/*  array of buffer pointers            */
	FILE	*chng_file;		/*  pointer to changes file             */
	int	num_files = 0,		/*  number of files in D/L directories  */
		num_ndx = 0;		/*  max. index number for filelist[]    */

	WININFO	header = {2, 2, 77, 4, YELLOW, MAGENTA, YELLOW, RED,
			  DOUBLE, LIGHTGRAY, ON},
		center = {2, 9, 77, 16, WHITE, CYAN, YELLOW, RED,
			  DOUBLE, DARKGRAY, ON};

	switch (argc)
	{
		case 1:
			strcpy (cnfg_filename, "FARCL.CFG");     /*  default config    */
			break;
		case 2:
			strcpy (cnfg_filename, *(argv + 1));     /*  get config file   */
			break;                                   /*  from command line */
		default:
			fprintf (stderr, "\nInvalid command line\n");
			fprintf (stderr, "\nUSAGE: FARCL [config file]\n");
			exit(0);
	}
	cursor (OFF);
	make_wallpaper ('.', BLUE);
	make_window (&header);
	cputs ("  FARCL version 2.10                          (c) 1990-93 by Bob Hampton");
	make_window (&center);
	read_cnfgfile (cnfg_filename, &cnfg_rec, &center);		/* read config file            */
	if (strcmp (cnfg_rec.ofl_char, "") == 0)			/* if not specified in config  */
		strcpy (cnfg_rec.ofl_char, "*");			/* use * to mark offline files */
	num_files = create_filelist (&cnfg_rec, filelist, &num_ndx, &center);	/*  set pointer to sorted  */
									/*  list of filenames from */
									/*  D/L directories        */

	if ((chng_file = fopen (cnfg_rec.chng_filename, "w")) == NULL)
	{
		fprintf (stderr, "\nUnable to create changes file %s\n", strupr (cnfg_rec.chng_filename));
		exit(0);
	}
	while (process_fmsfile (&cnfg_rec, filelist, num_files, num_ndx, chng_file));
	fclose (chng_file);
	textattr(7);
	window (1, 1, 80, 25);
	clrscr();
	cursor (ON);
}



void read_cnfgfile (char *cnfg_filename, CONFIG *cnfg_rec, WININFO *win)
{
	FILE	*cnfg_file;		/* pointer to config file            */
	int	dl_ptr = 0;		/* pointer to entries in D/L array   */
	char	buffer[MAXLINE];	/* buffer for line reads             */

	if ((cnfg_file = fopen (cnfg_filename, "r")) == NULL)
		fail ("Unable to open config file", strupr (cnfg_filename));
	gotoxy (16, 2);
	cputs ("reading config file: ");
	textattr (win->hifore + (win->hiback << 4));
	cprintf ("%s", strupr (cnfg_filename));
	textattr (win->fore + (win->back << 4));

	if (fgets (buffer, MAXLINE, cnfg_file) != NULL && *buffer != '\n')
		strcpy (cnfg_rec->fms_filename, strtok (buffer, "\n"));
	else
		strcpy (cnfg_rec->fms_filename, "");

	if (fgets (buffer, MAXLINE, cnfg_file) != NULL && *buffer != '\n')
		strcpy (cnfg_rec->ofl_char, strtok (buffer, "\n"));
	else
		strcpy (cnfg_rec->ofl_char, "");

	if (fgets (buffer, MAXLINE, cnfg_file) != NULL && *buffer != '\n')
		strcpy (cnfg_rec->new_catcode, strtok (buffer, "\n"));
	else
		strcpy (cnfg_rec->new_catcode, "");


	if (fgets (buffer, MAXLINE, cnfg_file) != NULL && *buffer != '\n')
		strcpy (cnfg_rec->ofldir, strtok (buffer, "\n"));
	else
		strcpy (cnfg_rec->ofldir, "");


	if (fgets (buffer, MAXLINE, cnfg_file) != NULL && *buffer != '\n')
		strcpy (cnfg_rec->chng_filename, strtok (buffer, "\n"));
	else
		strcpy (cnfg_rec->chng_filename, "");

	while ((fgets (buffer, MAXLINE, cnfg_file)) != NULL  && dl_ptr < MAXDLD)
		strcpy (cnfg_rec->dl_direc[dl_ptr++], strtok (buffer, "\n"));
	if (dl_ptr < MAXDLD)
		strcpy (cnfg_rec->dl_direc[dl_ptr], "END");    /* mark end of array  */

	fclose (cnfg_file);
	clrscr();
}



int create_filelist (CONFIG *cnfg_rec, char huge *filelist[], int *num_ndx, WININFO *win)
{
	FILE *tempfile;			/*  pointer to work file               */
	struct ffblk *ffblk;		/*  pointer to file info block         */
	int dl_ptr,			/*  index to D/L array element         */
	    disk,			/*  disk number                        */
	    done,			/*  flag                               */
	    num_files = 0,		/*  total number of files              */
	    workfiles,			/*  work counter for # of files        */
	    i,j;			/*  work variables                     */
	char filename[15],		/*  holder for filename                */
	     orig_path[MAXDIR],		/*  original path                      */
	     *temp_name,		/*  name of work file                  */
	     file_name[13];		/*  name of file in D/L directory      */
	unsigned long memleft;

	ffblk = (struct ffblk *) malloc (sizeof (struct ffblk));
	temp_name = mktemp ("RBARCXXXXXX");
	if ((tempfile = fopen (temp_name, "w+b")) == NULL)     /* create workfile */
		fail ("Unable to create work file", temp_name);
	dl_ptr = 0;
	getcwd (orig_path, MAXDIR);
	gotoxy (16, 2);
	cputs ("Searching directory:");
	textattr (win->hifore + (win->hiback << 4));
	while (strcmp (cnfg_rec->dl_direc[dl_ptr], "END") && dl_ptr < MAXDLD)   /* search all dirs for files */
	{
		gotoxy (38, 2);
		cprintf ("%s", cnfg_rec->dl_direc[dl_ptr]);
		textattr (win->fore + (win->back << 4));
		clreol();
		textattr (win->hifore + (win->hiback << 4));
		disk = toupper (*cnfg_rec->dl_direc[dl_ptr]) - 65;
		setdisk (disk);
		chdir (cnfg_rec->dl_direc[dl_ptr++]);
		done = findfirst ("*.*", ffblk, 0x3F);
		while (!done)
		{
			if (!(ffblk->ff_attrib & FA_DIREC))
			{
				num_files++;
				strcpy (filename, ffblk->ff_name);
				strncat (filename, "       ", 12 - strlen(filename));
				fwrite (filename, 13, 1, tempfile);
			}
			done = findnext (ffblk);
		}
	}

/*  	GO BACK TO START OF FILE */

	if (fseek (tempfile, 0L, SEEK_SET))
		printf ("error seeking...\n");
	textattr (win->fore + (win->back << 4));

/*  	CREATE WORK BUFFER(S) IN MEMORY */

	workfiles = num_files;
	while (workfiles > 5000)
	{
		clrscr();
		gotoxy (16, 2);
		cputs ("Reading file list.....");
		filelist[*num_ndx] = (char huge *) farmalloc ((unsigned long) 5000 * 13);
		if (filelist[*num_ndx] == NULL)
			fail ("Unable to allocate","filelist");
		fread ((void *) filelist[*num_ndx], 13, 5000, tempfile);
		clrscr();
		gotoxy (16, 2);
		cputs ("Sorting file list.....");
		qsort ((void *) filelist[*num_ndx], 5000, 13, (int (*) (const void *, const void *))fcompare);
		workfiles -= 5000;
		(*num_ndx)++;
	}

	clrscr();
	gotoxy (16, 2);
	cputs ("Reading file list.....");
	filelist[*num_ndx] = (char huge *) farmalloc ((unsigned long) workfiles * 13);
	if (filelist[*num_ndx] == NULL)
		fail ("Unable to allocate","filelist");
	fread ((void *) filelist[*num_ndx], 13, workfiles, tempfile);
	clrscr();
	gotoxy (16, 2);
	cputs ("Sorting file list.....");
	qsort ((void *) filelist[*num_ndx], workfiles, 13, (int (*) (const void *, const void *))fcompare);

	fclose (tempfile);
	disk = toupper (*orig_path) - 65;
	setdisk (disk);                                     /* change back to original */
	chdir (orig_path);                                  /* drive and directory     */
	unlink (temp_name);                                 /* delete the work file    */
	clrscr();
	return (num_files);
}


int process_fmsfile (CONFIG *cnfg_rec, char huge *filelist[], int num_files, int num_ndx, FILE *chng_file)
{
	FILE *fms_file,                 /*  pointer to FMS file                */
	     *temp_file,                /*  pointer to temp file               */
	     *ofl_file;                 /*  pointer to offline file            */
	char fms_line[MAXLINE],         /*  buffer for FMS file text line      */
	     *line_buf,		        /*  work buffer for FMS line           */
	     fname[9],                  /*  file name                          */
	     fext[4],                   /*  file ext                           */
	     file_name[13],             /*  file to search for                 */
	     ofl_name[MAXPATH],         /*  path/name of offline file          */
	     buffer[MAXLINE],		/*  buffer for line reads              */
	     *work,
	     *fmsarg;
	int more = 0,                   /*  set to 1 if chain to another FMS   */
	    listndx,			/*  index to filelist[]                */
	    workfiles,			/*  number of files in filelist[listndx]  */
	    found;			/*  flag for found file                */
	long offset;                    /*  used to back-up and rewrite record */

	line_buf = (char *) malloc (MAXLINE);
	if ((fms_file = fopen (cnfg_rec->fms_filename, "r+")) == NULL)
		fail ("Unable to open FMS file", strupr (cnfg_rec->fms_filename));

	while ((fgets (buffer, MAXLINE, fms_file)) != NULL)
	{
		strcpy (fms_line, strtok (buffer, "\n"));
		if (*fms_line != ' ' && *fms_line != '\\' &&
		    *fms_line != '*')
		{

			strcpy (line_buf, fms_line);
			if (*line_buf == '=')
				line_buf++;
			strcpy (fname, strtok (line_buf, " ."));
			strcpy (fext, strtok (NULL, " ."));
			strcpy (file_name, fname);
			strcat (file_name, ".");
			strcat (file_name, fext);
			strncat (file_name, "       ", 12 - strlen(file_name));

			found = listndx = 0;
			workfiles = num_files;
			while (!found && listndx <= num_ndx)
			{
				if (workfiles > 5000)
				{
					if (bsearch (file_name, (const void *) filelist[listndx++], 5000, 13, (int (*) (const void *, const void *)) fcompare))
						found = 1;
					workfiles -= 5000;
				}
				else if (bsearch (file_name, (const void *) filelist[listndx++], workfiles, 13, (int (*) (const void *, const void *)) fcompare))
					found = 1;
			}
			if (!found)
			{
				*(fms_line + 32) = *(cnfg_rec->ofl_char);
				if (strcmp (cnfg_rec->new_catcode, ""))
					strcpy ((fms_line + strlen (fms_line) - 3), cnfg_rec->new_catcode);
				strncpy (line_buf, fms_line, 73);
				line_buf[73] = '\0';
				cprintf ("\r\n%s", line_buf);
				offset = (long) (strlen (fms_line) + 2) * -1;
				fseek (fms_file, offset, SEEK_CUR);
				fprintf (fms_file, "%s\n", fms_line);
				fseek (fms_file, 0L, SEEK_CUR);
				fprintf (chng_file, "%s was marked offline\n", file_name);
				if (strcmp (cnfg_rec->ofldir, "") != 0)
				{
					strcpy (ofl_name, cnfg_rec->ofldir);
					strcat (ofl_name, "\\");
					strcat (ofl_name, file_name);
					if ((ofl_file = fopen (ofl_name, "w")) == NULL)
						fail ("Unable to create dummy file", ofl_name);
					else
						fclose (ofl_file);
				}
			}
		}
		else
			if (strcmp (strtok (fms_line, " "), "\\FMS") == 0)
			{
				while ((fmsarg = strtok (NULL, " ")) != NULL)
				{
					if (strncmp (fmsarg, "CH(", 3) == 0)
					{
						fmsarg += 3;
						fmsarg[strlen(fmsarg)-1] = '\0';
						strcpy (cnfg_rec->fms_filename, fmsarg);
						more = 1;
					}
				}
			}
	}
	fclose (fms_file);
	return (more);
}




int fcompare (void *elem1, void *elem2)
{
	return (strcmp (elem1, elem2));
}




void make_wallpaper (unsigned char c, int back)
{
	int far *video,
		row,
		col,
		attr,
		i;
	struct text_info tinfo;

	gettextinfo (&tinfo);
	if (tinfo.currmode == MONO)
		video = (int far *) 0xB0000000;
	else
		video = (int far *) 0xB8000000;
	attr = LIGHTGRAY + (back << 4);
	textattr (attr);
	clrscr();
	for (row = 0; row < 25; row += 2)
		if (row % 4 == 0)
			for (col = 0; col < 80; col += 10)
				*(video + (row * 80) + col + 2) = c | (attr << 8);
		else
			for (col = 5; col < 80; col += 10)
				*(video + (row * 80) + col + 2) = c | (attr << 8);
}


void make_window (WININFO *win)
{
	int row, col, attr, pos,
	    far *video;
	char *savetext;
	struct text_info tinfo;
	struct
	{
		int upleft, upright, dnleft, dnright,
		    vert, horiz;
	} border[3] = {{ 32,  32,  32,  32,  32,  32},
		       {218, 191, 192, 217, 179, 196},
		       {201, 187, 200, 188, 186, 205}};

	gettextinfo (&tinfo);
	if (tinfo.currmode == MONO)
		video = (int far *) 0xB0000000;
	else
		video = (int far *) 0xB8000000;
	attr = (win->bcolor + (win->back << 4)) << 8;
	*(video + (win->top - 1) * 80 + win->left - 1) = border[win->bstyle].upleft | attr;
	*(video + (win->top - 1) * 80 + win->right - 1) = border[win->bstyle].upright | attr;
	*(video + (win->bottom - 1) * 80 + win->left - 1) = border[win->bstyle].dnleft | attr;
	*(video + (win->bottom - 1) * 80 + win->right - 1) = border[win->bstyle].dnright | attr;
	for (col = win->left; col < win->right-1; col++)
	{
		*(video + ((win->top-1)*80) + col) = border[win->bstyle].horiz | attr;
		*(video + ((win->bottom-1)*80) + col) = border[win->bstyle].horiz | attr;
	}
	for (row = win->top; row < win->bottom-1; row++)
	{
		*(video + (row * 80) + win->left-1) = border[win->bstyle].vert | attr;
		*(video + (row * 80) + win->right-1) = border[win->bstyle].vert | attr;
	}
	window (win->left+1, win->top+1, win->right-1, win->bottom-1);
	textattr (win->fore + (win->back << 4));
	clrscr();
	if (win->shadow)
	{
		for (row = win->top; row <= win->bottom; row++)
		{
			*(video + (row * 80) + win->right) &= 0x00FF;
			*(video + (row * 80) + win->right) |= (DARKGRAY + (BLACK << 4)) << 8;
			*(video + (row * 80) + win->right + 1) &= 0x00FF;
			*(video + (row * 80) + win->right + 1) |= (DARKGRAY + (BLACK << 4)) << 8;
		}
		for (col = win->left+1; col <= win->right; col++)
		{
			*(video + (win->bottom * 80) + col) &= 0x00FF;
			*(video + (win->bottom * 80) + col) |= (DARKGRAY + (BLACK << 4)) << 8;
		}
	}
}




void cursor (int cmnd)
{
	union REGS regs;
	int attribute;

	regs.h.ah = 0x01;
	if (cmnd == OFF)
		attribute = 0x01;
	else
		attribute = 0x00;
	regs.h.ch = attribute << 5 | 6;
	regs.h.cl = 7;
	int86 (0x10, &regs, &regs);
}


void fail (char *message, char *filename)
{
	clrscr();
	gotoxy (16,2);
	cprintf ("%c%s %s ", 0x07, message, filename);
	gotoxy (16,3);
	perror ("");
	textattr (7);
	cursor (ON);
	exit (1);
}
