
{* *
 * *
 * *   I M A I L   D E F I N I T I O N S   A N D   S T R U C T U R E S
 * *
 * *}

{*
 *  Definitions and structures for IMAIL 1.60
 *
 *  Copyright (C) 1992-1994 by Andreas Klein. All rights reserved.
 *
 *  The contents of this file are subject to change without notice!
 *  Fields marked reserved may NOT be used.
 *
 *  It is an ERROR to write to any of the configuration files
 *  while IMAIL (or any of its companion programs) is running.
 * 
 *}


{=========================================================================}
{  CONSTANT DEFINITIONS                                                   }
{=========================================================================}

const IM_MAJ_VERSION     = 1;
      IM_MIN_VERSION     = 60;
      IM_PRD_CODE        = $4B;
      STR_MAJ_VERSION    = 4;
      STR_MIN_VERSION    = 01;

{-------------------------------------------------------------------------}
{  Internal limits                                                        }
{-------------------------------------------------------------------------}

const  MAXAKAS     = 16;                   { Max # of addresses           }
       MAXPACKERS  = 11;                   { Max # of packer def          }
       MAXEXPORT   = 200;                  { Max export defs              }
       MAXVIA      = 40;                   { max nodes packed via         }
       MAXPACK     = 32;                   { max default pack cmd         }
       MAXEXCEPT   = 10;                   { max EXCEPT nodes             }
       MAXFWDLINK  = 15;                   { max fwd link structs         }
       MAXNOIMPT   = 20;                   { max # of names               }
       ZONESDOM    = 10;                   { zones per domain entry       }
       MAXTAG      = 51;                   { Max length of an areatag     }
       MAXNAME     = 37;                   { Max length of a namefield    }
       MAXPACKNAME = 50;                   { Max length of a packer entry }
       MAXORIGIN   = 64;                   { Max length of an origin      }

       MAXPATH     = 80;                   { Max length of path           }
       MAXFILE     = 11;                   { Max length of file           }
       MAXEXT      = 3;                    { Max length of extension      }
       MAXFNAME    = MAXFILE+MAXEXT;       { Max length of a filename     }
       MAXDOMAIN   = 21;                   { Max length of a domainname   }
       MAXPWD      = 21;                   { Max length of a password     }

{-------------------------------------------------------------------------}
{  Log Style Definitions                                                  }
{-------------------------------------------------------------------------}

const  LOG_NORMAL  = 0;                    { normal log level             }
       LOG_VERBOSE = 1;                    { verbose log level            }

{-------------------------------------------------------------------------}
{  Environment Type                                                       }
{-------------------------------------------------------------------------}

const  ENV_FRODO   = 0;                    { FrontDoor/D'Bridge           }
       ENV_BINK    = 1;                    { Binkley                      }
       ENV_IM      = 2;                    { Intermail                    }
       ENV_DB      = 3;                    { D'Bridge                     }
       ENV_POP     = 4;                    { Portal of Power              }

{-------------------------------------------------------------------------}
{  BBS Environment Type                                                   }
{-------------------------------------------------------------------------}

const  BBS_RA2     = 0;                    { Remote Access 2.0            }
       BBS_OTHER   = 1;                    { Other                        }

{-------------------------------------------------------------------------}
{  File Attach Message Status (used in IMAIL.ND)                          }
{-------------------------------------------------------------------------}

const  S_NORMAL            = 0;
       S_HOLD              = 1;
       S_CRASH             = 2;
       S_IMMEDIATE         = 3;
       S_DIRECT            = 4;
       S_NORMAL_DIR        = 4;
       S_HOLD_DIR          = 5;
       S_CRASH_DIR         = 6;
       S_IMMEDIATE_DIR     = 7;

{-------------------------------------------------------------------------}
{  Message Base Types                                                     }
{-------------------------------------------------------------------------}

const  MSGTYPE_SDM    = $01;
       MSGTYPE_SQUISH = $02;
       MSGTYPE_HUDSON = $03;
       MSGTYPE_QBBS   = $03;
       MSGTYPE_JAM    = $04;
       MSGTYPE_PASSTH = $0F;
       MSGTYPE_ECHO   = $80;
       MSGTYPE_LOCAL  = $90;
       MSGTYPE_NET    = $A0;

{-------------------------------------------------------------------------}
{  Via Line Switches                                                      }
{-------------------------------------------------------------------------}

const VIA_NONE        =   1;
      VIA_EXP         =   2;
      VIA_IMP         =   3;
      VIA_BOTH        =   4;

{-------------------------------------------------------------------------}
{  Dupe ring check switches                                               }
{-------------------------------------------------------------------------}

const DUPE_NONE       =   0;
      DUPE_WARN       =   1;
      DUPE_ZONE       =   2;
      DUPE_KILL       =   3;

{-------------------------------------------------------------------------}
{ Circular path detection switches                                        }
{-------------------------------------------------------------------------}

const CPD_NONE        =   0;
      CPD_WARN        =   1;
      CPD_KILL        =   2;

{-------------------------------------------------------------------------}
{  Unlink Switches                                                        }
{-------------------------------------------------------------------------}

const ULNK_NONE       =   0;
      ULNK_PASSTH     =   1;
      ULNK_ALL        =   2;

{-------------------------------------------------------------------------}
{  Personal Mail handling                                                 }
{-------------------------------------------------------------------------}

const PERSM_NONE      =   0;
      PERSM_LOG       =   1;
      PERSM_MSG       =   2;
      PERSM_COPY      =   3;

{-------------------------------------------------------------------------}
{  AreaLink Request Handling                                              }
{-------------------------------------------------------------------------}

const KEEP_NONE       =   0;
      KEEP_MSG        =   1;
      KEEP_ALL        =   2;

{-------------------------------------------------------------------------}
{  Macros to make life easier                                             }
{-------------------------------------------------------------------------}

const BASEMASK          = $0F;
      TYPEMASK          = $F0;

{-------------------------------------------------------------------------}
{  Exit Errorlevels & Error Messages                                      }
{-------------------------------------------------------------------------}

const  E_NOERR        =   0;               { no error                     }
       E_CRDIR        = 238;               { Error creating directory     }
       E_ELOCK        = 239;               { File locking error           }
       E_AOPEN        = 240;               { Error opening IMAIL.AX       }
       E_BOPEN        = 241;               { Error opening IMAIL.BX       }
       E_NOIDX        = 242;               { Index file missing/corrupt   }
       E_NOCFG        = 243;               { IMAIL.CF not found           }
       E_NOARE        = 244;               { IMAIL.AR not found           }
       E_NONOD        = 245;               { IMAIL.ND not found           }
       E_BADCF        = 246;               { Error in IMAIL.CF            }
       E_BADVR        = 247;               { Bad version of IMAIL.CF      }
       E_EOPEN        = 248;               { Error opening file           }
       E_EREAD        = 249;               { Error reading file           }
       E_EWRIT        = 250;               { Error writing file           }
       E_CMDPR        = 251;               { Command Line Parameter error }
       E_FILNF        = 252;               { File not found               }
       E_MEMRY        = 253;               { Memory Allocation error      }
       E_DISKF        = 254;               { Insufficient disk space      }
       E_UNKWN        = 255;               { Unknown error                }

       { === ERRORLEVELs returned by TOSS and/or SCAN === }

       T_NOMAIL       = $00;               { no mail processed            }
       T_NET          = $01;               { Net mail                     }
       T_ECHO         = $02;               { Echo mail                    }
       T_BAD          = $04;               { Bad and/or dupe mail         }
       T_QBBS         = $08;               { Qbbs message base changed    }
       T_MSG          = $10;               {.MSG message base changed     }
       T_SQUISH       = $20;               { Squish message base changed  }
       T_PERS         = $40;               { Mail to Sysop received       }

{-------------------------------------------------------------------------}
{  Special values for 'ALL'                                               }
{-------------------------------------------------------------------------}

const  ZONE_ALL       = 56685;             { Pack for all zones           }
       NET_ALL        = 56685;             { Pack for all nets           }
       NODE_ALL       = 56685;             { Pack for all nodes           }
       POINT_ALL      = 56685;             { Pack for all points          }

{-------------------------------------------------------------------------}
{  Capability defintions                                                  }
{-------------------------------------------------------------------------}

const  CAP_TYPE2      = $01;               { Can make Type 2 bundles      }
       CAP_STONAGE    = $00;               { No capabalities              }


{=========================================================================}
{  STRUCTURE DEFINITIONS                                                  }
{=========================================================================}

{-------------------------------------------------------------------------}
{  Structs used in IMAIL Configuration files                              }
{-------------------------------------------------------------------------}

TYPE

   areatag    = array [1..MAXTAG] of char;

   origin_typ = array [1..MAXORIGIN] of char;

   path_typ   = array [1..MAXPATH] of char;

   packer_typ = array [1..MAXPACKNAME] of char;

   naddress = record                       { std node number ...          }
     zone  : word;                         { Zone Number                  }
     net   : word;                         { Net Number                   }
     node  : word;                         { Node Number                  }
     point : word;                         { Point Number                 }
   end;

   expt = record
     dest   : naddress;
     doexpt : boolean;
   end;

   pack_struct = record                       { used in pack routing      }
     dst    : naddress;                       { pack via this node        }
     nodes  : array [1..MAXVIA] of naddress;  { nodes to pack             }
     except : array[1..MAXEXCEPT] of naddress;{ exceptions                }
   end;

   eaddress = record
     dstn      : naddress;                 { destination-address          }
     bitfield1 : byte;
   { exp_only  : bit_0;                      export only to this address  }
   { imp_only  : bit_1;                      import only from this address}
   { paused    : bit_2;                      echomail paused              }
   { reserved  : bit_3-7;                    reserved                     }
   end;

   fwd_link = record                          { used for forward requests }
     areasfile : array [1..MAXFNAME] of char; { name of areas file        }
     toprogram : array [1..10] of char;       { name of area manager      }
     password  : array [1..MAXPWD] of char;   { area manager password     }
     uplink    : naddress;                    { address of uplink         }
     accessgrp : char;                        { grp to access this list   }
     creategrp : char;                        { grp to create echos       }
     filler    : array[1..10] of char;        { reserved                  }
   end;

   dom      = record
     domain    : array [1..MAXDOMAIN] of char;{ name of domain            }
     outbound  : array [1..MAXPATH] of char;  { root outbound path        }
     zones     : array [1..ZONESDOM] of word; { zones in this domain      }
     akas      : array [1..MAXAKAS] of byte;  { =my= akas in this domain  }
   end;

   im_stats = record                          { flow statistics           }
     th_day_nr     : longint;                 { this day                  }
     la_day_nr     : longint;                 { last day                  }
     th_week_nr    : longint;                 { this week                 }
     la_week_nr    : longint;                 { last week                 }
     th_month_nr   : longint;                 { this month                }
     la_month_nr   : longint;                 { last month                }
     th_year_nr    : longint;                 { this year                 }
     la_year_nr    : longint;                 { last year                 }
     th_day_size   : longint;                 { this day                  }
     la_day_size   : longint;                 { last day                  }
     th_week_size  : longint;                 { this week                 }
     la_week_size  : longint;                 { last week                 }
     th_month_size : longint;                 { this month                }
     la_month_size : longint;                 { last month                }
     th_year_size  : longint;                 { this year                 }
     la_year_size  : longint;                 { last year                 }
   end;

{-------------------------------------------------------------------------}
{  IMAIL.CF Structure                                                     }
{-------------------------------------------------------------------------}

TYPE

im_config_type = record
  im_ver_maj   : byte;                        { Major Version             }
  im_ver_min   : byte;                        { Minor Version             }
  struct_maj   : byte;                        { Major struct version      }
  struct_min   : byte;                        { Minor struct version      }
  sysop        : array [1..MAXNAME] of char;  { name of sysop             }
  aka          : array [1..MAXAKAS] of naddress; { the AKAs               }
  domains      : array [1..MAXAKAS] of dom;   { domain names & zones      }
  rsvd1        : array [1..10] of char;       { reserved                  }
  netmail      : path_typ;                    { net mail subdirectory     }
  netfile      : path_typ;                    { inbound files directory   }
  in_pkt       : path_typ;                    { Dir for inbound PKTs      }
  out_pkt      : path_typ;                    { Dir for outbound PKTs     }
  outbound     : path_typ;                    { outbound directory        }
  quickbbs     : path_typ;                    { QuickBBS system directory }
  uns_netfile  : path_typ;                    { unsecured inbound files   }
  echotoss     : path_typ;                    { name of echotoss.log      }
  dupebase     : path_typ;                    { directory for dupe base   }
  semaphor     : path_typ;                    { Semaphor directory        }
  logfilename  : path_typ;                    { Log file name             }
  before_toss  : path_typ;                    { call before proc. PKTs    }
  semaphor_net : array [1..MAXFNAME] of char; { Netmail rescan semaphor file}
  alnk_help    : array [1..MAXFNAME] of char; { AreaLink help text        }
  maint_help   : array [1..MAXFNAME] of char; { Alnk Remote Maint. Helpfile}
  rsvd2        : array [1..MAXFNAME] of char; { reserved                  }
  dflt_origin  : origin_typ;                  { default origin line       }
  bitfield1    : byte;                        { has been changed from 1.10}
{  rtnrecpt     : bit_0;                        True if to send rtn recpt }
{  del_empty_msg: bit_1;                        delete empty netmails     }
{  ARCmail06    : bit_2;                        ARCmail 0.6 compatibility }
{  use_crc_names: bit_3;                        use crc-names for auto-areas}
{  rsvd3        : bit_4;                        reserved                  }
{  multi_task   : bit_5;                        TRUE if multi-tasking     }
{  ignore_unkw  : bit_6;                        ALNK ignores unkwn systems}
{  singleextract: bit_7;                        extract 1 bundle at a time}
  bitfield2    : byte;
{  trunc_sent   : bit_0;                        1 = Trunc 0 = Delete      }
{  keep_alnk_ans: bit_1;                        keep areafix message      }
{  prod_names   : bit_2;                        use product names         }
{  swap_ems     : bit_3;                        swap to EMS               }
{  swap_ext     : bit_4;                        swap to extended memory   }
{  forward_every: bit_5;                        forward req. not in lists }
{  direct_video : bit_6;                        use direct screen i/o     }
{  rsvd4        : bit_7;                        reserved                  }
  bitfield3    : byte;
{  compr_after  : bit_0;                        compress after each PKT   }
{  delete_bases : bit_1;                        when removing an area     }
{                                               delete squish/msg-base    }
{  rsvd5        : bit_2;                        reserved                  }
{  use_imcomp   : bit_3;                        call IMCOMP in case of tight}
{                                                diskspace or abort at once}
  last_run     : longint;                     { last maintenance update   }
  rsvd6        : byte;                        { reserved                  }
  rsvd7        : byte;                        { reserved                  }
  rsvd8        : word;                        { reserved                  }
  max_arcmail_size : word;                    { max size of arcmail bundles}
  pwd_exp_days : word;                        { days before pwd expired   }
  max_pkt_size : word;                        { max size of pkt to create }
  max_add_pkt  : byte;                        { PKTs to compress in one run}
  pkt_not_forus: byte;                        { how handle PKTs not for us}
  environment  : byte;                        { FroDo, Binkley or Intermail}
  max_msg_size : byte;                        { max size of netmail (split)}
  via_line     : byte;                        { add Via Line to netmails  }
  dupe_ring    : byte;                        { Check for possible d-rings}
  cpd_check    : byte;                        { Check for circular paths  }
  pers_mail    : byte;                        { use personal mail feature }
  unlink_req   : byte;                        { Unlink areas without dlink}
  keep_alnk_req: byte;                        { keep arealink request     }
  rsvd9        : byte;                        { reserved                  }
  max_dupes    : longint;                     { max dupes kept in database}
  max_files_per_dir : word;                   { max. nr files when autocreate}
  deadlink_days: byte;                        { nr of days for a dealink req}
  rsvd10       : byte;                        { reserved                  }
  bbs_system   : char;                        { BBS software used         }
  new_areas    : path_typ;                    { name of file for new areas}
  sp_before_unpack   : word;                  { min. diskspace required   }
  sp_before_toss     : word;                  { before decompress, toss   }
  sp_before_compress : word;                  { and compress (in MB).     }
  kill_dead    : byte;                        { Kill Dead Selection       }
  prod         : array [1..20] of word;       { Type 2+ product codes     }
  rsvd11       : array [1..720] of char;      { reserved                  }
  fwd          : array [1..MAXFWDLINK] of fwd_link;
                                              { forward link requests     }
  echojam      : path_typ;                    { path to ECHOMAIL.JAM      }
  before_toss_ii: path_typ;                   { call before proc. PKTs    }
  userbase     : path_typ;                    { path to USERS.BBS         }
  stoptossmsgs : longint;                     { stop tossing after xxxxx msgs}
  stoptossnetmsgs: longint;                   { stop tossing after xxxxx net}
                                              { msgs within a PKT or at all}
  ignorelist   : path_typ;                    { list of areas to suppress }
  db_queue     : path_typ;                    { D'Bridge queue directory  }
  log_level    : longint;                     { logging level             }
  att_status   : char;                        { Def. status of attach msg }
  msg_status   : char;                        { Def. status of Alnk msgs  }
  filler       : array [1..278] of char;      { reserved                  }
end;


{-------------------------------------------------------------------------}
{  IMAIL.AR Structure                                                     }
{-------------------------------------------------------------------------}

TYPE

areas_record_type = record
  aname         : areatag;                      { area name               }
  comment       : array [1..61] of char;        { area comment            }
  origin        : origin_typ;                   { origin line to use      }
  group         : char;                         { area group              }
  o_addr        : byte;                         { address for origin      }
  use_akas      : array [1..MAXAKAS] of char;   { addresses for seen-bys  }
  msg_base_type : byte;                         { message base type       }
  brd           : byte;                         { board number            }
  msg_path      : path_typ;                     { MSG directory           }
  bitfield1     : byte;
{  active        : bit_0;                         flag area active        }
{  zone_gate     : bit_1;                         Zone-gate stripping     }
{  tiny_seen     : bit_2;                         tiny seen-by flag       }
{  secure        : bit_3;                         secure flag             }
{  keep_seen     : bit_4;                         keep seen-by flag       }
{  deleted       : bit_5;                         flag deleted area       }
{  auto_added    : bit_6;                         flag auto-added record  }
{  mandatory     : bit_7;                         area is mandatory       }
  bitfield2     : byte;                         {                         }
{  read_only     : bit_0;                         area is read only       }
{  unlinked      : bit_1;                         area has been unlinked  }
{  ulnk_req      : bit_2;                         perform unlinked requests?}
{  hidden        : bit_3;                         area ist hidden         }
{  to_link       : bit_4;                         should by processed by LINK}
{  check_dup     : bit_5;                         check dupes in this area}
{  no_pause      : bit_6;                         %PAUSE not allowed here }
{  hide_seen     : bit_7;                         Hide seens when importing}
  bitfield3     : byte;                         {                         }
{  manual        : bit_0;                         No changes via Arealink }
{  fwdreq_pending: bit_1;                         Fwd-Request pending     }
{  sqkillfly     : bit_2;                         Squish 'Kill on the fly'}
{  dupe_msgid    : bit_3;                         Dupecheck on MSGID only?}
  user_bits     : byte;                         { 8-bit useravailable bits}
  days          : byte;                         { days to keep messages   }
  msgs          : word;                         { num messages to keep    }
  stats         : im_stats;                     { flow statistics         }
  creation      : longint;                      { date/time of creation   }
  update        : longint;                      { last update by STAT     }
  marked        : longint;                      { used by kill dead       }
  kill_dead     : byte;                         { kill echos w/o traffic  }
   read_sec     : word;                     { read access sec level       }
   write_sec    : word;                     { write access sec level      }
  filler        : array [1..30] of char;
  export        : array [1..MAXEXPORT] of eaddress; { export list             }
end;

    { --- Notes ---------------------------------------------------

    1) The entries in 'o_addr' and 'use_akas' are indexes into the
       list of AKAs in IMAIL.CF, minus 1. eg:
            im_config.aka[o_addr-1]
       A value of 0 means 'no address'.

    2) the 'user_bits' entry allows third-part software to store
       extra information in IMAIL.AR. Their meaning is program-
       specific, so be careful when making use of them!

    3) IMAIL.AR knows three predefined areatags:

         BADMAIL       for the IMAIL badmail area,
         DUPES         for the IMAIL dupe area and
         PERSMAIL      for the IMAIL personal mail area.

       All three boards are treated as local areas and
       the BADMAIL area must be present and non-passthru
       otherwise IMAIL will not run.
    --------------------------------------------------------------- }

{-----------------------------------------------------------------------}
{  IMAIL.AX & IMAIL.BX Structures                                       }
{-----------------------------------------------------------------------}

    { --- Notes ---------------------------------------------------

    1) These are "true" index files, created by BTree routines;
       they cannot be used unless you have the BTree source
       code as implemented in IMAIL.

    --------------------------------------------------------------- }

{-----------------------------------------------------------------------}
{  IMAIL.ND Structure                                                   }
{-----------------------------------------------------------------------}

TYPE

node_record_type = record
  dstn          : naddress;                 { Node to pack for            }
  sysop         : array [1..MAXNAME] of char;{ name of sysop               }
  domain        : char;                     { index to domain             }
  pwd           : array [1..MAXPWD] of char;{ AreaFix/Bndl password       }
  att_status    : char;                     { Status of file attach msg   }
{ Packprogram was originally named "program" ! }
  Packprogram   : char;                     { packer to use ("packers")   }
  groups        : array [1..27] of char;    { groups node can request     }
  capability    : word;                     { capability word for node    }
  bitfield1     : byte;
{  allow_remote  : bit_0;                     allow remote maint.         }
{  rsvd1         : bit_1;                     reserved                    }
{  auto_cap      : bit_2;                     auto-detect capability      }
{  auto_added    : bit_3;                     record added by IMAIL       }
{  newarea_add   : bit_4;                     auto add to new areas       }
{  newarea_create: bit_5;                     create new areas            }
{  Rescan_ok     : bit_6;                     allow node to rescan        }
{  Notify        : bit_7;                     send notify messages        }
  bitfield2     : byte;
{  rsvd2         : bit_0;                                                 }
{  rsvd3         : bit_1;                                                 }
{  forward_req   : bit_2;                     send forward requests?      }
{  uplink        : bit_3;                     Is this system an uplink?   }
{  fsc_comp      : bit_4;                     Is a FSC-0057 arealink used?}
{  change_packer : bit_5;                     system may change packer    }
{  check_alnk    : bit_6;                     check for Arealink-Msgs     }
  user_bits     : word;                     { 16 user-available bits      }
  newarea_group : char;                     { group for autoadded area    }
  pkt_password  : array [1..9] of char;     { password to include in PKTs }
  last_pwd_change: longint;                 { time ALNK pwd last changed  }
  toprogram     : array [1..11] of char;    { name of area manager        }
  msg_status    : char;                     { Status of Alnk messages     }
  pkt_o_addr    : char;                     { origaddress used for PKTs   }
  msgs_in       : longint;                  { nr of msgs received         }
  bytes_in      : longint;                  { amount of msgs received     }
  msgs_out      : longint;                  { nr of msgs sent             }
  bytes_out     : longint;                  { amount of msgs sent         }
  lrdate        : longint;                  { date/time of statistic start}
  pack_priority : byte;                     { priority (9-0) when compressing}
  security      : word;                     { sec level for area access   }
  max_arcmail_size: word;                   { max size of arcmail bundles }
  max_pkt_size  : word;                     { max size of pkt to create   }
  max_add_pkt   : byte;                     { PKTs to compress in one run }
  filler        : array [1..38] of char;
end;

    { --- Notes ---------------------------------------------------

    1) the 'user_bits' entry allows third-part software to store
       extra information in IMAIL.ND. Their meaning is program-
       specific, so be careful when making use of them!

    --------------------------------------------------------------- }

{-----------------------------------------------------------------------}
{  IMAIL.GR Structure                                                   }
{-----------------------------------------------------------------------}

TYPE

group_record_type  = record
  grp_desc      : array[1..27] of char;     { Group description           }
  msg_base_type : byte;                     { message base type           }
  msg_path      : path_typ;                 { MSG/Squish path             }
  bitfield1     : byte;
{  active       : bit_0;                      flag area active            }
{  zone_gate    : bit_1;                      Zone-gate stripping         }
{  tiny_seen    : bit_2;                      tiny seen-by flag           }
{  secure       : bit_3;                      secure flag                 }
{  keep_seen    : bit_4;                      keep seen-by flag           }
{  mandatory    : bit_5;                      area is mandatory           }
{  read_only    : bit_6;                      area is read only           }
{  ulnk_req     : bit_7;                      perform unlinked requests?  }
  bitfield2     : byte;
{  hidden       : bit_0;                      area is hidden              }
{  check_dup    : bit_1;                      check for dupes             }
{  no_pause     : bit_2;                      %PAUSE not allowed          }
{  hide_seen    : bit_3;                      Hide seens when importing   }
{  sqkillfly    : bit_4;                      Squish 'Kill on the fly'    }
{  dupe_msgid   : bit_5;                      Dupecheck on MSGID only?    }
   days         : byte;                     { days to keep messages       }
   msgs         : word;                     { num messages to keep        }
   o_addr       : char;                     { address for origin          }
   use_akas     : array[1..MAXAKAS] of char;{ addresses for seen-bys      }
   kill_dead    : byte;                     { kill echos without traffic  }
   low_board    : byte;                     { Hudson boards for autocreate}
   high_board   : byte;                     { lowest and highest          }
   read_sec     : word;                     { read access sec level       }
   write_sec    : word;                     { write access sec level      }
   filler       : array[1..44] of char;     { reserved                    }
end;

{-----------------------------------------------------------------------}
{  IMAIL.PR Structure                                                   }
{-----------------------------------------------------------------------}

pack_routing_type = record                  { used in pack routing        }
  dst    : naddress;                        { pack via this node          }
  nodes  : array[1..MAXVIA] of naddress;    { nodes to pack               }
  except : array[1..MAXEXCEPT] of naddress; { exceptions                  }
end;

  { Note: In the current implementation, the pack routing has
          as much records as defined in MAXPACK.              }

{-----------------------------------------------------------------------}
{  IMAIL.PP Structure                                                   }
{-----------------------------------------------------------------------}

TYPE

packers = record
  packname   : array[1..5] of char;
  packer     : array[1..MAXPACKNAME] of char;
end;

compression_type = record
  prg        : array[1..MAXPACKERS] of packers;{ Packer defintions        }
  arcunpak   : array[1..MAXPACKNAME] of char;  { cmd to de-arc .ARC files }
  arjunpak   : array[1..MAXPACKNAME] of char;  { cmd to de-arc .ARJ files }
  pkpakunpak : array[1..MAXPACKNAME] of char;  { cmd to de-arc .PKA files }
  pkzipunpak : array[1..MAXPACKNAME] of char;  { cmd to de-arc .ZIP files }
  lharcunpak : array[1..MAXPACKNAME] of char;  { cmd to de-arc .LZH files }
  zoounpak   : array[1..MAXPACKNAME] of char;  { cmd to de-arc .ZOO files }
  pakunpak   : array[1..MAXPACKNAME] of char;  { cmd to de-arc .PAK files }
  sqzunpak   : array[1..MAXPACKNAME] of char;  { cmd to de-arc .SQZ files }
  uc2unpak   : array[1..MAXPACKNAME] of char;  { cmd to de-arc .UC2 files }
  rarunpak   : array[1..MAXPACKNAME] of char;  { cmd to de-arc .RAR files }
  unkunpak   : array[1..MAXPACKNAME] of char;  { cmd to de-arc unknown files}
end;


{-----------------------------------------------------------------------}
{  IMAIL.DP/IMAIL.DPI Structure                                         }
{-----------------------------------------------------------------------}

    { --- Notes ---------------------------------------------------------

       The dupe database consists simply of a series of long-sized
       values, which are a two 32-bit CRC of (in order) the following
       data:

       CRC 1: Addressee's name
              Sender's name
              Date
              Subject

       CRC 2: Address and MSGID (if any otherwise 0L)

    --------------------------------------------------------------------- }

{ end of IMAIL-structures }
{-----------------------------------------------------------------------}

