{$i-} program ColorPCBoardDirfile;
uses dos;
type Colors = (CLRname, CLRsize, CLRdate, CLRdesc, CLRinfo);
var  ColorARRAY : Array[Colors] of String[15];

procedure showhelp(const problem :byte);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
const
  progdesc = 'PCBColor- Free DOS utility: PCBoard filelist colorizer.';
  author   = 'v1.00: January 9, 1995. (c) 1995 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage: PCBColor file(s)_to_colorize';
var
  message : string[79];
begin
  writeln(progdesc);
  writeln(author);    writeln;
  writeln(usage);     writeln;
  if problem > 0 then begin
    case problem of
      1 : message := 'Configuration file not found with executable.  Consult the documentation.';
      3 : message := 'No files found.  First parameter must be a valid file specification.';
      6 : message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message := 'Error opening, closing, or renaming a file.  Original may be renamed!';
    else  message := 'Unknown error.';
    end;
    writeln (#7, 'Error encountered:'); writeln (message);
  end;
  halt(problem);
end;

FUNCTION Upper (w:STRING) : STRING;
VAR
  cp  : Integer;        {The position of the character to change.}
BEGIN
  FOR cp:= 1 TO Length (w) DO
    w[cp]:= UpCase (w[cp]);
  Upper:= w;
END;

procedure iocheck(const iores :byte);
begin
  if iores <> 0 then showhelp(7);
end;

function fileexists(const filename:pathstr):boolean;
var
  attr : word;
  f    : file;
begin
  assign (f, filename);
  getfattr (f, attr);
  fileexists := (DOSerror = 0);
end;

function extractCode(const colorline:string):string;
const
  space = #32;
var
  templine : string[40];
begin
  templine := copy(colorline,
              pos('[',colorline)+1,
              (pos(']',colorline)-(pos('[',colorline)+1)));

  while (templine <> '') and (templine[length(templine)]=space) do
      dec(templine[0]);
  while (templine <> '') and (templine[1]=space) do
      delete(templine,1,1);

  extractCode:=templine;
end;

procedure InitColors;
var
  epath, cpath  : pathstr;
    {epath & cpath are fully qualified pathnames of .exe & .cfg files}
  edir          : dirstr;
  ename         : namestr;
  eext          : extstr;

  config        : text;
  tstr,
  configline    : string[80];

begin
  epath := (paramstr (0));
  fsplit(fexpand(epath),edir,ename,eext); { break up path into components }
  cpath := edir+ename+'.cfg';

  if fileexists(cpath) then
  begin
    assign (config, cpath);
    reset (config);
    iocheck(ioresult);
  end
  else
    showhelp(1);

  ColorARRAY[CLRname]:='';
  ColorARRAY[CLRsize]:='';
  ColorARRAY[CLRdate]:='';
  ColorARRAY[CLRdesc]:='';
  ColorARRAY[CLRinfo]:='';

    repeat  { readColorArray }
      readln(config,configline);
      tstr:=upper(copy(configline,1,7));
      if copy(tstr,1,3)='CLR' then
      begin
        if tstr='CLRNAME' then ColorARRAY[CLRname] := extractCode(configline)
   else if tstr='CLRSIZE' then ColorARRAY[CLRsize] := extractCode(configline)
   else if tstr='CLRDATE' then ColorARRAY[CLRdate] := extractCode(configline)
   else if tstr='CLRDESC' then ColorARRAY[CLRdesc] := extractCode(configline)
   else if tstr='CLRINFO' then ColorARRAY[CLRinfo] := extractCode(configline)
      end;
    until eof(config);                     { loop back to read another line }
  close (config);
end;

procedure openfiles(var file_in, file_out :text; const name1, name2 :string);
begin
  assign(file_in,name1);
  reset(file_in);         iocheck(ioresult);
  assign(file_out,name2);
  rewrite(file_out);      iocheck(ioresult);
end;

function isfirstline(const currentline :string) :boolean;
const
  hyphen=#45; space=#32;  { simple ways of minimizing typing errors  }

var isfirst : boolean;    { is this the first line of a file desc?   }
  valsize   : longint;    { filesize }
  valcode   : integer;    { will give error if filesize not a number }
begin
{----
  Determine a valid first line by looking for a non-space/ control char in
   the first position, and verifying file size, date, and proper spacing
   between the size and date (file size is a number in columns 15-21).
----}
  isfirst := false;
  if ((length(currentline) > 30) and (currentline[1] > space)) then begin
     val(copy(currentline,15,7),valsize,valcode);
     if (valcode = 0) then
       isfirst:=((currentline[26] = hyphen) and (currentline[29] = hyphen) and
                 (currentline[22] = space)  and (currentline[23] = space));
  end;
  isfirstline:=isfirst;
end;

procedure makenewfile(var source, dest :text); {actually rewrite the file }
var
  freshline : string;     { the line just read, now being processed       }
  indesc    : boolean;    { have we found a first line of a description ? }
  descline  : byte;       { if second line of description, then colorize  }
                          { with CLRinfo color code                       }
begin
  indesc  := false;       { Initialize some vars... }
  repeat
    fillChar(freshline,sizeof(freshline),0);     { clear out old line !!! }
    readln(source,freshline);

    if ((freshline[1] = #32) and indesc) then   {Process description line }
      begin
        descline:=descline+1;
        if descline=2 then
          freshline:=ColorARRAY[CLRinfo]+freshline
      end
    else
      begin    { First char not a space, or not processing a description, }
        indesc:=isfirstline(freshline); { Perhaps it starts a new filedesc}
        if indesc then               { YES!, we are in a new description! }
          begin
          freshline:=
            ColorARRAY[CLRname]+
             copy(freshline,1,12)+
            ColorARRAY[CLRsize]+
             copy(freshline,13+(length(ColorARRAY[CLRsize]) mod 4),10)+
            ColorARRAY[CLRdate]+
             copy(freshline,24,10)+
            ColorARRAY[CLRdesc]+
             copy(freshline,34,(length(freshline)-33));
          descline := 1;
        end
      end;
    writeln(dest,freshline);
  until eof(source);             { loop back to read another line - PHEW! }
end;

{---- TYPEs, CONSTs and VARs for "main" program ----}
type
  link = ^node;
  node = record
           name : string[12];
           next : link;
         end;
const
  destfname = 'pcbcolor.d##';
  tempfname = 'pcbcolor.t##';
var
  dirinfo   : searchrec;  { contains filespec info.    }
  spath     : pathstr;    { source file path,          }
  sdir      : dirstr;     {             directory,     }
  sname     : namestr;    {             name,          }
  sext      : extstr;     {             extension.     }
  sfn,dfn,tfn : pathstr;  { Source/ Dest/ Temp FileName, including dir }
  infile, outfile : text; { files read from/ written to                }
  filedt    : longint;    { file date and time, to preserve original   }
  numdone   : word;       { numdone is number of files Colorized       }
{----
  The boolean var "done" and pointers (type of 'link') of "anchor" and
   "chain" are used to cope with a bothersome quirk of DOS (I think),
   which allows "findnext" to find files more than once (under certain
   circumstances).  This quirk seems to be due to the order of the file
   names in the FAT, which is altered when a file is written to disk and
   then renamed.
----}
  done      : boolean;
  anchor, chain : link;

{---- BEGIN the "main" program ----}
begin
{----
  Initialize some variables.
  The user must pass a filename (first parameter).
----}
  if paramcount<>1 then showhelp(0);
  InitColors;

  numdone := 0;
  new (anchor);
  anchor^.name := '';
  anchor^.next := nil;

{---- Get file specification ----}
  spath := paramstr(1);
  if spath[1] in ['/','-'] then showhelp(0);
  fsplit(fexpand(spath),sdir,sname,sext); if (sname = '')  then showhelp(6);
  findfirst(spath, archive, dirinfo);     if doserror <> 0 then showhelp(3);
  dfn := sdir+destfname;
  tfn := sdir+tempfname;

{---- Okay, let's go! ----}
  while doserror = 0 do
  begin
    done := false;                 { initialize for each "new" file found }
    chain:=anchor;             { check if file was processed file already }
    while ((chain^.next <> nil) and (NOT done)) do
        if (chain^.name = dirinfo.name) then done := true
                                       else chain := chain^.next;

{---- Only process if not processed before ----}
    if NOT done then begin
      inc(numdone);
      new(chain);
      chain^.name:=dirinfo.name;  { add current name to beginning of list }
      chain^.next:=anchor;
      anchor:=chain;

{---- Process the file! ----}
      sfn := sdir+dirinfo.name;
      write('Colorizing ',sfn);  { tell user this file is being processed }
      openfiles(infile,outfile,sfn,dfn);
      makenewfile(infile,outfile);
      writeln(', done!');        { tell user this file has been processed }
{----
  Swap file names, preserving the original date and time
   (need to "flush" file so new date/ time sticks)
----}
      getftime (infile, filedt);
       close (outfile);    iocheck(ioresult);
       reset (outfile);    iocheck(ioresult);
      setftime (outfile, filedt);
       close (infile);     iocheck(ioresult);
       close (outfile);    iocheck(ioresult);
      rename(infile,tfn);  iocheck(ioresult);
      rename(outfile,sfn); iocheck(ioresult);
      erase (infile);      iocheck(ioresult);
    end;
    findnext(dirinfo);
  end;                  { now loop back with name of next file to process }
  repeat  { dispose of pointers - not necessary at end, but good practice }
    chain:=anchor^.next;
    dispose (anchor);
    anchor:=chain;
  until (anchor = nil);
  writeln('PCBColored ',numdone,' file(s).');
end.
