@echo off
CLS
ECHO Ŀ 
ECHO  LOCAL ARCHIVE TESTING 
ECHO  
IF "%1"=="" GOTO ENDE
IF NOT EXIST %1 GOTO ENDE

rem *** DELETE OLD TEMPORARY FILES ********************************************

ECHO  Delete old temporary files
IF EXIST pfedpass.txt DEL pfedpass.txt >NUL
IF EXIST pfedfail.txt DEL pfedfail.txt >NUL
ECHO --- PROCEEDING %1 ---

rem *** CHECK FOR ARCHIVE *****************************************************

ECHO  Looking for the right extension
testfile %1 LZH ARJ ZIP
IF ERRORLEVEL 4 GOTO NOT_ARCHIVE
IF ERRORLEVEL 3 GOTO ZIP
IF ERRORLEVEL 2 GOTO ARJ
IF ERRORLEVEL 1 GOTO LZH
rem *** if arj and lha not accepted replace last 2 lines with GOTO INVALID

:NOT_ARCHIVE
ECHO  Extension not found - EXITING
GOTO ENDE

rem *** PROCEED ARCHIVE TESTING **********************************************

:ZIP
ECHO  ZIP archive detected
rem *** STRIP AUTHENTIC VERIFICATION ***
ECHO  Strip -AV
stripav -p %1 >NUL
ECHO  Test Archive for CRC errors
pkunzip -t %1 >NUL
if errorlevel 51 goto ARC_ERROR
if errorlevel 50 goto DISK_FULL
if errorlevel 11 goto NOFILES
if errorlevel 10 goto ILLEGAL
if errorlevel 9 goto NOFILES
if errorlevel 8 goto NOMEMORY
if errorlevel 3 goto ARC_ERROR
if errorlevel 2 goto ARC_ERROR
rem *** level 1 is for warnings, have to assume CRC warning ***
if errorlevel 1 goto CRC_ERROR
GOTO ENDE
 
:ARJ
ECHO  ARJ archive detected
ECHO  Testing Archive for CRC errors
arj t %1 >NUL
if errorlevel 9 goto INVALID
if errorlevel 8 goto NOMEMORY
if errorlevel 7 goto ILLEGAL
if errorlevel 6 goto ARC_ERROR
if errorlevel 5 goto DISK_FULL
if errorlevel 4 goto FAIL_SECURITY
if errorlevel 3 goto CRC_ERROR
if errorlevel 2 goto ARC_ERROR
if errorlevel 1 goto ARC_ERROR
GOTO ENDE

:LZH
ECHO  LHA archive detected
ECHO  Test Archive for CRC errors
lha t %1 >NUL
if errorlevel == 2 goto ARC_ERROR
if errorlevel == 1 goto CRC_ERROR
GOTO ENDE

rem *** ARCHIVE ERRORS *******************************************************

:CRC_ERROR
ECHO  CRC ERRORS IN ARCHIVE!
ECHO CRC ERRORS IN ARCHIVE >PFEDFAIL.TXT 
GOTO ENDE

:ARC_ERROR
ECHO  ERROR IN ARCHIVE!
ECHO ARCHIVE CONTAINS ERRORS >PFEDFAIL.TXT 
GOTO ENDE

:INVALID
ECHO  INVALID LHA OR ARJ FILE!
ECHO INVALID ARCHIVE (ARJ OR LHA) >PFEDFAIL.TXT
GOTO ENDE

rem *** NON-ARCHIVE ERRORS ***************************************************

:NOFILES
ECHO  WARNING - NO FILES FOUND IN ARCHIVE
GOTO ENDE

:NOMEMORY
ECHO  WARNING - INSUFFICIENT MEMORY
GOTO ENDE

:FAIL_SECURITY
ECHO  WARNING - ARCHIVE SECURITY ERROR
GOTO ENDE

:ILLEGAL
ECHO  WARNING - ILLEGAL PROGRAM FUNCTION
GOTO ENDE

:DISK_FULL
ECHO  WARNING - DISK FULL!!!
GOTO ENDE

rem *** END OF BATCH *********************************************************

:ENDE
IF EXIST pfedpass.txt DEL pfedpass.txt >NUL
ECHO  Executing BOOMLAB
