@echo off
REM * The above line turns off echoing of commands to display.

CLS
ECHO Multiple ring cadence batch file for Call Router v1.6
ECHO.
ECHO This batch file provides an example of how Call Router can be
ECHO used with the 'USERDATA' option to process 3 different distinct
ECHO ring cadences. EDITING WILL BE REQUIRED FOR YOUR USE.
ECHO.
ECHO In this example assume you have a regular number with two
ECHO distinctive ring numbers added and you have ran CRSAMPLE...
ECHO.
ECHO   Your normal voice number is 555-1111.
ECHO   Created CR16_1.DAT with CRSAMPLE program. NO answer. 99 rings.
ECHO.
ECHO   Distinctive ring 1 is 555-2222, starts a Wildcat BBS.
ECHO   Created CR16_2.DAT with CRSAMPLE program. Answer. 1 ring.
ECHO.
ECHO   Distinctive ring 2 is 555-3333, starts some other application.
ECHO   Created CR16_3.DAT with CRSAMPLE program. Answer. 1 ring.
ECHO.
ECHO This file may be copied and edited as long as it distributed in
ECHO its original form.
ECHO.
ECHO Consult documentation for more details.
ECHO.
ECHO.
PAUSE

:START
REM * The START label

REM * Start Call Router using COM1
REM * 'USERDATA' instructs Call Router to use the data files
REM * created by the CRSAMPLE program.
CALLROUT 1 USERDATA

REM * 555-3333 detected!
REM * Errorlevels 36 through 30 are returned when the ring data for an
REM * incoming call matched that in data file #3, and you answered yes
REM * to answer. The errorlevel corresponds to the baud rate detected
REM * once a data connection has been established. NN stands for
REM * 'noname'. Replace
REM * with any application that will take control of a connected modem.
if errorlevel 36 goto NN14400
if errorlevel 35 goto NN12000
if errorlevel 34 goto NN9600
if errorlevel 33 goto NN4800
if errorlevel 32 goto NN2400
if errorlevel 31 goto NN1200
if errorlevel 30 goto NN300

REM * 555-2222 detected!
REM * Like above, the errorlevels correspond to the detected baud rate
REM * but the ring data matched that in file #2. In this case a call
REM * to start a Wildcat! BBS is used for example.
if errorlevel 26 goto WC14400
if errorlevel 25 goto WC12000
if errorlevel 24 goto WC9600
if errorlevel 23 goto WC4800
if errorlevel 22 goto WC2400
if errorlevel 21 goto WC1200
if errorlevel 20 goto WC300

REM *  555-3333 and/or 555-2222 could be detected here if not
REM *  instructed to answer in data files.
REM *  Testing for errorlevels 5 and 4 would be inserted here.

REM * 555-1111 detected!
REM * The next line tests to see if the ring data matched data file #1.
REM * Since data file #1 defines our voice number we would restart.
REM * We set the program to exit only at this errorlevel when the voice
REM * reaches 99 rings. It is unlikely this will happen but will force
REM * a timeout condition (errorlevel 2) to occur when the caller hangs
REM * up or you answer the call.
REM * If you had setup ring definition #1 to answer an incoming call,
REM * errorlevels 10-16 would have been test above.
if errorlevel 3 goto START

REM * The next line tests for a timeout.
REM * This occurs when:
REM * 1. Rings counted were then rings expected for a particular number.
REM * 2. When the answer command was sent, no carrier was detected
REM *    within 30 seconds.
REM * 3. An unexpected or no modem response condition occurs.
if errorlevel 2 goto START

REM * The next line tests for a fatal error.
if errorlevel 1 goto FATAL

REM * Errorlevel 0 is set when the ESC is pressed and indicates a
REM * normal error free program termination.
if errorlevel 0 goto END

REM * The following are routines that are called from above...
REM * For the 'noname' program it is assumed that the program sets
REM * errorlevel if it had a problem.
:NN14400
 CALL NONAME /B 14400
 if errorlevel 1 goto END
 goto START
:NN12000
 CALL NONAME /B 12200
 if errorlevel 1 goto END
 goto START
:NN9600
 CALL NONAME /B 9600
 if errorlevel 10 goto END
 goto START
:NN4800
 CALL NONAME /B 4800
 if errorlevel 10 goto END
 goto START
:NN2400
 CALL NONAME /B 2400
 if errorlevel 10 goto END
 goto START
:NN1200
 CALL NONAME /B 1200
 if errorlevel 10 goto END
 goto START
:NN300
 CALL NONAME /B 300
 if errorlevel 10 goto END
 goto START

REM * Wildcat! startup routines.
REM * Wildcat exits errorlevel 60 when a caller hangs up...
:BBS14400
 CALL WILDCAT /B 14400
 if errorlevel 60 goto START
 goto END
:BBS12000
 CALL WILDCAT /B 12200
 if errorlevel 60 goto START
 goto END
:BBS9600
 CALL WILDCAT /B 9600
 if errorlevel 60 goto START
 goto END
:BBS4800
 CALL WILDCAT /B 4800
 if errorlevel 60 goto START
 goto END
:BBS2400
 CALL WILDCAT /B 2400
 if errorlevel 60 goto START
 goto END
:BBS1200
 CALL WILDCAT /B 1200
 if errorlevel 60 goto START
 goto END
:BBS300
 CALL WILDCAT /B 300
 if errorlevel 60 goto START
 goto END

:FATAL
 @echo.
 @echo Call Router ended with a fatal error.
 @echo.
 goto END

:END
REM * Turn echo to display on before exiting.
@ECHO ON
