DEFINT A-Z
DECLARE SUB CalcRegNum (UName$, Serial$, RegNum$, NoReg%)
DECLARE SUB GetRegInfo (UName$, Serial$, RegNum$, TrapSpec$)
DECLARE SUB PutRegNo (TrapSpec$)

' CalcRegNum      NoReg%    This routine is used to calculate and validate
'                           the registration information.  If it calculates
'                           correctly, the NoReg% variable is returned as
'                           FALSE (0), otherwise it's return as TRUE (-1).
'                           This routine expects 3 variables and returns 1.
'                   
'                           UName$   - This string will hold the registered
'                           name as indicated on the registration letter
'                           sent to each user.
'                   
'                           Serial$  - This string is the trimmed version
'                           of the 8 digit serial number, which contains
'                           leading zeros.
'                   
'                           RegNum$  - This is the calculated registration
'                           number.  It is compared against the one from
'                           the registration letter which is generated by
'                           the DIZREG.BAS program.
'                   
'                           NoReg%   - This integer variable has two
'                           purposes.  But, in this routine it is returned
'                           if the calculation is sucessful as 0 or -1 if
'                           it fails.
'                         
'
' GetRegInfo      UName$    This routine will check the executable for the
'                 Serial$   registration info.  It takes one variable, but
'                 RegNum$   returns 3.
'                   
'                           UName$   - This string holds the user name
'                           shown on the registration letter.
'                   
'                           Serial$  - This is the 8 digit trimmed serial
'                           number shown on the registration letter.
'                   
'                           RegNum$  - This is the 8 digit trimmed
'                           registration number found on the registration
'                           letter.
'
'                           TrapSpec$- This is the location of EXE file
'                           which is storing all the Information.
'
' PutRegNo        NONE      This routine will place the registration info
'                           at the end of the executable file.  It takes
'                           one parameters, but doens't return any.
'
'                           TrapSpec$- This is the location of EXE file
'                           which is storing all the Information.

TYPE RegistrationInfo
     UserName AS STRING * 32
     SerNum AS STRING * 8
     RegCode AS STRING * 8
END TYPE

DIM SHARED RegInf AS RegistrationInfo

