// Common POV shapes as a sample set
//  - the user can make up his own customized set
//  the names of some of the shapes are patterned after the original
//  names found in the POV standard distribution package for compatibility.

#declare QQQ_temp = version

#version 2.0

#declare Ellipsoid=sphere{<0, 0, 0>,1}

#declare Ellipsoid_1=intersection{  // Half
  sphere {<0, 0, 0>,1}
  plane {-z,0}
  }

#declare Ellipsoid_2=intersection{  // Quarter
  sphere {<0, 0, 0>,1}
  plane {z,0}
  plane {x,0}
  }

#declare Ellipsoid_3=intersection{  // 1/8th
  sphere {<0, 0, 0>,1}
  plane {z,0}
  plane {x,0}
  plane {y,0}
  }

#declare Cube=intersection{
  plane {x,1} plane {-x,1}
  plane {y,1} plane {-y,1}
  plane {z,1} plane {-z,1}
  }

#declare Light=object{
  light_source {<0.0, 0.0, 0.0>
    color red 1 green 1 blue 1}
  }

#declare DimLight=object{
  light_source {<0.0, 0.0, 0.0>
    color red .4 green .4 blue .4}
  }

#declare Sun=object{
  light_source {<0.0, 0.0, 0.0>
    color red 1 green 0.6 blue 0.2
    looks_like {sphere{<0,0,0>,1
      texture{pigment{color red 1 green 0.6 blue 0.2}
        finish{ambient 1  diffuse 0}}}}
    }
  }

#declare Disk_X=cylinder{ x,-x,1}

#declare Disk_Y=cylinder{ y,-y,1}

#declare Disk_Z=cylinder{ z,-z,1}

#declare Cone_X=cone{x,0,-x,1}

#declare Cone_Y=cone{y,0,-y,1}

#declare Cone_Z=cone{z,0,-z,1}

#declare Ibeam=difference{
  object {Cube}
  intersection{
    plane {-x,-0.1}
    plane {z,0.9}
    plane {-z,0.9}
  }
  intersection{
    plane {x,-0.1}
    plane {z,0.9}
    plane {-z,0.9}
  }
  }

#declare Hbeam=difference{
  object {Cube}
  intersection{
    plane {-z,-0.1}
    plane {x,0.9}
    plane {-x,0.9}
  }
  intersection{
    plane {z,-0.1}
    plane {x,0.9}
    plane {-x,0.9}
  }
  }

#declare Wedge=intersection{
  object {Cube}
  plane {-z,0 rotate<0,45,0>}
  }

#declare Elbow05=intersection{
  object {Cube scale <.55,.55,.06> translate<.475,.525,0>}
  torus {1,0.05 sturm rotate <90,0,0> translate <1,0,0>}
  bounded_by{Cube scale<.55,.55,.06> translate<.475,.525,0>}
  }

#declare Elbow1=intersection{
  object {Cube scale <.6,.6,.11> translate<.45,.55,0>}
  torus {1,0.1 sturm rotate <90,0,0> translate <1,0,0>}
  bounded_by{Cube scale<.6,.6,.11> translate<.45,.55,0>}
  }

#version QQQ_temp
