/*********************************************************************/
/*                                                                   */
/*    Name:    DISKDRIV.H                                            */
/*                                                                   */
/*    Copyright (c) Stewart A. Berman 1992,3,4 All rights reserved   */
/*                                                                   */
/*********************************************************************/
#ifndef __DISKDRIV_H__
#define __DISKDRIV_H__

#include <IO.h>

#include "Director.H"

#define AUTOMATIC  1
#define ALWAYS     2
#define NEVER      3
#define FAST       4

#define IMAGETOFILE  1
#define IMAGETOIMAGE 2
#define FILETOIMAGE  3
#define FILETOFILE   4

#ifndef FORMATFAST

#define FORMATFAST           0x0010
#define FORMATQUICK          0x0020

struct DIRECTORYENTRY
       {
       BYTE  bName[8] ;
       BYTE  bExtension[3] ;
       BYTE  bAttributes ;
             #define ATTR_READONLY  0x01
             #define ATTR_HIDDEN    0x02
             #define ATTR_SYSTEM    0x04
             #define ATTR_VOLUME    0x08
             #define ATTR_DIRECTORY 0x10
             #define ATTR_ARCHIVE   0x20
             #define ATTR_NOTFILE   ( ATTR_VOLUME   | ATTR_DIRECTORY )
             #define ATTR_SPECIAL   ( ATTR_HIDDEN   | ATTR_SYSTEM    )
             #define ATTR_STATUS    ( ATTR_READONLY | ATTR_ARCHIVE   )
       BYTE  bReserved[10] ;
       UINT  nTime ;
       UINT  nDate ;
       UINT  wStartCluster ;
       DWORD dwFileSize ;
       } ;

struct DIRECTORYSECTOR
       {   
       struct DIRECTORYENTRY Entry[16] ;
       } ;

#pragma pack(2)
typedef struct tagSDU_find_t {
    char driveletter ;
    char filemask[11] ;
    char attributes ;
    WORD entry ;
    WORD cluster ;
    char reserved[4] ;
    char attrib;
    unsigned wr_time;
    unsigned wr_date;
    long size;
    char name[13];
    DIRECTORYENTRY directoryentry ;
    } SDU_find_t ;
#pragma pack()
typedef SDU_find_t*       PSDU_find_t ;
typedef SDU_find_t NEAR* NPSDU_find_t ;
typedef SDU_find_t FAR*  LPSDU_find_t ;

#endif
#ifdef __cplusplus
extern "C" {
#endif /* _cplusplus */

VOID far * FAR PASCAL DiskDriveCreateDrive  ( char cDrive, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateFile   ( LPCSTR lpczFileName, LPCSTR lpczApplicationTitle, LPCSTR lpczVersion, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateMemory ( UINT nMemory, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateVDrive ( VOID far *pCVDriveNew, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID       FAR PASCAL DiskDriveDelete ( VOID far *pCDiskDrive ) ;

VOID       FAR PASCAL DiskDriveCopy ( VOID far *pCDiskDrive, VOID far *pCDiskDriveSource ) ;
BOOL       FAR PASCAL DiskDriveCompare ( VOID far *pCDiskDrive, VOID far *pCDiskDriveSource ) ;

BOOL       FAR PASCAL DiskDriveConvert ( VOID far *pCDiskDrive, VOID far *pCDiskDriveSource ) ;
BOOL       FAR PASCAL DiskDriveCopyFile ( VOID far *pCDiskDrive, LPCSTR lpczFileNameIn, LPCSTR lpczFileNameOut, UINT Flags ) ;
BOOL       FAR PASCAL DiskDriveDeleteFile ( VOID far *pCDiskDrive, LPCSTR lpczFileName ) ;
BOOL       FAR PASCAL DiskDriveSDU_FindFirst ( VOID far *pCDiskImage, LPCSTR lpczFileMask, UINT Flags, LPSDU_find_t lpstFind_T) ;
BOOL       FAR PASCAL DiskDriveSDU_FindNext  ( VOID far *pCDiskImage, LPSDU_find_t lpstFind_T) ;
LPCSTR     FAR PASCAL DiskDriveGetCurrentDirectory ( VOID far *pCDiskDrive, LPSTR lpczOldCurrentDirectory ) ;
BOOL       FAR PASCAL DiskDriveChangeCurrentDirectory ( VOID far *pCDiskDrive, LPCSTR lpczNewCurrentDirectory ) ;

UINT       FAR PASCAL DiskDriveForceReset           ( VOID far *pCDiskDrive ) ;
BOOL       FAR PASCAL DiskDriveHasData              ( VOID far *pCDiskDrive ) ;
BOOL       FAR PASCAL DiskDriveIsTruncated          ( VOID far *pCDiskDrive ) ;
char       FAR PASCAL DiskDriveLetter               ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveReset                ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveRootDirectoryEntries ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveSetRead              ( VOID far *pCDiskDrive, UINT nTempType, UINT nCylinders ) ;
VOID       FAR PASCAL DiskDriveSetType              ( VOID far *pCDiskDrive, UINT nNewType ) ;
UINT       FAR PASCAL DiskDriveSetWrite             ( VOID far *pCDiskDrive, UINT nTempType, UINT nCylinders ) ;
UINT       FAR PASCAL DiskDriveSectorsPerCluster    ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveSectorsPerFAT        ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveType                 ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedCylinders        ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedHeads            ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedSectors          ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedSectorSize       ( VOID far *pCDiskDrive ) ;

UINT       FAR PASCAL DiskDriveFormat        ( VOID far *pCDiskDrive, LPCSTR lpczVolumeLabel, UINT nFormatOption, LPBYTE lpbyBootSector, lpfnHANDLESTATUS lpfnHandleStatus ) ;
UINT       FAR PASCAL DiskDriveFormatTrack   ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
UINT       FAR PASCAL DiskDriveReadSectors   ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
UINT       FAR PASCAL DiskDriveWriteSectors  ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
UINT       FAR PASCAL DiskDriveReadClusters  ( VOID far *pCDiskDrive, UINT nCluster, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
UINT       FAR PASCAL DiskDriveWriteClusters ( VOID far *pCDiskDrive, UINT nCluster, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;

BOOL       FAR PASCAL DiskDriveGetRootDirectory       ( VOID far *PCDiskDrive, LPBYTE lpbyDirectoryBuffer ) ;
BOOL       FAR PASCAL DiskDriveGetFileAllocationTable ( VOID far *PCDiskDrive, UINT nFAT ) ;
BOOL       FAR PASCAL DiskDrivePutRootDirectory       ( VOID far *PCDiskDrive, LPBYTE lpbyDirectoryBuffer ) ;
BOOL       FAR PASCAL DiskDrivePutFileAllocationTable ( VOID far *PCDiskDrive, UINT nFAT ) ;
UINT       FAR PASCAL DiskDriveGetAllocatedSectors    ( VOID far *pCDIskDrive ) ;
LPCSTR     FAR PASCAL DiskDriveGetVolumeDate          ( VOID far *pCDiskDrive, LPSTR  lpczOldVolumeDate  ) ;
LPCSTR     FAR PASCAL DiskDriveGetVolumeLabel         ( VOID far *pCDiskDrive, LPSTR  lpczOldVolumeLabel ) ;
BOOL       FAR PASCAL DiskDriveSetVolumeLabel         ( VOID far *pCDiskDrive, LPCSTR lpczNewVolumeLabel ) ;

VOID       FAR PASCAL DiskDriveSetWriteFormatOption ( VOID far *pCDiskDrive, UINT nWriteFormatOptionNew ) ;
VOID       FAR PASCAL DiskDriveSetWriteVerifyOption ( VOID far *pCDiskDrive, BOOL bWriteVerifyOptionNew ) ;

VOID       FAR PASCAL DiskDriveTruncate        ( VOID far *pCDiskDrive ) ;
VOID       FAR PASCAL DiskDriveTruncateReverse ( VOID far *pCDiskDrive ) ;

BOOL       FAR PASCAL DiskDriveWriteBootSector ( VOID far *pCDiskDrive, LPBYTE lpbyModelBootSector, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;

#ifdef __cplusplus
           }
#endif /* __cplusplus */

#endif /* __DISKDRIV_H__ */


