#ifndef _DIRECTOR_H_
#define _DIRECTOR_H_

#define FORMATFAST           0x0010
#define FORMATQUICK          0x0020

typedef struct DIRECTORYENTRY
       {
       BYTE  bName[8] ;
       BYTE  bExtension[3] ;
       BYTE  bAttributes ;
             #define ATTR_READONLY  0x01
             #define ATTR_HIDDEN    0x02
             #define ATTR_SYSTEM    0x04
             #define ATTR_VOLUME    0x08
             #define ATTR_DIRECTORY 0x10
             #define ATTR_ARCHIVE   0x20
             #define ATTR_NOTFILE   ( ATTR_VOLUME   | ATTR_DIRECTORY )
             #define ATTR_SPECIAL   ( ATTR_HIDDEN   | ATTR_SYSTEM    )
             #define ATTR_STATUS    ( ATTR_READONLY | ATTR_ARCHIVE   )
       BYTE  bReserved[10] ;
       UINT  nTime ;
       UINT  nDate ;
       UINT  wStartCluster ;
       DWORD dwFileSize ;
       } DIRECTORYENTRY ;

typedef struct DIRECTORYSECTOR
       {   
       struct DIRECTORYENTRY Entry[16] ;
       } DIRECTORYSECTOR ;

#pragma pack(2)
typedef struct tagSDU_find_t {
    char driveletter ;
    char filemask[11] ;
    char attributes ;
    WORD entry ;
    WORD cluster ;
    char reserved[4] ;
    char attrib;
    unsigned wr_time;
    unsigned wr_date;
    long size;
    char name[13];
    DIRECTORYENTRY directoryentry ;
    } SDU_find_t ;
#pragma pack()
typedef SDU_find_t*       PSDU_find_t ;
typedef SDU_find_t NEAR* NPSDU_find_t ;
typedef SDU_find_t FAR*  LPSDU_find_t ;

#endif /* _DIRECTORY_H_ */
