REM This program is a modification of MAPCNVRT.BAS to take several smaller
REM maps and extract only the Interstates and major four lane roads and place
REM them in a larger area map.

REM You must choose the colors to accept in the line about 5 pages down...
REM Build the IF statement to set GUD=-1 for each color to keep

REM To save redundant typing of the source information, use an editor to
REM prepare a source file in the following format:

REM *This file tells MAKEBIG.BAS how to combine the following maps into one
REM *large area map.  Any number of comment lines are permitted...
REM *BEGIN*
REM 40.5, Latitude of resultant large map Origin
REM 98.5, Longitude of resultant Origin
REM 300, Desired final Pixels-Per-Degree
REM \APRS500\MAPS, This is the path for QBasic to use to find the following maps
REM OH-MI-WV
REM OHIO
REM INapolis
REM PAPtsbrg
REM *END*

OPTION BASE 0
REM $DYNAMIC
DIM Labels$(350)

CLS
PRINT "This program will convert all the maps listed in a MakeBig.dat file"
PRINT "into a single larger map by extracting only the Interstates and major"
PRINT "state or national highways (green and bright red roads)."
PRINT
PRINT "The output of this program will be in MAPTEMP.map"
PRINT
Start: INPUT "Enter File name of source map if other than MakeBig.dat"; F$
       IF F$ = "" THEN F$ = "MakeBig.dat"
       IF INSTR(F$, ".") = 0 THEN F$ = F$ + ".dat"
       OPEN F$ FOR INPUT AS #1

       INPUT "Enter file name for output if other than MAPTEMP.MAP"; FO$
       IF FO$ = "" THEN FO$ = "MAPTEMP.MAP"
       OPEN FO$ FOR OUTPUT AS #4


        DO UNTIL A$ = "*BEGIN*": LINE INPUT #1, A$: LOOP

        INPUT #1, NLat: LINE INPUT #1, A$
        INPUT #1, NLon: LINE INPUT #1, A$
        INPUT #1, PPDD: LINE INPUT #1, A$
                  LATcen = NLat - (500 / PPDD)
                  LONcen = NLon - (500 / PPDD)
                  MapRng = 60 * 500 / PPDD
        INPUT #1, PATH$: LINE INPUT #1, A$

REM PREPARE OUTPUT FILE STUFF

     PRINT #4, NLat; ", Latitude of Origin"
     PRINT #4, NLon; ", Longitude of Origin"
     PRINT #4, PPDD; ", Pixels-Per-Degree"
     PRINT #4, LATcen; ", Lat of map center"
     PRINT #4, LONcen; ", Lon of map center"
     PRINT #4, MapRng; ", map range"
     PRINT #4, "0 , Field not used"
     PRINT #4, "This is a comment line: THIS MAP GENERATED BY MAKEBIG.bas"
    
     ON ERROR GOTO Errorfix

REM NOW BEGIN PROCESSING EACH MAP

  DO
     INPUT #1, A$: IF A$ = "*END*" THEN EXIT DO
     MAPname$ = PATH$ + A$ + ".map"
     OPEN MAPname$ FOR INPUT AS #3

     INPUT #3, LATa: LINE INPUT #3, A$
     INPUT #3, LONa: LINE INPUT #3, A$
     INPUT #3, ppdV: LINE INPUT #3, A$
     INPUT #3, LATx: LINE INPUT #3, A$
     INPUT #3, LONx: LINE INPUT #3, A$
     INPUT #3, RngX: LINE INPUT #3, A$
     INPUT #3, x: LINE INPUT #3, A$
     LINE INPUT #3, A$: REM ignore line of instructions
    
     i = 0
     REM now make offset and scale calculations
     Sfac = PPDD / ppdV
     LOfset = LONa - NLon
     LAfset = LATa - NLat

     PRINT "Doing "; MAPname$; "... ";
     GUD = -1
     DO WHILE NOT EOF(3)
        i = i + 1: INPUT #3, x%, y%
        IF x% <> 0 THEN
           x% = Sfac * (x% - ppdV * LOfset)
           y% = Sfac * (y% - ppdV * LAfset)
           IF x% = 0 THEN x% = 1: PRINT "ZERO value of X!  Converted to 1,"; y%
           IF GUD THEN WRITE #4, x%, y%
        END IF

        
        IF x% = 0 AND NOT EOF(3) THEN ' Get line color & store with x=0
           INPUT #3, z%: LINE INPUT #3, A$ ' Echo line name
REM In the following line, choose the LINE colors to accept
           REM IF z% <> 10 AND z% <> 6 THEN GUD = 0 ELSE GUD = -1
           IF z% = 6 OR z% = 10 OR z% = 11 OR z% = 12 THEN GUD = -1 ELSE GUD = 0
           IF y% = -1 THEN EXIT DO' All labels listed at end of file
           IF GUD THEN WRITE #4, x%, y%: PRINT #4, z%; ","; A$
        END IF
        
     LOOP
     PRINT "Now doing labels... ";
     DO WHILE NOT EOF(3)
        INPUT #3, Lbl$, A, O, R
        IF R > MapRng / 8 THEN
           NL = NL + 1
           Labels$(NL) = Lbl$ + "," + STR$(A) + "," + STR$(O) + "," + STR$(R)
        END IF
        
     LOOP: CLOSE #3: PRINT "Done!"
  LOOP
  PRINT #4, " 0,-1"
  FOR i = 1 TO NL: PRINT #4, Labels$(i): NEXT i
  CLOSE #4
  CLOSE #1
       
  PRINT : PRINT "CONVERSION SUCCESSFUL TO YOUR NEW MAP FILE NAMED "; FO$
  INPUT "Hit return to continue.."; A$: STOP

Errorfix: PRINT ERR
          IF ERR = 62 THEN PRINT "inpt past end..."; : RESUME NEXT
          IF ERR = 52 THEN RESUME NEXT
          PRINT "ERROR NOT TRAPPED!"

END

