PRINT "This program takes a RAW PROCOMM download file from a GPS receiver"
PRINT "in NMEA-0183 format and formats it to look like an APRS packet beacon"
PRINT "It looks for the GGA and VTG sentences."
REM    For LORAN or other sentences GLL or RMC, you will have to rewrite
REM    Several lines below...
PRINT
INPUT "Enter file name of raw GPS data"; FI$
INPUT "Enter name of OUTPUT file for APRS packet beacons"; FO$
INPUT "Enter callsign to be used with that data"; CALL$
INPUT "Enter two digit DAY of data"; Day
INPUT "Enter symbol for character (Car >, Air ', Boat ~)"; Sym$
IF LEN(Sym$) <> 1 THEN Sym$ = ">"
LET CALL$ = LEFT$(CALL$ + "         ", 10)
OPEN FI$ FOR INPUT AS #1
OPEN FO$ FOR OUTPUT AS #2
DTG$ = MID$(DATE$, 4, 2) + LEFT$(TIME$, 2) + MID$(TIME$, 4, 2)
DO WHILE NOT EOF(1)
LINE INPUT #1, a$
IF LEFT$(a$, 6) = "$GPGGA" AND MID$(a$, 36, 1) = "1" THEN
   lat$ = MID$(a$, 15, 7)
   lon$ = MID$(a$, 25, 8)
   EST = VAL(MID$(a$, 8, 4)) - 500
   IF EST < 0 THEN Tim = EST + 2400: Standby = 1 ELSE Tim = EST
   IF EST > 0 AND Standby = 1 THEN Standby = 0: Day = Day + 1
   UTC$ = RIGHT$("0" + MID$(STR$(Day), 2), 2) + RIGHT$("000" + MID$(STR$(Tim), 2), 4)
   Pos$ = "/" + lat$ + "N/" + lon$ + "W"
   END IF
IF LEFT$(a$, 6) = "$GPVTG" THEN
   CSE$ = Sym$ + MID$(a$, 8, 3)
   SPD$ = "/" + MID$(a$, 26, 3)
   END IF
Pkt$ = CALL$ + UTC$ + " @" + UTC$ + Pos$ + CSE$ + SPD$ + "/comments"
PRINT #2, Pkt$
LOOP
CLOSE
END

