// Original Author:  Mitch Allen
// Program:  uf_glove.cpp

// Extended by Mark Pflaging 5/29/92 thru 9/21/92

#include <dos.h>
#include <bios.h>
#include <stdlib.h>

#include "smooth.hpp"
#include "glgrph.hpp"
#include "ini.hpp"
#include <conio.h>
#include <iostream.h>

// added by Mick Imfeld for midi functions
#include "stdio.h"
#include "ctype.h"
#include "\ptk\asm\mcc.h"
// #include "\vr\glove\mq\cpp\tkxmpl.h"
int irq; //interface's Irq level for midi
// int oldx; for future use
// int oldy;
// int oldz;
int oldnote;
int oldmidfinger;
int start_note;
int num_of_notes;
int numdiv;
int pitchbend_on;
int main()
{

	cout << "Edit GLOVE.INI to change startup parameters if "
		"you experience trouble." << endl;
	cout << "HELPME!.DOC contains important troubleshooting "
		"information!" << endl;
	cout << "Reading GLOVE.INI..." << endl;
	InitFile * gloveIni = new InitFile("glove.ini");
	cout << "Determining timing values for this machine..." << endl;


//	cfGlove & GLOVE = *(new smooth(*gloveIni));
	smooth & GLOVE = *(new smooth(*gloveIni));
	cout << endl << "Report of timing values:" << endl;
	GLOVE.test();
	cout << endl << endl
		<< "GLOVE.INI also contains some aesthetic "
"parameters, so READ IT!."<<endl
<< "     Midi interface must be at 330h, read midiglov.doc" << endl;
	cout << "        Enter number of notes to spread on x axis: ";
	cin >> num_of_notes;
	numdiv=256/num_of_notes;
	cout << endl;
	cout << "        Enter bottom starting note (60 = middle C): " ;
	cin >> start_note;
	cout << endl;
	cout << "        Turn pitch bend on? (0=off, 1=on): ";
	cin >> pitchbend_on;
	cout << endl;
	cout << "            Press any keyboard key to begin." << endl
		<< "Press the '1' key on the Glove during "
		"the demo to display help." << endl;

	getch();

//midi interface initialization functions, added by Mick Imfeld
//  oldx=1;   for future use
//  oldy=1;
//  oldz=1;
  oldnote=60; //these are initialized for use in glgrph
  oldmidfinger=0;

  irq=mcc_irq(0x330);                   /* find IRQ for use */
  if (irq == 0)
    {
      puts("\n\nMIDI interface not installed\n\n");
      abort();
    }
  if (!mcc_open(0x330,irq))             /* open interface for use */
    {
      puts("\n\nMIDI interface not installed\n\n");
      abort();
    }
   set_slih(&mcc_noslih);                /* establish SLIH */
  mcc_command(DISABLE_THRU);
  mcc_command(UART_MODE);               /* put MCC into pass-thru mode */

// back to o2glove

	graphicsActor &gloveGraph = *(new graphicsActor(*gloveIni));
	gloveIni->write();
	delete gloveIni;

	cleardevice();
	GLOVE.run(gloveGraph);

	getch();                       // exit when kbhit()

//midi interface close functions added by Mick Imfeld
//send midi all notes off, this only works on some synths
mcc_put(0xB0); // midi all notes off
  mcc_put(0x7B);
  mcc_put(0);
  mcc_command(RESET_MCC);               /* return to coproc mode */
  mcc_close();                          /* close MCC (interface) */

// back to o2glove
	delete &GLOVE;
	delete &gloveGraph;
	cout << "Thank You for trying Mark's Power Glove demo V2.0." << endl
		<< "Please read the source and GLOVE.INI "
		"for more information." << endl
		<< "Brought to you by Area 13 (Virtual Reality) of" << endl
		<< "GO COMART on Compuserve.  Copyright 1992, "
		"Mark Thomas Pflaging" << endl;
	return 0;
}
