\ Multitasking Demonstration
\ This program is Copyright (C) 1987 by Thomas Almy.  All rights reserved.
NOMAP 
2000 SEPSSEG
10000 100 MSDOSEXE
INCLUDE FACIL1
INCLUDE MULTID
DECIMAL
\ display string task
\ The format of a a display string message is:
\  2 bytes: message handler (reserved)
\  1 byte: message length
\  n bytes: message body

2 CONSTANT >MLEN	\ Offsets to length and body of messages
3 CONSTANT >MBODY

: DSPR 5 FOREGROUND
     0
     BEGIN 
           GET-MESSAGE >R        \ if there is a message, then display it
	   40 4 AT-XY 40 SPACES  \ erase the old message
           40 4 AT-XY
           R@  >MLEN ?DS: PAD R@ >MLEN C@L CHAR+ CMOVEL
           PAD COUNT TYPE
           R> FREE
           1+
    AGAIN
;

\ counter task -- increment count on screen
: CNTR  3 FOREGROUND
      0   BEGIN 40 0 AT-XY  DUP 6 .R 1+ AGAIN ;

\ time and date task -- display current time and date every second
1 0 IN/OUT
: 2d.  0 <# # # #> TYPE ;

: TIMR  6 FOREGROUND
      BEGIN  TIME&DATE 40 2 AT-XY 
             SWAP 2d. [CHAR] / EMIT
             SWAP 2d. [CHAR] / EMIT
             2d. 2 SPACES
             2d. [CHAR] : EMIT
             2d. [CHAR] : EMIT
             2d. 
             1000 MS	\ delay
      AGAIN
;

' CNTR TASK COUNTUP
' TIMR TASK CLOCK
' DSPR TASK DISPLAYER

0 VALUE STRLEN
: MAIN 
  INIT-TASKS		\  REQUIRED!

  PAGE 0 6 AT-XY

  COUNTUP WAKE		\ wake up other tasks
  CLOCK WAKE
  DISPLAYER WAKE

  BEGIN
     PAD 40 ACCEPT TO STRLEN CR  \ read a line and pass it as a message
     STRLEN WHILE \ quit on empty line
     STRLEN 18 + 4 RSHIFT GET >R \ space for message
     STRLEN R@ >MLEN C!L         \ message length (2 bytes from start)
     ?DS: PAD R@ >MBODY STRLEN CMOVEL \ message content (3 bytes from start)
     R> DISPLAYER SEND-MESSAGE
  REPEAT
  BYE			\ REQUIRED! Must exit via BYE
;

INCLUDE FARMEM2
INCLUDE FACIL2
INCLUDE FORTHLIB

END
