/*
 * File......: CHECKTABS.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_CHECKTABLES()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Check that the given tables exist
 *  $SYNTAX$
 *      GT_CheckTables( aTables )
 *  $ARGUMENTS$
 *      aTables - Array of tables and indexes
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Checks that each of the given tables and indexes exists in the
 *      cDefaultPath\TABLES directory.
 *
 *      Structure of aTables is { Element 1 , Element 2 , ... }
 *
 *      where each element is { Table name , Index 1 , Index 2 , ... }
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_CheckTables( aTables )
MEMVAR cDefaultPath
/*****************************************************************************
 Purpose - Check that the given tables and indexes exist
 Returns - None
 Author  - Martin Colloby
 Created - 16/4/92
******************************************************************************
 Parameters - aTables - Multidimensional array of tables and indexes
 Privates   - none
 Locals     - nCount  - Count of tables
              nCount1 - Count of indexes for table
 Externals  - None
******************************************************************************
 Structure of aTables is { Element 1 , Element 2 , ... }

 where each element is { Table name , Index 1 , Index 2 , ... }

 Each table and index should be identified from the directory cDefaultPath
*****************************************************************************/

LOCAL nCount     := 0
LOCAL nCount1    := 0

FOR nCount := 1 TO LEN( aTables )

    IF !FILE( cDefaultPath + "\Tables\" + aTables[nCount,1] + ".dbf" )
        GT_Warning( { "Cannot find table " + cDefaultPath + "\Tables\" + aTables[nCount,1] + ".dbf" } )
        RETURN NIL
    ENDIF

    FOR nCount1 := 2 TO LEN( aTables[nCount] )
        IF LEN( aTables[ nCount , nCount1 ] ) > 0
            IF !FILE( cDefaultPath + "\Tables\" + aTables[nCount,nCount1] + INDEXEXT() )
                GT_Warning( { "Cannot find index " + cDefaultPath + "\Tables\" + aTables[nCount,nCount1] + INDEXEXT() } )
                RETURN NIL
            ENDIF
        ENDIF
    NEXT nCount1
NEXT nCount

RETURN NIL
*
