/*
 * File......: DOSFILE.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ISFILENAME()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Check to see if a filename is valid
 *  $SYNTAX$
 *      GT_IsFileName( cFile )
 *  $ARGUMENTS$
 *      cFile - File name
 *  $RETURNS$
 *      .T. if cFile is a valid DOS file name
 *      .F. otherwise
 *  $DESCRIPTION$
 *      Checks to see that the given string passes the tests for validity
 *      as a DOS file.  Does not allow drive path or extension to be passed.
 *  $EXAMPLES$
 *      Check that a file name is valid :
 *
 *          lCheck := GT_IsFileName( ".txt" )
 *
 *      returns .F.
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*
FUNCTION GT_IsFileName( cFile )

/*****************************************************************************
 Purpose - Check that cFile is a valid DOS filename ( no extension ! )
 Returns - .T. if cFile is valid
 Author  - Log
 Created - 06/11/92
******************************************************************************
 Parameters - cFile - Filename to test
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL lCount   := 0
LOCAL lInValid := "/[]|<>+=;*.\? "  // :,
LOCAL nCount   := 0

cFile := ALLTRIM( cFile )

IF LEN( cFile ) > 8 .OR. LEN( cFile ) = 0
    RETURN( .F. )
ENDIF

FOR nCount := 1 TO LEN( lInValid )
    IF AT( SUBSTR( lInValid , nCount , 1 ) , cFile ) > 0
        RETURN( .F. )
    ENDIF
NEXT nCount

RETURN( .T. )
*
