/*
 * File......: FILSPACE.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_FILESPACE()
 *  $CATEGORY$
 *      Disk Drive
 *  $ONELINER$
 *      Calculate the ``real'' size of a file.
 *  $SYNTAX$
 *      GT_FileSpace([<cFileName>],[<ncDrive>]) --> nFileSpace
 *  $ARGUMENTS$
 *      <cFileName> is an optional parameter that is the name of the file
 *      to be checked. This paramater may be a single filename or can be
 *      a wildcard. If not supplied the default is "*.*".
 *
 *      <ncDrive> is an optional parameter that is the id of the drive
 *      for which the calculation is to be done. This paramater can be
 *      either a character value who's first character is taken as the
 *      drive letter or a numeric value where 0 = Default, 1 = A:,
 *      2 = B:, etc... If no parameter is passed the default drive is used.
 *  $RETURNS$
 *      The ``real'' size of the file(s).
 *  $DESCRIPTION$
 *      GT_FileSpace() can be used to calculate the ``real'' size of a
 *      single file or a set of files.
 *
 *      This can be of use if you wish to check that a set of files will
 *      fit into the available space on a drive. As you probably know
 *      a file that is just 1 byte in size will use up one cluster of
 *      disk space, so, for example, if the cluster size of a drive is
 *      2048 bytes a 1 byte file will use up 2048 bytes of storage.
 *  $EXAMPLES$
 *      // Display the ``real'' size of all files in the current directory.
 *
 *      ? GT_FileSpace()
 *
 *      // Display the ``real'' size of the same files if they were
 *      // copied to a network drive called F:.
 *
 *      ? GT_FileSpace(,"F:")
 *
 *      // Now check just the DBF files.
 *
 *      ? GT_FileSpace("*.Dbf","F:")
 *  $END$
 */

function GT_FileSpace(cFileName,ncDrive)
local aFiles    := {},;
      nFileSize := -1
default cFileName to "*.*"
aFiles := directory(cFileName)
if !empty(aFiles) .and. GT_SectSize(ncDrive) != -1
   nFileSize := 0
   aeval(aFiles,{|aFile| nFileSize += RealSize(aFile,ncDrive) })
endif
return(nFileSize)

/*****************************************************************************
* Function: RealSize()                                                       *
* Syntax..: RealSize(<aFile>,[<ncDrive>]) --> nRealSize                      *
* Usage...: Internal function to do the calculation.                         *
* By......: David A Pearson                                                  *
*****************************************************************************/

static function RealSize(aFile,ncDrive)
local nRealSize := 0,;
      nCluster  := GT_SectSize(ncDrive)*GT_SecPClus(ncDrive)
nRealSize := aFile[F_SIZE]/nCluster
if nRealSize != int(nRealSize)
   nRealSize := int(nRealSize)+1
endif
nRealSize *= nCluster
return(nRealSize)
