/*
 * File......: GETFILES.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_GETFILES()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Create an array containing files matching a file spec
 *  $SYNTAX$
 *      GT_GetFiles( cDrive , cPath , cFileSpec )
 *  $ARGUMENTS$
 *      cDrive    - Drive to use
 *      cPath     - Path to use
 *      cFileSpec - File spec to find
 *  $RETURNS$
 *      A sorted array of file names
 *  $DESCRIPTION$
 *      Finds all files in the given path and returns them in a sorted array
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_GetFiles( cDrive , cPath , cFileSpec )

/*****************************************************************************
 Purpose - Create an array containing files matching given spec in given directory
 Returns - Table name
 Author  - Log
 Created - 06/10/92
******************************************************************************
 Parameters - cDrive    - Drive to use
              cPath     - Path to use
              cFileSpec - File spec to find
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL aDir    := DIRECTORY( cDrive + ":" + cPath + "\" + cFileSpec )
LOCAL aReturn := {}
LOCAL nCount  := 0

FOR nCount := 1 TO LEN( aDir )
    AADD( aReturn , LEFT( aDir[ nCount , 1 ] , AT( "." , aDir[nCount , 1 ] ) - 1 ) )
NEXT nCount

RETURN ASORT( aReturn )
*
