/*
 * File......: GETINDEX.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_GETINDEXKEY()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Get the key of a Clipper index
 *  $SYNTAX$
 *      GT_GetIndexKey( cIndex, cKey )
 *  $ARGUMENTS$
 *      cIndex - Index file to get from
 *      cKey   - Key to be returned (passed by reference)
 *  $RETURNS$
 *      File error code - 0 if OK
 *  $DESCRIPTION$
 *      Opens the given index file as a binary file, and retrieves the key
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "gt_lib.ch"

FUNCTION GT_GetIndexKey( cIndex, cKey )

/*****************************************************************************
 Purpose - Read the key from an index file
 Returns - File error code - 0 if OK
 Author  - Martin Colloby
 Created - 05/06/92
 Edited  - 21/07/92 by MKC - Modified to return FERROR() code
******************************************************************************
 Parameters - cIndex - Index file to get from
              cKey   - Key to be returned (passed by reference)
 Privates   - None
 Locals     - cString - Temporary storage string
              cBuffer - Buffer containing index file header
              nHandle - File handle of index file
              nPos    - Position of key in header
 Externals  - None
******************************************************************************
 N.B. This function assumes a valid index file

 nPos = 23 for Clipper NTX files
 nPos = 25 for dBase NDX files
*****************************************************************************/

LOCAL cBuffer := SPACE( 512 )
LOCAL cString := ""
LOCAL nHandle := ""
LOCAL nPos    := 23

* See if the file exists
IF FILE( cIndex )
    * Open the file and get handle
    nHandle := FOPEN( cIndex , FO_READ )

    IF FERROR() == 0
        * Allocate 512 byte buffer

        * Read the index file header into memory
        FREAD( nHandle , @cBuffer , 512 )

        * Discard all bytes before the key expression
        cString := SUBSTR( cBuffer , nPos )

        * The expression is terminated with a zero byte (chr(0))
        cKey := TRIM( SUBSTR( cString , 1 , AT( CHR(0) , cString ) - 1 ) )
	ENDIF

    * Close the file and release the handle
    FCLOSE( nHandle )

ENDIF

RETURN( FERROR() )
*
