/*
 * File......: GTBIGTIM.PRG
 * Author....: Brian Dukes
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Brian Dukes
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Brian Dukes and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_BIGTIME()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Display the current time in BIG DIGITS
 *  $SYNTAX$
 *      GT_BigTime(<nRow>,<nCol>,<cColor>)
 *  $ARGUMENTS$
 *       <nRow>    Row number to print the time at.
 *       <nCol>    Column number to print the time at.
 *       <cColor>  Colour to display the time in.
 *
 *  $RETURNS$
 *      Nothing.
 *
 *  $DESCRIPTION$
 *     GT_BigTime() was originally written for use by the GT_Clock()
 *     screen saver; but it can be used separately for displaying the
 *     current time.
 *
 *  $EXAMPLES$
 *      GT_BigTime(10,10,"R+/N")
 *  $END$
 */

function GT_BigTime(nRow,nCol,clr)
   LOCAL ClockDigit[4]
   local c      := 0
   LOCAL tim    := time()
   LOCAL Str    := { "","","","" }
   LOCAL count  := 0

   clockDigit[1] := "                   "
   clockDigit[2] := "                             "
   clockDigit[3] := "                    "
   clockDigit[4] := "                     "

   for count := 1 to len(tim)
      c := ((asc(substr(tim,count,1))-48)*4)+1
      Str[1] += substr(ClockDigit[1],c,4)
      Str[2] += substr(ClockDigit[2],c,4)
      Str[3] += substr(ClockDigit[3],c,4)
      Str[4] += substr(ClockDigit[4],c,4)
   next

   @ nRow+0,nCol say Str[1] color clr
   @ nRow+1,nCol say Str[2] color clr
   @ nRow+2,nCol say Str[3] color clr
   @ nRow+3,nCol say Str[4] color clr

return NIL
