/*
 * File......: GTMATH02
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..:
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DTOBIN()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Turns a Decimal number into a binary string
 *  $SYNTAX$
 *      GT_DtoBin( <n> ) --> <cBinary>
 *  $ARGUMENTS$
 *      <n>  is any decimal integer
 *  $RETURNS$
 *      <cBinary> is a string representing a binary number
 *  $DESCRIPTION$
 *      This function turns a decimal integer into a binary string.
 *      This can be used for encryption, bit twiddling,
 *      bit stripping etc.
 *  $EXAMPLES$
 *      ? GT_DtoBin(255)     // '11111111'
 *      ? GT_DtoBin(15)      // '00001111'
 *  $SEEALSO$
 *      GT_BTOD() GT_BINARY()
 *  $INCLUDE$
 *      gt_lib.ch
 *  $END$
 */

#xcommand DEFAULT <a> TO <y> [,<b> TO <z>] ;
     => <a> := IF(<a> == NIL, <y>, <a>) ;
     [; <b> := IF(<b> == NIL, <z>, <b>)]

STATIC bin := '01'

Function GT_DToBin( n )  // n = Decimal Number
LOCAL retval := "", x, y

DEFAULT n TO 0

While (n>0)
   x := n%2
   n := Int(n/2)
   retval := SubStr(bin, x+1, 1)+retval
End
Return (If(Len(retval)<1,"0",retval))
