/*
    File......: GT_Choose.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/03/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/03/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_CHOOSE()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      List an array and allow selection.
 *  $SYNTAX$
 *      GT_Choose(<aOptions>,[<cTitle>],[<nTop>], ;
 *          [<nLeft>],[<nBottom>],[<nRight>],[<aValid>], ;
 *          [<nStartItem>],[<nStartRow>])
 *  $ARGUMENTS$
 *      <aOptions> is the array to list.
 *
 *      <cTitle> is an optional title.
 *
 *      <nTop>,<nLeft>,<nBottom>,<nRight> Window Co-ords.
 *
 *      <aValid> an array of logical values matching the
 *      options list.
 *
 *      <nStartItem> is the entry point for the array.
 *
 *      <nStartRow> is the row of the window to start on.
 *  $RETURNS$
 *      nSelected
 *  $DESCRIPTION$
 *      Basically this is a tarted up ACHOICE(). Allowing
 *      a box around it, title and proper key handling.
 *  $EXAMPLES$
 *      nOption := 1
 *      nOption := Gt_Choose({'1. Start','2. End  ','3.Exit '}, ;
 *          'Now what?',02,02,NIL,NIL,NIL,nOption)
 *  $SEEALSO$
 *      GT_BROWSE()
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GtClippe.ch"
#include "aChoice.ch"

FUNCTION GT_Choose(aOptions,cTitle,nTop,nLeft,nBottom, ;
    nRight,aValid,nStartItem,nStartRow)

LOCAL nWidth := 0
LOCAL nReturn := 0

Default aOptions to {}
Default cTitle to ''
Default nTop to 04
Default nLeft to 02
Default nBottom to MAXROW()-01
Default nRight to MAXCOL()-02
Default aValid to .T.
Default nStartItem to 1
Default nStartRow to 1

//  No list
IF LEN(aOptions) < 1
    RETURN(0)
ENDIF

//  Size window
nWidth := nRight - nLeft - 1

//  Draw window
GT_Window(nTop,nLeft,nBottom,nRight,BOX_DS,SETCOLOR())
@ nTop + 02, nLeft SAY SUBSTR(BOX_DS,11,1)
@ nTop + 02, nRight SAY SUBSTR(BOX_DS,10,1)
@ nTop + 02, nLeft + 01 SAY REPLICATE(SUBSTR(BOX_DS,2,1), ;
    nWidth)

@ nTop + 01, nLeft + 01 SAY cTitle

nReturn := ACHOICE(nTop+3,nLeft+1,nBottom-1,nRight-1 ;
                    ,aOptions,aValid,'Key_Control' ;
                    ,nStartItem,nStartRow)

/*
    End of GT_Choose()
*/
RETURN(nReturn)
/*
***********************************************************
*/
STATIC FUNCTION Key_Control(nMode,nInlist,nInWin)

LOCAL nReturn := AC_CONT
LOCAL nKey := LASTKEY()

Default nMode to AC_NOITEM
Default nInlist to 0
Default nInWin to 0

DO CASE
    CASE nMode = AC_EXCEPT
        // Some key that ACHOICE does not understand
        DO CASE
            CASE nKey = K_ENTER
                // Select
                nReturn := AC_SELECT

            CASE nKey = K_ESC
                // Escape
                nReturn := AC_ABORT

            CASE ISALPHA(CHR(nKey))
                // Letter to search For
                nReturn := AC_GOTO

            OTHERWISE
                // I dunno ?

        ENDCASE

    CASE nMode = AC_NOITEM
        // No items to select
        nReturn := AC_ABORT

    OTHERWISE
        // AC_IDLE, AC_HITTOP, AC_HITBOT Do nothing special

ENDCASE

/*
    End of Key_Control()
*/
RETURN(nReturn)

