/*
 * File......: GTDOW2C.PRG
 * Author....: George Brennan
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: George Brennan
 * Date......: 23/03/93
 * Revision..: 1.0
 *
 * This is an original work by George Brennan and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *		GT_DOW2C()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *		character value for numeric week day
 *  $SYNTAX$
 *		GT_DOW2C( <nDay> ) -> cDow
 *  $ARGUMENTS$
 *		<nDay>	 is a numeric day of the week
 *
 *  $RETURNS$
 *		A character value, for the coresponding day
 *
 *	$DESCRIPTION$
 *		GT_DOW2C() can be used to return character value from
 *				   a numeric day of the week.
 *
 *  $EXAMPLES$
 *
 *	local nDay := 2
 *
 *	? "Day of Week No", nDay, "is", GT_DOW2C( nDay )
 *
 *	result :
 *			 Day of Week No   2   is   Monday
 *	$END$
 */

#include "gt_lib.ch"       // used to pre-process DEFAULT

static aDayNames  := { "Sunday",    ;
					   "Monday",    ;
					   "Tuesday",   ;
					   "Wednesday", ;
					   "Thursday",  ;
					   "Friday",    ;
					   "Saturday",  ;
					   "        " }

FUNCTION GT_DOW2C( nDayOfWeek )

   DEFAULT nDayOfWeek TO 8

   nDayOfWeek := IF( nDayOfWeek < 1, 8, MIN( nDayOfWeek, 8))

RETURN ( padr(aDayNames[ nDayOfWeek ], 8) )
