/*
 * File......: GT_DOW2N.PRG
 * Author....: George Brennan
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: George Brennan
 * Date......: 23/03/93
 * Revision..: 1.0
 *
 * This is an original work by George Brennan and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *		GT_DOW2N()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *		Numeric day of week from a full or partial character string
 *  $SYNTAX$
 *		GT_DOW2N( <cDay> ) -> nValue
 *  $ARGUMENTS$
 *		<cDay>	 is a full or partial week day. "Mon", "Monday"
 *
 *  $RETURNS$
 *		A numeric value of the day of the week Sun -> 1
 *
 *	$DESCRIPTION$
 *		GT_DOW2N() can be used to get the numeric day of a character week day
 *
 *  $EXAMPLES$
 *
 *			 local cDay := "Mon"
 *
 *			 ? "Day of Week for", cDay, " is ", GT_DOW2N( cDay )
 *
 *			 result :
 *					  Day of Week for Mon is 2
 *
 *	$END$
 */

#include "gt_lib.ch"       // used to pre-process DEFAULT

static aDayNames  := { "Sunday",    ;
					   "Monday",    ;
					   "Tuesday",   ;
					   "Wednesday", ;
					   "Thursday",  ;
					   "Friday",    ;
					   "Saturday",  ;
					   "        " }

FUNCTION GT_DOW2N( cDayName )
LOCAL cUpper   := ""
LOCAL nDayNum  := 0
LOCAL nLenName := 0

   DEFAULT cDayName to " "

   cUpper	:= UPPER( ALLTRIM( cDayName ) )
   nDayNum	:= 0
   nLenName := LEN( cDayName )

   nDayNum := ASCAN( aDayNames, ;
					{ |xDow| UPPER( LEFT(xDow, nLenName) ) == cUpper } )

RETURN ( nDayNum )
