/*
 * File......: GT_ISDOW.PRG
 * Author....: George Brennan
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: George Brennan
 * Date......: 23/03/93
 * Revision..: 1.0
 *
 * This is an original work by George Brennan and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 *	$DOC$
 *  $FUNCNAME$
 *		GT_ISDOW()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *		logically evaluate a textual day of the week
 *  $SYNTAX$
 *		GT_ISDOW( cDay ) -> lValue
 *  $ARGUMENTS$
 *		<cDay>	 is a character value for the weekday
 *
 *  $RETURNS$
 *		A logical value, .T. if the key is conditionally valid
 *
 *	$DESCRIPTION$
 *		GT_ISDOW() can be used to validate a character value as being a
 *				   valid day of the week.
 *
 *  $EXAMPLES$
 *
 *		? "Day of Week ", cDay, " is ", GT_ISDOW( "Mon" )
 *
 *		result : Day of Week Monday is	 .T.
 *
 *	$END$
 */

#include "gt_lib.ch"       // used to pre-process DEFAULT

static aDayNames  := { "Sunday",    ;
					   "Monday",    ;
					   "Tuesday",   ;
					   "Wednesday", ;
					   "Thursday",  ;
					   "Friday",    ;
					   "Saturday",  ;
					   "        " }

FUNCTION IsCdow( cDayName )
LOCAL cUpper   := ""
LOCAL nFound   := 0
LOCAL nLenName := 0

   DEFAULT cDayName to " "

   cUpper	:= UPPER( ALLTRIM( cDayName ) )
   nFound	:= 0
   nLenName := LEN( cDayName )

   nFound := ASCAN( aDayNames, ;
					{ |cName| UPPER( LEFT( cName, nLenName) ) == cUpper } )

   RETURN ( nFound  > 0 .AND. nFound < 8 )
 //..
