/*****************************************************************************
* Header File: GT_MEN.H                                                      *
* By.........: David A Pearson                                               *
* Function...: Defines memory access macros for use with the C functions.    *
*****************************************************************************/

// Get the offset of a far pointer.

#define _GT_FP_OFF(fp)          ((unsigned)(fp))

// Get the segment of a far pointer.

#define _GT_FP_SEG(fp)          ((unsigned)((unsigned long)(fp) >> 16))

// Make a far pointer.

#define _GT_MK_FP(seg,ofs)      ((void far *)(((unsigned long)(seg) << 16) | (unsigned)(ofs)))

// Poke a word.

#define _GT_poke(a,b,c)         (*((int  far*)_GT_MK_FP((a),(b))) = (int)(c))

// Poke a byte.

#define _GT_pokeb(a,b,c)        (*((char far*)_GT_MK_FP((a),(b))) = (char)(c))

// Peek a word.

#define _GT_peek(a,b)           (*((int  far*)_GT_MK_FP((a),(b))))

// Peek a byte.

#define _GT_peekb(a,b)          (*((char far*)_GT_MK_FP((a),(b))))
