/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: gt_off.c
 * Author....: Brian Dukes
 * BBS.......: THE CELLAR bbs
 * Net/Node..: 013/203
 * User Name.: Brian Dukes
 * Date......: 10/5/93
 * Revision..: 1.0
 *
 * This is an original work by Brian Dukes and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_OFFSET()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Returns the offset of the passed character string
 *  $SYNTAX$
 *      GT_Offset(<str>) --> nOffset
 *  $ARGUMENTS$
 *      <str>     - Character String
 *  $RETURNS$
 *      nOffset   - The offset of <str>.
 *  $DESCRIPTION$
 *      This function will become invaluable when calling GT_Int86()
 *      functions, as some of these functions will need to know the address
 *      of strings that are passed in.
 *
 *  $EXAMPLES$
 *      ? GT_Offset(str)
 *
 *  $SEEALSO$
 *      GT_SEGMENT()   SYSTEM.EHO:GT_INT86()
 *  $END$
 */

/**** Compiled in MS/C v6.0  as  CL /AL /Gs /Zl -c gt_off.c        ****/

#include <extend.h>

/* FP_OFF Ripped out of DOS.H - No need to include all the other junk from it */
#define FP_OFF(fp) (*((unsigned _far *)&(fp)))


CLIPPER gt_offset()
{
   unsigned offset = 0 ;
   char far * ptr ;

   if (_parinfo(1) == CHARACTER)
      {
         ptr = _parc(1) ;
         offset = FP_OFF(ptr) ;
      }

   _retni(offset) ;
}

/**** end of function ****/
