/*
    File......: GT_Skip.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 11/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 11/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_SKIP()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Move the filepointer n valid records from the current
 *  $SYNTAX$
 *      GT_Skip([<bWhile>],[<bFor>],[<nRecords>],[<lEof>]) -> nMoved
 *  $ARGUMENTS$
 *      <bWhile> Code block giving a while clause.
 *
 *      <bFor> Code block giving a for clause.
 *
 *      <nRecords> is the number of records to move down the
 *      file. Ie negative requires movement towards to
 *      begining of file.
 *  $RETURNS$
 *      nMoved
 *  $DESCRIPTION$
 *      Reposition the filepointer n valid records from the
 *      current.
 *  $EXAMPLES$
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_Skip(bWhile,bFor,nRecords,lEof)

LOCAL nCount := 0
LOCAL nSafeOne := RECNO()

Default bWhile to { | | .T. }
Default bFor to { | | .T. }
Default nRecords to 0
Default lEof to .T.

DO CASE

    CASE ( nRecords == 0 ) .OR. ( LASTREC() = 0 )
        // Move of 0 requested, or no records
        DBSKIP(0)

    CASE (nRecords > 0)
        // Forward
        nCount := -1

        BEGIN SEQUENCE

            DBEVAL( { || nSafeOne := RECNO() ;
                ,IF(++nCount=nRecords,BREAK(NIL),NIL) } ;
                ,bFor,bWhile,NIL,NIL,.T.)

            DBGOTO(IF(lEof,LASTREC()+01,nSafeOne))

            nCount := MAX(0,nCount)

        END SEQUENCE

    CASE (nRecords < 0)
        // Move backwards

        DO WHILE  .T.

            DBSKIP(-1)

            DO CASE

                CASE BOF() .OR. .NOT. EVAL(bWhile)
                    // Not in while condition

                    IF lEof
                        DBGOTO(LASTREC()+01)
                    ELSE
                        DBGOTO(nSafeOne)
                    ENDIF

                    EXIT

                CASE EVAL(bFor)
                    //  For OK

                    nCount--
                    nSafeOne := RECNO()

                    IF nRecords = nCount
                        EXIT
                    ENDIF

                OTHERWISE
                    // In while but not for

            ENDCASE

        ENDDO

    OTHERWISE
        // Nothing
        DBSKIP(0)

ENDCASE

/*
    End of GT_Skip()
*/
RETURN(nCount)
