/*
 File......: GT_TOSTR.prg
 Author....: Phillip Hamlyn
 BBS.......: The Dark Knight Returns
 Net/Node..: 050/069
 User Name.: Phillip Hamlyn
 Date......: 03/03/93
 Revision..: 1.0

 This is an original work by Phillip Hamlyn and is placed in the
 public domain.

 Modification history:
 ---------------------

 Rev 1.0 03/03/93
 Initial revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_TOSTR()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Convert a clipper variable type to a string
 *  $SYNTAX$
 *      GT_ToStr( <xVar> ) --> <cVar>
 *  $ARGUMENTS$
 *      <xVar>        Any Clipper variable type.
 *  $RETURNS$
 *      <cVar>       Character representation of the variable passed.
 *  $DESCRIPTION$
 *      Function used to convert a clipper variable type to a string.
 *  $EXAMPLES$
 *      GT_ToStr(space(8)) --> space(8)
 *      GT_ToStr("Phillip Hamlyn") --> "Phillip Hamlyn"
 *      GT_ToStr( {|| "PCH" } ) --> "PCH"
 *      GT_ToStr( 123123 ) --> "123123"
 *      GT_ToStr( ctod("31/08/69") ) --> "31/08/69"
 *      GT_ToStr( {1,2,3} ) --> ""
 *      GT_ToStr( TbrowseNew() ) --> ""
 *      GT_ToStr( TRUE ) --> "Y"
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "gt_lib.ch"
//==================
function GT_ToStr (xVar)
//==================
// returns the string of any xVariable type

if valtype(xVar) != TYPE_STRING
   do case
      case valtype(xVar) == TYPE_NUMERIC
         return ltrim(str(xVar))
      case valtype(xVar) == TYPE_DATE
         return dtoc(xVar)
      case valtype(xVar) == TYPE_BLOCK
         return GT_ToStr(eval(xVar))
      case valtype(xVar) == TYPE_MEMO
         return xVar
      case valtype(xVar) == TYPE_LOGICAL
         return iif(xVar,"Y","N")
      case valtype(xVar) == TYPE_UNDEFINED
         return ""
   endcase
else
   return xVar
endif
return ""
