/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: gt_ucmpn.c
 * Author....: Brian Dukes
 * BBS.......: THE CELLAR bbs
 * Net/Node..: 013/203
 * User Name.: Brian Dukes
 * Date......: 28/5/93
 * Revision..: 1.0
 *
 * This is an original work by Brian Dukes and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_UNCOMPN()
 *  $CATEGORY$
 *      Compression
 *  $ONELINER$
 *      UN-Compress a String to a Clipper Numeric value
 *  $SYNTAX$
 *      <numeric> := GT_UnCompN(<string>,<size>)
 *  $ARGUMENTS$
 *      <str>     - Character String to uncompress
 *      <size>    - Number of Bytes of string to uncompress (1/2/4/8)
 *  $RETURNS$
 *      <numeric> - Clipper value uncompressed
 *  $DESCRIPTION$
 *      This function works hand-in-hand with GT_CompN(), this function
 *      uncompress's strings that have previously been compressed.
 *
 *  $EXAMPLES$
 *      #include "gt_compn.h"
 *
 *         s_w := GT_CompN( w, GT_BYTE)
 *         s_x := GT_CompN( x, GT_INT )
 *         s_y := GT_CompN( y, GT_LONG)
 *         s_z := GT_CompN( z, GT_DOUBLE)
 *
 *         * Display the Values that were Stored
 *
 *         ? GT_UnCompN( s_w, GT_BYTE)
 *         ? GT_UnCompN( s_x, GT_INT )
 *         ? GT_UnCompN( s_y, GT_LONG)
 *         ? GT_UnCompN( s_z, GT_DOUBLE)
 *
 *  $SEEALSO$
 *      GT_COMPN()
 *  $END$
 */

/**** Compiled in MS/C v6.0  as  CL /AL /Gs /Zl -c gt_ucmpn.c        ****/

#include <extend.h>
#include "gt_compn.h"

CLIPPER GT_UNCompN()
{
   char far * out   = _parc( 1 )  ;  /* Get pointer to Clipper string */
   unsigned int siz = _parni( 2 ) ;  /* Get the SIZE of the Variable  */
   int i_var    = 0 ;
   long l_var   = 0 ;
   double d_var = 0.00 ;

   switch (siz)
      {
         case GT_BYTE :
            i_var = out[0] ;
            _retni( i_var ) ;
            break;

         case GT_INT :
            _gt_copy_far(&i_var,out,GT_INT) ;
            _retni( i_var ) ;
            break;

         case GT_LONG :
            _gt_copy_far(&l_var,out,GT_LONG) ;
            _retnl( l_var ) ;
            break;

         case GT_DOUBLE :
            _gt_copy_far(&d_var,out,GT_DOUBLE) ;
            _retnd( d_var ) ;
            break;
      }

   return ;
}

/***************************************************************************
 _gt_copy_far() - Copy Far Memory to Near Memory
 ***************************************************************************/

int _gt_copy_far( char * out , char far * in , int len)
{
   int i = 0 ;
   char far * fp = in ;
   char * p = out ;

   while (i < len)
      {
         *p++ = *fp++ ;
         ++i ;
      }

   return (len) ;
}
