/*
 * File......: NAMECOUN.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_NAMECOUNT()
 *  $CATEGORY$
 *      String
 *  $ONELINER$
 *      Count the number of elements in a delimited string
 *  $SYNTAX$
 *      GT_NameCount( cString )
 *  $ARGUMENTS$
 *      cString - Delimited string, delimited by it's first character
 *  $RETURNS$
 *      Number of elements in string
 *  $DESCRIPTION$
 *      Count the number of elements in a delimited string
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.ch"

FUNCTION GT_NameCount( cString )

/****************************************************************************
 Purpose - Count number of elements in cString
 Returns - Number of occurences
 Author  - Martin Colloby
 Created - 29/8/90
 Edited  - 3/10/60 by Martin Colloby
******************************************************************************
 Parameters - cString    - Delimited string
 Privates   - cDelimiter - Delimiting character
 Externals  - None
****************************************************************************/

LOCAL cDelimiter := SUBSTR( cString , 1 , 1 )

* Count the number of occurences of the delimiting character, and subtract
* one - for the first character
RETURN( GT_Occurs( cDelimiter , cString ) - 1 )
*
