;  File......: NUMLOCK.ASM
;  Author....: Andy M Leighton
;  BBS.......: The Dark Knight Returns
;  Net/Node..: 050/069
;  User Name.: Andy Leighton
;  Date......: $Date$
;  Revision..: $Rev$
;
;  This is an original work by Andy Leighton and is placed in the public
;  domain.
;
;  Modification history:
;  ---------------------
;
;  $Log$
;
;
;
;   $DOC$
;   $FUNCNAME$
;       GT_ISNUMLOCK()
;   $CATEGORY$
;       Keyboard
;   $ONELINER$
;       Checks Num Lock
;   $SYNTAX$
;       GT_isNumLock() --> lRet
;   $ARGUMENTS$
;       None
;   $RETURNS$
;       lRet    -       TRUE if numlock is on, otherwise FALSE
;   $DESCRIPTION$
;       Checks status of Num Lock
;   $EXAMPLES$
;       ? "Num Lock Is Turned " + if(GT_isNumLock(), "On", "Off")
;   $END$
;

; This has been written using TASM
; If you are using MASM you might have to change things
; around a little
; look for comments telling you what to do
;

;MASM   remove next line

                IDEAL


Public          GT_ISNUMLO

Extrn           __RetL:Far

;MASM change next line to
;               GtLibrary       SEGMENT WORD  "CODE"
Segment         GtLibrary       Word    "CODE"
                Assume          CS:GtLibrary

;MASM change next line to
;               GT_ISNUMLO      PROC FAR
Proc            GT_ISNUMLO      Far

                PUSH    ES                         ; save for later
; set up ES:[BX] to point to the address 0x00000417
                MOV     AX,40H
                MOV     ES,AX
                MOV     BX,17H

                XOR     AH,AH                      ; Clear high byte of AX
                MOV     AL,BYTE PTR ES:[BX]        ; Get keyboard flags
                AND     AL,20H                     ; isolate bit 6
                PUSH    AX
                CALL    __RETL                     ; set up CLIPPER return
                ADD     SP, 2                      ; reset stack ptr
                POP     ES                         ; restore ES
                RET

;MASM change next line to
;               GT_ISNUMLO      ENDP
EndP            GT_ISNUMLO

;MASM change next line to
;               GtLibrary       ENDS
EndS            GtLibrary

                End
