/*
 * File......: PNEXTROW.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_NEXTROW()
 *  $CATEGORY$
 *      Printer
 *  $ONELINER$
 *      Output text to the next printer row
 *  $SYNTAX$
 *      GT_NextRow( nDown , cWhat , nLeftMgn )
 *  $ARGUMENTS$
 *      nDown    - Number of rows to move down
 *      cWhat    - Text to be output
 *      nLeftMgn - Left margin of text
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Moves the printer row down and outputs the given text
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.CH"

FUNCTION GT_NextRow( nDown , cWhat , nLeftMgn )

/*****************************************************************************
 Purpose - Output text to printer on next row
 Returns - None
 Author  - Martin Colloby
 Created - 04/24/92
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - nDown    - Number of rows to move down
              cWhat    - Text to be output
              nLeftMgn - Left margin of text
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

DEFAULT  cWhat    TO ""
DEFAULT nDown    TO 1
DEFAULT nLeftMgn TO 0

@ PROW() + nDown , nLeftMgn SAY cWhat

RETURN NIL
*
