/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: restscr.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_RESTSCR()
 *  $CATEGORY$
 *       Video
 *  $ONELINER$
 *       Restore a screen.
 *  $SYNTAX$
 *       GT_restScr(<cScr>, [<nTop>], [<nLeft>],
 *                          [<nBottom>], [<nRight>]) --> lRet
 *  $ARGUMENTS$
 *       <cScr>      -  A string previously returned by saveScr()
 *       <nTop>      -  Top line of screen area to restore
 *       <nLeft>     -  Leftmost col. of screen area to restore
 *       <nRight>    -  Rightmose col. of screen area to restore
 *       <nBottom>   -  Bottom line of screen area to restore
 *  $RETURNS$
 *       lRet          - .T. if the screen is restored
 *  $DESCRIPTION$
 *       Restore a previously saved screen
 *
 *       The positioning information is optional and if it is  left
 *       out the screen will restore  to the postion it was  saved.
 *       If coordinates  are passed,  they must  represent an  area
 *       exactly equal to that of the saved screen and in the  same
 *        proportion otherwise the function will return .F.
 * $SEEALSO$
 *       GT_SAVESCR()
 *  $EXAMPLES$
 *  $END$
 */

#include "gt_lib.ch"

function GT_restScr(cScr, nTop, nLeft, nBottom, nRight)

   local lRet       := TRUE
   local nHorizArea
   local nVertArea

   do case
      case pcount() == 0                        // no parameters do nothing
         lRet := FALSE
      case pcount() == 1                        // restore screen to saved
         nTop    := asc(substr(cScr, 1, 1))     // position
         nLeft   := asc(substr(cScr, 2, 1))
         nBottom := asc(substr(cScr, 3, 1))
         nRight  := asc(substr(cScr, 4, 1))
         restscreen(nTop, nLeft, nBottom, nRight, substr(cScr, 5))
      otherwise                                 // restore to specified
         default nTop    to 0                   // coordinates
         default nLeft   to 0
         default nBottom to maxrow()
         default nRight  to maxcol()
         nHorizArea := asc(substr(cScr, 4, 1)) - asc(substr(cScr, 2, 1))
         nVertArea  := asc(substr(cScr, 3, 1)) - asc(substr(cScr, 1, 1))

         if (nRight - nLeft == nHorizArea) .and.            ;
            (nBottom - nTop == nVertArea)
            restscreen(nTop, nLeft, nBottom, nRight, substr(cScr, 5))
         else
            lRet := FALSE                       // specified area != size of
                                                // saved area
         endif
   endcase

return lRet
