/*
 * File......: SETTIME.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <extend.h>
#include "internal.h"

Boolean ValidTime(char *, int);
Boolean SetDosTime(char, char, char);

/*  $DOC$
 *  $FUNCNAME$
 *      GT_SETTIME()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Set the DOS system time.
 *  $SYNTAX$
 *      GT_SetTime(<cTime>) --> lSetOk
 *  $ARGUMENTS$
 *      <cTime> is a string parameter that is a time in the same format
 *      as that returned by the Clipper Time() function.
 *  $RETURNS$
 *      If the time was set ok, GT_SetTime() returns true (.T.), if not
 *      it returns false (.F.).
 *  $DESCRIPTION$
 *      GT_SetTime() can be used to set the DOS system time to a new
 *      value.
 *  $EXAMPLES$
 *      // Set the DOS system time to midday.
 *
 *      ? GT_SetTime("12:00:00")
 *  $SEEALSO$
 *      GT_SETDATE()
 *  $END$
 */

CLIPPER GT_SetTime()
{
        char    *Time;
        Boolean Result = FALSE;

        if (PCOUNT == 1 && ISCHAR(1))
        {
                Time = _parc(1);
                if (ValidTime(Time,_parclen(1)))
                {
                        Result = SetDosTime((char) _GT_Internal_StringAsInt(Time,0,1),
                                            (char) _GT_Internal_StringAsInt(Time,3,4),
                                            (char) _GT_Internal_StringAsInt(Time,6,7));
                }
        }
        _retl(Result);
}

/*****************************************************************************
* Function: ValidTime()                                                      *
* Syntax..: Boolean ValidTime(char *Time, int Length)                        *
* Usage...: Internal function to check that a time string is valid.          *
* By......: David A Pearson                                                  *
*****************************************************************************/

static Boolean ValidTime(char *Time, int Length)
{
        Boolean  TimeIsValid = FALSE;
        unsigned Hours;
        unsigned Mins;
        unsigned Secs;

        if (Length == 8)
        {
                if (Time[2] == ':' && Time[5] == ':')
                {
                        Hours = (unsigned) _GT_Internal_StringAsInt(Time,0,1);
                        Mins  = (unsigned) _GT_Internal_StringAsInt(Time,3,4);
                        Secs  = (unsigned) _GT_Internal_StringAsInt(Time,6,7);
                        TimeIsValid = (Hours < 24 && Mins < 60 && Secs < 60);
                }
        }
        return(TimeIsValid);
}

/*****************************************************************************
* Function: SetDosTime()                                                     *
* Syntax..: Boolean SetDosTime(char Hours, char Mins, char Secs)             *
* Usage...: Internal function to call the DOS set time function.             *
* By......: David A Pearson                                                  *
*****************************************************************************/

static Boolean SetDosTime(char Hours, char Mins, char Secs)
{
        asm     Mov     AH,0x2D
        asm     Mov     CH,Hours
        asm     Mov     CL,Mins
        asm     Mov     DH,Secs
        asm     Mov     DL,0
        asm     Int     0x21
        return(_AL != 0xFF);
}
