/*
 * File......: WARNING.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_WARNING()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Output a warning message in white on red
 *  $SYNTAX$
 *      GT_Warning( aText )
 *  $ARGUMENTS$
 *      aText - Array of text.  Each element will appear on a different line
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      The text in aText is output in white on red, in a white on red box
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.ch"

FUNCTION GT_Warning( aString )

/****************************************************************************
 Purpose - Output a White on Red warning
 Returns - None
 Author  - Martin Colloby
 Created - 22/8/91
******************************************************************************
 Parameters - aString - Array containing string for warning message
 Locals     - cScreen - Temporary storage for screen
 Externals  - None
****************************************************************************/

LOCAL cScreen := GT_SaveScr( 0 , 0 , MAXROW() , MAXCOL() )
LOCAL nCursor := SETCURSOR( 0 )

GT_ColorSet( C_BOLD )
@ 0 , 0 SAY PADR( ""                          , MAXCOL() )
@ 1 , 0 SAY PADR( "Press any key to continue" , MAXCOL() )
GT_ColorSet( C_NORMAL )

* Output the string
GT_BlatBox( aString , -1 , -1 , C_WARNING )
GT_ColorSet( C_NORMAL )

* Output a warning beep
GT_Beep()
GT_Beep()

GT_GetKey()

GT_RestScr( cScreen )

SETCURSOR( nCursor )

RETURN NIL
*
