/*
 * File......: WINCLIPB.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 24/03/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include "gt_mem.h"
#include <Extend.H>

Boolean _ClipboardIsHere(void);
Boolean _OpenClipboard(void);
void    _CloseClipboard(void);

/*  $DOC$
 *  $FUNCNAME$
 *      GT_CBPASTE()
 *  $CATEGORY$
 *      Windows
 *  $ONELINER$
 *      Place text into the MS Windows clipboard.
 *  $SYNTAX$
 *      GT_CBPaste(<cText>) --> lPasted
 *  $ARGUMENTS$
 *      <cText> is the text to place into the Windows clipboard.
 *  $RETURNS$
 *      A logical value, .T. if the text was pasted, .F. if not.
 *  $DESCRIPTION$
 *      GT_CBPaste() can be used to place text into the Windows clipboard
 *      when your application is running in a DOS window.
 *
 *      If the text is pasted into the clipboard the function will return
 *      true (.T.), if not, it will return false (.F.). For the function
 *      to fail to paste one of the following has to happen:
 *
 *              a) The application is not running under MS Windows.
 *              b) The DOS paste service is not available.
 *              c) The clipboard could not be opened.
 *
 *      The information used to write this function was taken from ``Hands
 *      On - Low Level'' in Personal Computer World - December 1992, Page
 *      451. This article states that there is a problem using the
 *      described method with Windows 3.1. I have tested this function with
 *      Windows 3.1 and Windows For Workgroups and it appears to work
 *      fine.
 *
 *  $EXAMPLES$
 *
 *      // Function to take a customers address details and paste them
 *      // Into the Windows clipboard.
 *
 *      #define CR_LF   chr(13)+chr(10)
 *
 *      function AddresToClip()
 *      if GT_CBPaste(alltrim(Customer->Address1)+CR_LF+;
 *                    alltrim(Customer->Address2)+CR_LF+;
 *                    alltrim(Customer->Address3)+CR_LF+;
 *                    alltrim(Customer->Address4)+CR_LF+;
 *                    alltrim(Customer->Address5)+CR_LF)
 *
 *         // Tell the user that it worked.
 *
 *      else
 *
 *        // Tell the user that it didn't work.
 *
 *      endif
 *      return(NIL)
 *
 *  $END$
 */

CLIPPER GT_CBPaste()
{
        char    *Text;
        int     Size;
        int     SegText;
        int     OffText;
        int     HiSize;
        int     LoSize;
        Boolean Ok = FALSE;

        if (PCOUNT >= 1 && ISCHAR(1))
        {
                if (_ClipboardIsHere())
                {
                        if (_OpenClipboard())
                        {
                                Text    = _parc(1);
                                SegText = _GT_FP_SEG(Text);
                                OffText = _GT_FP_OFF(Text);
                                Size    = _parclen(1);
                                HiSize  = _GT_FP_SEG(Size);
                                LoSize  = _GT_FP_OFF(Size);

                                asm     mov     DX,01h
                                asm     mov     ES,SegText
                                asm     mov     BX,OffText
                                asm     mov     SI,HiSize
                                asm     mov     CX,LoSize
                                asm     mov     AX,1703h
                                asm     int     2Fh
                                Ok = (_AX != 0);
                                _CloseClipboard();
                        }
                }
        }
        _retl(Ok);
}

/*****************************************************************************
* Function: _ClipboardIsHere()                                               *
* Syntax..: Boolean _ClipboardIsHere(void)                                   *
* Usage...: Internal function to check if Windows is running and if we can   *
* ........: talk to the Clipboard.                                           *
* By......: David A Pearson                                                  *
*****************************************************************************/

static Boolean _ClipboardIsHere(void)
{
        Boolean Ok = TRUE;

        asm     mov     AX,1600h
        asm     int     2Fh
        asm     test    AL,7Fh
        asm     jnz     WinFound
        asm     mov     AX,4680h
        asm     int     2Fh
        asm     or      ax,ax
        asm     jz      WinFound
        Ok = FALSE;
WinFound:
        if (Ok)
        {
                asm     mov     AX,1700h
                asm     int     2Fh
                Ok = (_AX != 0x1700);
        }
        return(Ok);
}

/*****************************************************************************
* Function: _OpenClipboard()                                                 *
* Syntax..: Boolean _OpenClipboard(void)                                     *
* Usage...: Internal function to open the clipboard.                         *
* By......: David A Pearson                                                  *
*****************************************************************************/

static Boolean _OpenClipboard(void)
{
        asm     mov     AX,1701h
        asm     int     2Fh
        return(_AX != 0);
}

/*****************************************************************************
* Function: _CloseClipboard()                                                *
* Syntax..: Boolean _CloseClipboard(void)                                    *
* Usage...: Internal function to close the clipboard.                        *
* By......: David A Pearson                                                  *
*****************************************************************************/

static void _CloseClipboard(void)
{
        asm     mov     AX,1708h
        asm     int     2Fh
}
