/*
 File......: GT_SNAKE.prg
 Author....: Phillip Hamlyn
 BBS.......: The Dark Knight Returns
 Net/Node..: 050/069
 User Name.: Phillip Hamlyn
 Date......: 03/03/93
 Revision..: 1.0

 This is an original work by Phillip Hamlyn and is placed in the
 public domain.

 Modification history:
 ---------------------

 Rev 1.0 03/03/93
 Initial revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_SNAKE()
 *  $CATEGORY$
 *      Screen Saver
 *  $ONELINER$
 *      Novell-style snake screen saver
 *  $SYNTAX$
 *      GT_Snake(<cColour>) -> NIL
 *  $ARGUMENTS$
 *      <cColour> This is the snakes colour, defaults to setColour()
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Screen saver for any Clipper application. This screen saver draws a
 *      snake on the screen and lets it fly !
 *  $EXAMPLES$
 *      GT_Snake("W+/BG") -> NIL
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "gt_lib.ch"

* * * * * * * * *
FUNCTION GT_Snake (cColour)
* * * * * * * * *
#define NORTH 1
#define SOUTH 2
#define EAST 3
#define WEST 4
LOCAL  aWorm, bInterrupt
local nDirection := NORTH
local cScreen := ""
local nRand := 0, f := 0
// possible directions...
local nNewDirs := { {SOUTH,EAST,WEST} ,;
                    {NORTH,WEST,EAST} ,;
                    {WEST ,SOUTH,NORTH},;
                    {NORTH,EAST,SOUTH} }

local nX,nY

local cWormCol := iif(cColour == NIL,setcolor(),cColour)

bInterrupt := GT_Interrupt()

aWorm :={{12,29,'',cWormCol},;
         {12,30,'',cWormCol },;
         {12,31,'',cWormCol },;
         {12,32,'',cWormCol },;
         {12,33,'',cWormCol },;
         {12,34,'',cWormCol },;
         {12,35,'',cWormCol },;
         {12,36,'',cWormCol },;
         {12,37,'',cWormCol },;
         {12,38,'',cWormCol },;
         {12,39,'',cWormCol},;
         {12,40,'',cWormCol },;
         {12,41,'',cWormCol },;
         {12,42,'',cWormCol },;
         {12,43,'',cWormCol},;
         {12,44,'',cWormCol },;
         {12,45,' ',cWormCol }}

// m_csroff() // Turn off your mouse if required.

cScreen := savescreen(0,0,maxrow(),maxcol())

do while TRUE // LOOP until interrupt is given.

   // Now check the keyboard etc.
   if eval(bInterrupt)
      exit
   endif

   // Does the worm change direction ?
   nRand := val(right(str(seconds(),8,2),1))
   // Force this if the worm is going off the screen

   do while TRUE // till we get a valid direction ...

      do case
         case nDirection == NORTH .and. aWorm[1][1] == 0
            nRand := 10 // impossible to get normaly !
         case nDirection == SOUTH .and. aWorm[1][1] == maxrow()
            nRand := 10 // impossible to get normaly !
         case nDirection == EAST .and. aWorm[1][2] == 0
            nRand := 10 // impossible to get normaly !
         case nDirection == WEST .and. aWorm[1][2] == maxCOL()
            nRand := 10 // impossible to get normaly !
      endcase

      if nRand > 7
         nRand := val(right(str(seconds(),8,2),1))

         // we need to change direction.
         // Make Rand itself /3 so we get a 1,2,3 number
         nRand := round(nRand / 3,0)
         nRand := max(nRand,1)
         nRand := min(3,nRand)
         // Ok should be itself / 3 and either 1,2,3
         // probably not totaly random but who cares ?
         nDirection := nNewDirs[nDirection][nRand]
      else
         exit // found a valid direction
      endif

   enddo // till we get a valid direction

   nX := 0 // elements to advance
   nY := 0
   // Advance the worm !
   do case
      case nDirection == NORTH
         nX := -.5
      case nDirection == SOUTH
         nX := .5
      case nDirection == EAST
         nY := -1
      case nDirection == WEST
         nY := 1
   endcase

   // now apply this to the entire worms coordinates and paint it.

   for f := len(aWorm) to 1 step -1
      @ aWorm[f][1], aWorm[f][2] say aWorm[f][3] colour aWorm[f][4]
      if f == 1
         aWorm[f][1] := aWorm[f][1] + nX
         aWorm[f][2] := aWorm[f][2] + nY
      else
         aWorm[f][1] := aWorm[f-1][1]
         aWorm[f][2] := aWorm[f-1][2]
      endif
   next f

enddo

restscreen(0,0,maxrow(),maxcol(),cScreen)
// m_csron() // Turn on mouse cursor if required.

RETURN NIL // Nothing better to return.
