/*
    File......: GT_TableGet.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 12/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 12/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_TABLEGET()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Edit an element in a table
 *  $SYNTAX$
 *      GT_TableGet(<oBrowse>,<aGets>,[<lIns>],[<lDel>]) - lContinue
 *  $ARGUMENTS$
 *      <oBrowse> is the object passed from the Browse. From
 *      this the element of the <aGets> is derived. If this
 *      is not an Object then is it assumed to be a number
 *      to use directly.
 *
 *      <aGets> is an array of Gets ready for reading.
 *
 *      <lIns> allow inserts to a data file.
 *
 *      <lDel> allow deletions from the datafile.
 *  $RETURNS$
 *      lContinue
 *  $DESCRIPTION$
 *      Edit an element in a table
 *  $EXAMPLES$
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_TableGet(oBrowse,aGets,lIns,lDel)

LOCAL aKeys := {ASC('Y'),ASC('y'),ASC('N'),ASC('n')}
LOCAL lBrowse := .F.
LOCAL lDbf := .F.
LOCAL lEdit := .T.
LOCAL lLastColumn := .F.
LOCAL lReadExit := .F.
LOCAL nColumn := 0
LOCAL nKey := 0
LOCAL nRow := 0
LOCAL nVar := 0

Default oBrowse To 0
Default aGets To {}
Default lIns To .T.
Default lDel To .T.

lBrowse := (VALTYPE(oBrowse) == 'O')

IF lBrowse

    // make sure browse is stable
    DO WHILE !oBrowse:stabilize() ; ENDDO
    nVar := oBrowse:colPos

ELSE

    nVar := oBrowse

ENDIF

//  Restore last character of data
nKey := LASTKEY()
IF GT_IsData(nKey)
    KEYBOARD CHR(nKey)
ENDIF

//  Fill in row and col pos
IF EMPTY(aGets[nVar]:col)
    aGets[nVar]:col := COL()
ELSE
    nColumn := aGets[nVar]:col
ENDIF

IF EMPTY(aGets[nVar]:row)
    aGets[nVar]:row := ROW()
ELSE
    nRow := aGets[nVar]:row
ENDIF

// Is it the last column ?
lLastColumn := (nVar = LEN(aGets))

// Read it
lDbf := '->' $ aGets[nVar]:name
IF IF(lDbf,GT_Locking(.F.),.T.)

    DO CASE
        CASE nKey = K_DEL .AND. lDbf .AND. lDel
            // Del rec
            IF UPPER(CHR(GT_AskUser( ;
                'Delete this entry ? (Y/N)'))) == 'Y'

                GT_Delrec(.T.)

            ENDIF
            lEdit := .F.

        CASE nKey = K_INS .AND. lDBF .AND. lIns
            // Insert
            IF GT_Append()
                KEYBOARD CHR(K_CTRL_HOME)
                oBrowse:RefreshCurrent()
                oBrowse:Stabilize()
            ENDIF

        OTHERWISE
            // Nothing

    ENDCASE

    // Edit
    lReadExit := READEXIT(.T.)
    GT_Read({aGets[nVar]})
    READEXIT(lReadExit)

ENDIF

IF lBrowse
    //  Force redisplay of current row
    oBrowse:refreshCurrent()
ENDIF

//  Check exit key
nKey := LASTKEY()

DO CASE

    CASE .NOT. lBrowse
        // Don't Move

    CASE ( nKey == K_UP .OR. nKey == K_PGUP .OR. nKey == K_DOWN ;
                .OR. nKey == K_PGDN )
        // Move cursor
        KEYBOARD CHR(nKey)

    CASE nKey == K_ENTER
        // Enter
        IF lLastColumn
            KEYBOARD CHR(K_CTRL_HOME) + CHR(K_DOWN)
        ELSE
            KEYBOARD CHR(K_RIGHT)
        ENDIF

    OTHERWISE
        // Ignore

ENDCASE

// Restore old values
aGets[nVar]:col := nColumn
aGets[nVar]:row := nRow

/*
    End of GT_TableGet()
*/
RETURN(.T.)
