/*
 * File......: GT_VALID.PRG
 * Author....: George Brennan
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: George Brennan
 * Date......: 23/03/93
 * Revision..: 1.0
 *
 * This is an original work by George Brennan and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Clipper 5.01a
//


/*  $DOC$
 *  $FUNCNAME$
 *		GT_ISKEYVALID()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *		Conditionally Validate a dbf index key value as UNIQUE
 *  $SYNTAX$
 *		IsKeyValid( <xKey>, <nMode>, <cAlias>, ;
 *							<bLookup>, <bAssign> ) -> lOk
 *  $ARGUMENTS$
 *		<cKey>	 is a valid key value for the current index.
 *
 *		<nMode>  is a manifest constant to conditionally validate the key
 *
 *		<cAlias> is the file alias to validate against
 *
 *		<bLookup> is a code block to display a lookup/picklist
 *
 *		<bAssign> is a codeblock to assign fields to variables
 *
 *  $RETURNS$
 *		A logical value, .T. if the key is conditionally valid
 *
 *	$DESCRIPTION$
 *		GT_ISKEYVALID() can be used to validate a get against an indexed file,
 *				   to ensure a UNIQUE key value.
 *
 *		to validate a new record as UNIQUE,
 *		to validate an edit of an existing record as UNIQUE,
 *		optionally providing a picklist codeblock on failure,
 *		optionally providing an additional assign codeblock on success.
 *
 *  $EXAMPLES$
 *
 * #define NEWRECORD  1
 * #define DISPEDIT   2
 * #define DISPONLY   3
 * #define LOOKUP	  4
 *
 *************************
 *	PROCEDURE test()
 *
 *	   cVatId := "  "
 *	   nVat   := 0.0
 *
 *	   FirstGet( NEWRECORD )
 *	   READ
 *
 *	   SecondGet( LOOKUP )
 *	   READ
 *
 *	RETURN
 **************************
 * function FirstGet( nMode )
 *
 *	 @ 08, 20 SAY "Input a New VAT Code   : " GET cVatId    PICTURE "@K!" ;
 *	   VALID ISKEYVALID( cVatId, nMode ) ;
 *			 when ( nMode == NEWRECORD )
 *
 ***************************
 * function SecondGet( nMode )
 *
 *	 @ 10, 20 SAY "Input current VAT Code : " GET cVatId PICTURE "@K!" ;
 *				  VALID ISKEYVALID( cVatId, LOOKUP, "VAT", ;
 *									{|| vat( @cVatId, @nVat ) }, ;
 *									{ || nVat := vat->Vat } )
 *
 *	 @ 11, 20 GET nVat PICTURE "99999.99" when ( .F. )
 *
 *	return ( NIL )
 ****************************
 *    where : {|| vat( @cVatId, @nVat ) }
 *           is a codeblock calling a picklist which can assign variables
 *           passed by reference.
 *
 *    and   : { || nVat := vat->Vat } )
 *           is a codeblock which will assign ALIAS->FIELD to the
 *           looked up variable refered to.
 *
 *	$END$
 */

#include "gt_lib.ch"    // used to pre-process DEFAULT TO command

#define NEWRECORD  1
#define DISPEDIT   2
#define DISPONLY   3
#define LOOKUP	   4

FUNCTION ISKEYVALID( xKeyExp, nMode, cAlias, bLookup, bAssign )
   LOCAL nStartRec	:=	0
   LOCAL lRecFound	:= .T.
   LOCAL lReturn	:= .F.

   DEFAULT xKeyExp TO &(INDEXKEY( 0 ) )
   DEFAULT nMode  TO DISPONLY
   DEFAULT cAlias TO ALIAS()
   DEFAULT bLookup to {|| .T. }
   DEFAULT bAssign to {|| .T. }

   // don't process function if moving  in GETLIST
   IF nMode == DISPONLY .or. lastkey() == K_UP
      lReturn := .T.
   ELSE
       // remember where we started from
      nStartRec	:=	( cAlias )->( RECNO())

	   // check to see if the key is in the file
      lRecFound := ( cAlias )->(DBSEEK( xKeyExp ))
      DO CASE

	  // if a lookup request was made
      CASE nMode == LOOKUP
		 if ( lReturn := lRecFound ) == .f.
			if bLookup == NIL
			   ALERT("Undefined Value")
			else
			   lReturn := eval( bLookup )
			endif
		 elseif bAssign != NIL

            eval( bAssign )
		 endif

          // if a new record
      CASE nMode == NEWRECORD
         lReturn := ! lRecFound
         IF ! lReturn
            ALERT("Duplicate Value")
         ENDIF

          // if a current record
      CASE nMode == DISPEDIT
         IF lRecFound
            lReturn := ( nStartRec == ( cAlias )->( RECNO() ) )
         ELSE
            lReturn := .T.
         ENDIF

         IF ! lReturn
            ALERT("Duplicate Value")
         ENDIF

      ENDCASE

       // return to original record to leave things tidy
      ( cAlias )->( DBGOTO( nStartRec ) )

   ENDIF

RETURN ( lReturn )

function vat()
dbedit( )

return ( NIL )
