/*
 * File......: LEAPYEAR.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 2.1
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *  1.0 - Original release
 *  2.0 - Corrected bug in year type
 *  2.1 - 19/10/93 - Changed calls from CTOD to GT_STOD
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_LEAPYEAR()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Find out if a date is in a leap year
 *  $SYNTAX$
 *      GT_LeapYear( dDate )
 *  $ARGUMENTS$
 *      dDate - Date to consider - defaults to current date
 *  $RETURNS$
 *      .T. if the date is in a leap year
 *      .F. otherwise
 *  $DESCRIPTION$
 *      Sees if the date that is one day after Feb 28th in the given year
 *      is Feb 29th.  If it is, then we have a leap year.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
*
#include "GT_LIB.CH"

FUNCTION GT_LeapYear( dDate )

/*****************************************************************************
 Purpose - See if the given date falls within a leap year
 Returns - True if in a leap year
 Author  - Martin Colloby
 Created - 4/9/90
******************************************************************************
 Parameters - dDate      - Date to consider
 Locals     - dDate1     - Test date
              lReturn    - Flag to return
              nYear      - Year of date
 Privates   - None
 Externals  - None
*****************************************************************************/

LOCAL dDate1
LOCAL lReturn := .F.
LOCAL nYear   := 0

DEFAULT dDate TO DATE()

IF VALTYPE( dDate ) != "D"
    GT_Warning( "Invalid date type passed to GT_LeapYear !" )
    RETURN NIL
ENDIF

* Find year of p_date
nYear := YEAR( dDate )

* Set test date to 28/2/m_year of p_date
dDate1 := GT_STOD( ALLTRIM( STR( nYear ) ) + "0228" )

* If the day after 28/2/m_year is 29/2/m_year then p_date is on a leap year
IF dDate1++ == GT_STOD( ALLTRIM( STR( nYear ) ) + "0228" )
    RETURN( .T. )
ELSE
    RETURN( .F. )
ENDIF

RETURN NIL
*
