/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: savescr.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_SAVESCR()
 *  $CATEGORY$
 *       Video
 *  $ONELINER$
 *       Save a screen.
 *  $SYNTAX$
 *       GT_saveScr([<nTop>], [<nLeft>], [<nBottom>], [<nRight>])
 *                                                             --> cScr
 *  $ARGUMENTS$
 *       <nTop>    - Top line of screen area to save,
 *                   defaults to 0
 *       <nLeft>   - Leftmost col. of screen area to save,
 *                   default to 0
 *       <nRight>  - Rightmose col. of screen area to save,
 *                   defaults to maxrow()
 *       <nBottom> - Bottom line of screen area to save,
 *                   defaults to maxcol()
 *  $RETURNS$
 *       cScr      - A string consisting og position information +
 *                   saved screen as a character string
 *  $DESCRIPTION$
 *       Save screen (or partial screen) with position
 *
 *       Would have been nicer to save as an array but that would
 *       have wasted too much memory.
 *
 *       NOTE: If you use C, be aware that the return string
 *             can and often does contain embedded NULs
 * $SEEALSO$
 *       GT_RESTSCR()
 *  $EXAMPLES$
 *  $END$
 */

#include "gt_LIB.ch"

function GT_saveScr(nTop, nLeft, nBottom, nRight)

   local cScr

   default nTop    to 0
   default nLeft   to 0
   default nBottom to maxrow()
   default nRight  to maxcol()

   cScr := chr(nTop) + chr(nLeft) + chr(nBottom) + chr(nRight) +;
           savescreen(nTop, nLeft, nBottom, nRight)

return cScr
