/*
 * File......: SPOTLITE.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

// A couple of in-line replacement functions from use with GT_SpotLight().

#xtranslate ScrnOffset(<nRow>,<nCol>) => ;
            ((((<nRow>)*((maxcol()+1)*2))+((<nCol>+1)*2))-1)

#xtranslate GrabScrnLine(<cScreen>,<nRow>,<nCol>,<nWidth>) => ;
            substr(<cScreen>,ScrnOffset(<nRow>,<nCol>),(<nWidth>)*2)

/*  $DOC$
 *  $FUNCNAME$
 *      GT_SPOTLIGHT()
 *  $CATEGORY$
 *      Screen Saver
 *  $ONELINER$
 *      Spotlight screen saver.
 *  $SYNTAX$
 *      GT_SpotLight([<nDelay>]) --> NIL
 *  $ARGUMENTS$
 *      <nDelay> is an optional numeric parameter that is the delay to
 *      use when updating the display. This is in 1/18ths of a second.
 *      If not supplied this parameter defaults to 2.
 *  $RETURNS$
 *      Nothing.
 *  $DESCRIPTION$
 *      GT_SpotLight() is a screen saver function.
 *  $EXAMPLES$
 *      // Call the screen saver with a delay of 3/18 of a second.
 *
 *      GT_SpotLight(3)
 *  $END$
 */

function GT_SpotLight(nDelay)
local cScreen    := savescreen()      ,;
      nTop       := 0                 ,;
      nLeft      := 0                 ,;
      nBottom    := 4                 ,;
      nRight     := 12                ,;
      nXMove     := 1                 ,;
      nYMove     := 1                 ,;
      nLine      := 0                 ,;
      cSpotLight := NULL              ,;
      hOldScreen := GT_SaveScr()      ,;
      nOldCursor := setcursor(SC_NONE),;
      cOldColour := setcolor("w/n")   ,;
      bQuit      := GT_Interrupt()
default nDelay to 2
default bQuit  to {|| inkey() != 0 }
scroll()
do while !eval(bQuit)
   cSpotLight := NULL
   for nLine := nTop to nBottom
      cSpotLight += GrabScrnLine(cScreen,nLine,nLeft,(nRight-nLeft)+1)
   next
   dispbegin()
   scroll()
   restscreen(nTop,nLeft,nBottom,nRight,cSpotLight)
   dispend()
   tone(0,2)
   if nXMove == 1
      nXMove := if(nRight == maxcol(),-1,nXMove)
   else
      nXMove := if(nLeft == 0,1,nXMove)
   endif
   if nYMove == 1
      nYMove := if(nBottom == maxrow(),-1,nYMove)
   else
      nYMove := if(nTop == 0,1,nYMove)
   endif
   nTop    += nYMove
   nLeft   += nXMove
   nBottom += nYMove
   nRight  += nXMove
enddo
setcolor(cOldColour)
GT_RestScr(hOldScreen)
setcursor(nOldCursor)
return(NIL)
