/*
 * File......: USEDBF.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_USEDBF()
 *  $CATEGORY$
 *      Network
 *  $ONELINER$
 *      Open a table
 *  $SYNTAX$
 *      GT_UseDbf( cDbf , aIndex , cAlias , lPack , lReindex , ;
 *                 lExclusive , nTimeOut , lFatal )
 *  $ARGUMENTS$
 *      cDbf       - Database to open
 *      aIndex     - Index to open
 *      cAlias     - Alias to use
 *      lPack      - If .T. we pack the database
 *      lReindex   - If .T. we reindex the database
 *      lExclusive - If .T. open exclusive
 *      nTimeOut   - Number of seconds to retry for
 *      lFatal     - If .T. generate a fatal error on failure
 *  $RETURNS$
 *      .T. if successful
 *      .F. otherwise
 *  $DESCRIPTION$
 *      Opens the table in the required mode.  If it fails, has nTimeOut
 *      retries.
 *      When the table is opened, the indexes are opened, and the table
 *      will hten be packed or reindexed is required.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.ch"

FUNCTION GT_UseDbf( cDbf , aIndex , cAlias , lPack , lReindex , ;
                    lExclusive , nTimeOut , lFatal )

/****************************************************************************
 Purpose - Open the given database
 Returns - .T. if successful
 Author  - Martin Colloby
 Created - 23/8/91
******************************************************************************
 Parameters - cDbf         - Database to open
              aIndex       - Index to open
              cAlias       - Alias to use
              lPack        - If .T. we pack the database
              lReindex     - If .T. we reindex the database
              lExclusive   - If .T. open exclusive
              nTimeOut     - Number of seconds to retry for
              lFatal       - If .T. generate a fatal error on failure
 Locals     - lReturn      - Value to return
 Externals  - cDefaultPath - Default path of .EXE file
****************************************************************************/

LOCAL aActIndex  := { "", "", "", "", "", "", "", "", "", "", "", "", "", "", "" }
LOCAL cIndex     := ""
LOCAL cTempIndex := ""
LOCAL lReturn    := .F.
LOCAL lForever   := .F.
LOCAL nCount     := 0

DEFAULT nTimeOut   TO 0
DEFAULT lFatal     TO .F.
DEFAULT lExclusive TO .F.
DEFAULT lPack      TO .F.
DEFAULT lReindex   TO .F.

lForever   := (nTimeOut == 0)
cDbf       := cDefaultPath + "\tables\" + cDbf
cIndex     := ""

IF !FILE( cDbf + ".dbf" )
    GT_Warning( { "Cannot find tables " + cDbf } )
    RETURN( .F. )
ENDIF

IF LEN( aIndex ) > 0
    FOR nCount := 1 TO LEN( aIndex )
        cTempIndex := cDefaultPath + "\tables\" + aIndex[nCount]
        IF !FILE( cTempIndex + INDEXEXT() )
            GT_Warning( { "Cannot find index  " + cTempIndex } )
            RETURN( .F. )
        ENDIF

        aActIndex[nCount] := cTempIndex

    NEXT nCount
ENDIF

DO WHILE ( lForever .OR. nTimeOut > 0 )
    IF lExclusive
        USE (cDbf) ALIAS (cAlias) NEW EXCLUSIVE
    ELSE
        USE (cDbf) ALIAS (cAlias) NEW SHARED
    ENDIF

    IF .NOT. NETERR()

        SET INDEX TO ( aActIndex[1] ),;
                     ( aActIndex[2] ),;
                     ( aActIndex[3] ),;
                     ( aActIndex[4] ),;
                     ( aActIndex[5] ),;
                     ( aActIndex[6] ),;
                     ( aActIndex[7] ),;
                     ( aActIndex[8] ),;
                     ( aActIndex[9] ),;
                     ( aActIndex[10] ),;
                     ( aActIndex[11] ),;
                     ( aActIndex[12] ),;
                     ( aActIndex[13] ),;
                     ( aActIndex[14] ),;
                     ( aActIndex[15] )

        IF lPack .AND. lExclusive
            SET ORDER TO 0
            PACK
            SET ORDER TO 1
        ENDIF

        IF ( lReindex .AND. .NOT. lPack ) .AND. lExclusive
            REINDEX
        ENDIF

        RETURN( .T. )
    ENDIF

    INKEY( 1 )
    nTimeOut --
ENDDO

GT_Warning( "Could not open table " + cDbf )

RETURN( .F. )
*
